/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.FlapPacketEvent;
import net.kano.joscar.flap.FlapProcessor;
import net.kano.joscar.flap.VetoableFlapPacketListener;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacFlapCmd;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdFactoryMgr;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.MutableSnacPacket;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacPacketListener;
import net.kano.joscar.snac.SnacPreprocessor;
import net.kano.joscar.snac.VetoableSnacPacketListener;

public abstract class AbstractSnacProcessor {
    public static final Object ERRTYPE_SNAC_PACKET_PREPROCESSOR = "ERRTYPE_SNAC_PACKET_PREPROCESSOR";
    public static final Object ERRTYPE_SNAC_PACKET_LISTENER = "ERRTYPE_SNAC_PACKET_LISTENER";
    private static final Logger logger = Logger.getLogger("net.kano.joscar.snac");
    private boolean attached = false;
    private FlapProcessor flapProcessor;
    private final Object readLock = new Object();
    private final CmdFactoryMgr factories = new CmdFactoryMgr();
    private final CopyOnWriteArrayList preprocessors = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList vetoableListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList packetListeners = new CopyOnWriteArrayList();
    private VetoableFlapPacketListener flapPacketListener = new VetoableFlapPacketListener(){

        public Object handlePacket(FlapPacketEvent flapPacketEvent) {
            if (flapPacketEvent.getFlapCommand() instanceof SnacFlapCmd) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("SnacProcessor intercepted channel-2 snac command");
                }
                AbstractSnacProcessor.this.processPacket(flapPacketEvent);
                return STOP_PROCESSING_LISTENERS;
            }
            return CONTINUE_PROCESSING;
        }
    };

    protected AbstractSnacProcessor(FlapProcessor flapProcessor) {
        DefensiveTools.checkNull(flapProcessor, "flapProcessor");
        this.flapProcessor = flapProcessor;
        this.attached = true;
        this.setupFlapProcessor();
    }

    private void setupFlapProcessor() {
        this.getFlapProcessor().addVetoablePacketListener(this.flapPacketListener);
    }

    private void resetFlapProcessor() {
        this.getFlapProcessor().removeVetoablePacketListener(this.flapPacketListener);
    }

    protected synchronized void migrate(FlapProcessor flapProcessor) {
        DefensiveTools.checkNull(flapProcessor, "processor");
        if (!this.attached) {
            throw new IllegalStateException("cannot migrate when no longer attached");
        }
        this.resetFlapProcessor();
        this.flapProcessor = flapProcessor;
        this.setupFlapProcessor();
    }

    public final synchronized FlapProcessor getFlapProcessor() {
        return this.flapProcessor;
    }

    public final synchronized boolean isAttached() {
        return this.attached;
    }

    public synchronized void detach() {
        if (!this.attached) {
            return;
        }
        this.resetFlapProcessor();
        this.attached = false;
    }

    public final void addPacketListener(SnacPacketListener snacPacketListener) {
        DefensiveTools.checkNull(snacPacketListener, "l");
        this.packetListeners.addIfAbsent(snacPacketListener);
    }

    public final void removePacketListener(SnacPacketListener snacPacketListener) {
        DefensiveTools.checkNull(snacPacketListener, "l");
        this.packetListeners.remove(snacPacketListener);
    }

    public final void addVetoablePacketListener(VetoableSnacPacketListener vetoableSnacPacketListener) {
        DefensiveTools.checkNull(vetoableSnacPacketListener, "l");
        this.vetoableListeners.addIfAbsent(vetoableSnacPacketListener);
    }

    public final void removeVetoablePacketListener(VetoableSnacPacketListener vetoableSnacPacketListener) {
        DefensiveTools.checkNull(vetoableSnacPacketListener, "l");
        this.vetoableListeners.remove(vetoableSnacPacketListener);
    }

    public final void addPreprocessor(SnacPreprocessor snacPreprocessor) {
        DefensiveTools.checkNull(snacPreprocessor, "p");
        this.preprocessors.addIfAbsent(snacPreprocessor);
    }

    public final void removePreprocessor(SnacPreprocessor snacPreprocessor) {
        DefensiveTools.checkNull(snacPreprocessor, "p");
        this.preprocessors.remove(snacPreprocessor);
    }

    public final CmdFactoryMgr getCmdFactoryMgr() {
        return this.factories;
    }

    protected boolean continueHandling(SnacPacketEvent snacPacketEvent) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(FlapPacketEvent flapPacketEvent) {
        FlapProcessor flapProcessor;
        boolean bl = logger.isLoggable(Level.FINE);
        boolean bl2 = logger.isLoggable(Level.FINER);
        Object object = this;
        synchronized (object) {
            if (!this.attached) {
                return;
            }
            flapProcessor = this.flapProcessor;
        }
        object = (SnacFlapCmd)flapPacketEvent.getFlapCommand();
        SnacPacket snacPacket = ((SnacFlapCmd)object).getSnacPacket();
        Object object2 = this.readLock;
        synchronized (object2) {
            Object object3;
            Object object4;
            MutableSnacPacket mutableSnacPacket = null;
            Object object5 = this.preprocessors.iterator();
            while (object5.hasNext()) {
                object4 = (SnacPreprocessor)object5.next();
                if (mutableSnacPacket == null) {
                    mutableSnacPacket = new MutableSnacPacket(snacPacket);
                }
                if (bl2) {
                    logger.finer("Running snac preprocessor " + object4);
                }
                try {
                    object4.process(mutableSnacPacket);
                }
                catch (Throwable throwable) {
                    if (bl2) {
                        logger.finer("Preprocessor " + object4 + " threw exception " + throwable);
                    }
                    flapProcessor.handleException(ERRTYPE_SNAC_PACKET_PREPROCESSOR, throwable, object4);
                }
            }
            if (mutableSnacPacket != null && mutableSnacPacket.isChanged()) {
                snacPacket = mutableSnacPacket.toSnacPacket();
            }
            object5 = this.generateSnacCommand(snacPacket);
            if (bl) {
                logger.fine("Converted Snac packet " + snacPacket + " to " + object5);
            }
            if (!this.continueHandling((SnacPacketEvent)(object4 = new SnacPacketEvent(flapPacketEvent, this, snacPacket, (SnacCommand)object5)))) {
                return;
            }
            Iterator iterator = this.vetoableListeners.iterator();
            while (iterator.hasNext()) {
                Object object6;
                object3 = (VetoableSnacPacketListener)iterator.next();
                if (bl2) {
                    logger.finer("Running vetoable Snac packet listener " + object3);
                }
                try {
                    object6 = object3.handlePacket((SnacPacketEvent)object4);
                }
                catch (Throwable throwable) {
                    flapProcessor.handleException(ERRTYPE_SNAC_PACKET_LISTENER, throwable, object3);
                    continue;
                }
                if (object6 == VetoableSnacPacketListener.CONTINUE_PROCESSING) continue;
                return;
            }
            iterator = this.packetListeners.iterator();
            while (iterator.hasNext()) {
                object3 = (SnacPacketListener)iterator.next();
                if (bl2) {
                    logger.finer("Running Snac packet listener " + object3);
                }
                try {
                    object3.handleSnacPacket((SnacPacketEvent)object4);
                }
                catch (Throwable throwable) {
                    flapProcessor.handleException(ERRTYPE_SNAC_PACKET_LISTENER, throwable, object3);
                }
            }
            if (bl2) {
                logger.finer("Finished processing Snac");
            }
        }
    }

    private SnacCommand generateSnacCommand(SnacPacket snacPacket) {
        CmdType cmdType = new CmdType(snacPacket.getFamily(), snacPacket.getCommand());
        SnacCmdFactory snacCmdFactory = this.factories.findFactory(cmdType);
        if (snacCmdFactory == null) {
            return null;
        }
        return snacCmdFactory.genSnacCommand(snacPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void sendSnac(long l, SnacCommand snacCommand) {
        FlapProcessor flapProcessor;
        AbstractSnacProcessor abstractSnacProcessor = this;
        synchronized (abstractSnacProcessor) {
            if (!this.attached) {
                return;
            }
            flapProcessor = this.getFlapProcessor();
        }
        flapProcessor.sendFlap(new SnacFlapCmd(l, snacCommand));
    }
}

