/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.ft;

import java.util.zip.Checksum;
import net.kano.joscar.DefensiveTools;

public final class FileTransferChecksum
implements Checksum {
    private static final long CHECKSUM_INIT = -65536L;
    private long checksum;

    public FileTransferChecksum() {
        this.reset();
    }

    public void update(int n) {
        this.update(new byte[]{(byte)n}, 0, 1);
    }

    public void update(byte[] byArray, int n, int n2) {
        DefensiveTools.checkNull(byArray, "input");
        long l = this.checksum >> 16 & 0xFFFFL;
        for (int i = 0; i < n2; ++i) {
            long l2 = l;
            int n3 = byArray[n + i] & 0xFF;
            int n4 = (i & 1) != 0 ? n3 : n3 << 8;
            if ((l -= (long)n4) <= l2) continue;
            --l;
        }
        l = (l & 0xFFFFL) + (l >> 16);
        l = (l & 0xFFFFL) + (l >> 16);
        this.checksum = l << 16 & 0xFFFFFFFFFFFFFFFFL;
    }

    public long getValue() {
        return this.checksum;
    }

    public void reset() {
        this.checksum = -65536L;
    }
}

