/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class AbstractRvCmd
extends RvCommand {
    private static final int TYPE_SERVICE_DATA = 10001;
    private final ByteBlock serviceData;
    private final MutableTlvChain rvTlvs;

    protected AbstractRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        ByteBlock byteBlock = recvRvIcbm.getRvData();
        if (byteBlock != null) {
            ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
            Tlv tlv = immutableTlvChain.getLastTlv(10001);
            this.serviceData = tlv == null ? null : tlv.getData();
            MutableTlvChain mutableTlvChain = TlvTools.getMutableCopy(immutableTlvChain);
            mutableTlvChain.removeTlvs(new int[]{10001});
            this.rvTlvs = mutableTlvChain;
        } else {
            this.serviceData = null;
            this.rvTlvs = TlvTools.createMutableChain();
        }
    }

    protected AbstractRvCmd(int n, CapabilityBlock capabilityBlock) {
        super(n, capabilityBlock);
        this.serviceData = null;
        this.rvTlvs = null;
    }

    protected final ByteBlock getServiceData() {
        return this.serviceData;
    }

    protected final TlvChain getRvTlvs() {
        return this.rvTlvs;
    }

    final MutableTlvChain getMutableTlvs() {
        return this.rvTlvs;
    }

    public final void writeRvData(OutputStream outputStream) throws IOException {
        DefensiveTools.checkNull(outputStream, "out");
        this.writeHeaderRvTlvs(outputStream);
        this.writeRvTlvs(outputStream);
        if (this.hasServiceData()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeServiceData(byteArrayOutputStream);
            ByteBlock byteBlock = ByteBlock.wrap(byteArrayOutputStream.toByteArray());
            new Tlv(10001, byteBlock).write(outputStream);
        }
    }

    protected abstract void writeHeaderRvTlvs(OutputStream var1) throws IOException;

    protected abstract void writeRvTlvs(OutputStream var1) throws IOException;

    protected boolean hasServiceData() {
        return true;
    }

    protected void writeServiceData(OutputStream outputStream) throws IOException {
    }
}

