/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.client;

import com.hazelcast.client.impl.client.MultiTargetClientRequest;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.transaction.client.ClientTxnPortableHook;
import com.hazelcast.transaction.impl.xa.CollectRemoteTransactionsOperationFactory;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class CollectXATransactionsRequest
extends MultiTargetClientRequest {
    @Override
    protected OperationFactory createOperationFactory() {
        return new CollectRemoteTransactionsOperationFactory();
    }

    @Override
    protected Object reduce(Map<Address, Object> map) {
        HashSet<Data> set = new HashSet<Data>();
        for (Object o : map.values()) {
            SerializableCollection xidSet = (SerializableCollection)o;
            set.addAll(xidSet.getCollection());
        }
        return new SerializableCollection(set);
    }

    @Override
    public Collection<Address> getTargets() {
        Collection<MemberImpl> memberList = this.getClientEngine().getClusterService().getMemberList();
        HashSet<Address> addresses = new HashSet<Address>();
        for (MemberImpl member : memberList) {
            addresses.add(member.getAddress());
        }
        return addresses;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:xaService";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public Permission getRequiredPermission() {
        return new TransactionPermission();
    }
}

