/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.eventservice.impl;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventRegistration;
import java.io.IOException;

public class Registration
implements EventRegistration {
    private String id;
    private String serviceName;
    private String topic;
    private EventFilter filter;
    private Address subscriber;
    private transient boolean localOnly;
    private transient Object listener;

    public Registration() {
    }

    public Registration(String id, String serviceName, String topic, EventFilter filter, Address subscriber, Object listener, boolean localOnly) {
        this.filter = filter;
        this.id = id;
        this.listener = listener;
        this.serviceName = serviceName;
        this.topic = topic;
        this.subscriber = subscriber;
        this.localOnly = localOnly;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTopic() {
        return this.topic;
    }

    @Override
    public EventFilter getFilter() {
        return this.filter;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Address getSubscriber() {
        return this.subscriber;
    }

    @Override
    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public Object getListener() {
        return this.listener;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Registration that = (Registration)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        return !(this.subscriber != null ? !this.subscriber.equals(that.subscriber) : that.subscriber != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.subscriber != null ? this.subscriber.hashCode() : 0);
        return result;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeUTF(this.serviceName);
        out.writeUTF(this.topic);
        this.subscriber.writeData(out);
        out.writeObject(this.filter);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.id = in.readUTF();
        this.serviceName = in.readUTF();
        this.topic = in.readUTF();
        this.subscriber = new Address();
        this.subscriber.readData(in);
        this.filter = (EventFilter)in.readObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Registration");
        sb.append("{filter=").append(this.filter);
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", serviceName='").append(this.serviceName).append('\'');
        sb.append(", subscriber=").append(this.subscriber);
        sb.append(", listener=").append(this.listener);
        sb.append('}');
        return sb.toString();
    }
}

