/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.util.Clock;
import com.hazelcast.util.JsonUtil;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class NearCacheStatsImpl
implements NearCacheStats {
    private static final double PERCENTAGE = 100.0;
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> OWNED_ENTRY_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "ownedEntryCount");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> OWNED_ENTRY_MEMORY_COST_UPDATER = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "ownedEntryMemoryCost");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> HITS_UPDATER = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "hits");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> MISSES_UPDATER = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "misses");
    private volatile long creationTime = Clock.currentTimeMillis();
    private volatile long ownedEntryCount;
    private volatile long ownedEntryMemoryCost;
    private volatile long hits;
    private volatile long misses;

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        OWNED_ENTRY_COUNT_UPDATER.set(this, ownedEntryCount);
    }

    public void incrementOwnedEntryCount() {
        OWNED_ENTRY_COUNT_UPDATER.incrementAndGet(this);
    }

    public void decrementOwnedEntryCount() {
        OWNED_ENTRY_COUNT_UPDATER.decrementAndGet(this);
    }

    @Override
    public long getOwnedEntryMemoryCost() {
        return this.ownedEntryMemoryCost;
    }

    public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST_UPDATER.set(this, ownedEntryMemoryCost);
    }

    public void incrementOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST_UPDATER.addAndGet(this, ownedEntryMemoryCost);
    }

    public void decrementOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST_UPDATER.addAndGet(this, -ownedEntryMemoryCost);
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    public void incrementHits() {
        HITS_UPDATER.incrementAndGet(this);
    }

    public void setHits(long hits) {
        HITS_UPDATER.set(this, hits);
    }

    @Override
    public long getMisses() {
        return this.misses;
    }

    public void setMisses(long misses) {
        MISSES_UPDATER.set(this, misses);
    }

    public void incrementMisses() {
        MISSES_UPDATER.incrementAndGet(this);
    }

    @Override
    public double getRatio() {
        if (this.misses == 0L) {
            if (this.hits == 0L) {
                return Double.NaN;
            }
            return Double.POSITIVE_INFINITY;
        }
        return (double)this.hits / (double)this.misses * 100.0;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("ownedEntryCount", this.ownedEntryCount);
        root.add("ownedEntryMemoryCost", this.ownedEntryMemoryCost);
        root.add("creationTime", this.creationTime);
        root.add("hits", this.hits);
        root.add("misses", this.misses);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.ownedEntryCount = JsonUtil.getLong(json, "ownedEntryCount", -1L);
        this.ownedEntryMemoryCost = JsonUtil.getLong(json, "ownedEntryMemoryCost", -1L);
        this.creationTime = JsonUtil.getLong(json, "creationTime", -1L);
        this.hits = JsonUtil.getLong(json, "hits", -1L);
        this.misses = JsonUtil.getLong(json, "misses", -1L);
    }

    public String toString() {
        return "NearCacheStatsImpl{ownedEntryCount=" + this.ownedEntryCount + ", ownedEntryMemoryCost=" + this.ownedEntryMemoryCost + ", creationTime=" + this.creationTime + ", hits=" + this.hits + ", misses=" + this.misses + ", ratio=" + String.format("%.1f%%", this.getRatio()) + '}';
    }
}

