/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.MultiTargetClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.operation.RemoveInterceptorOperationFactory;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class MapRemoveInterceptorRequest
extends MultiTargetClientRequest
implements Portable,
SecureRequest {
    private String name;
    private String id;

    public MapRemoveInterceptorRequest() {
    }

    public MapRemoveInterceptorRequest(String name, String id) {
        this.name = name;
        this.id = id;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 24;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new RemoveInterceptorOperationFactory(this.id, this.name);
    }

    @Override
    protected Object reduce(Map<Address, Object> map) {
        for (Object result : map.values()) {
            if (!(result instanceof Throwable)) continue;
            return result;
        }
        return true;
    }

    @Override
    public Collection<Address> getTargets() {
        Collection<MemberImpl> memberList = this.getClientEngine().getClusterService().getMemberList();
        HashSet<Address> addresses = new HashSet<Address>();
        for (MemberImpl member : memberList) {
            addresses.add(member.getAddress());
        }
        return addresses;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("id", this.id);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.id = reader.readUTF("id");
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "intercept");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "removeInterceptor";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.id};
    }
}

