/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.countdownlatch;

import com.hazelcast.concurrent.countdownlatch.CountDownLatchService;
import com.hazelcast.concurrent.countdownlatch.operations.AwaitOperation;
import com.hazelcast.concurrent.countdownlatch.operations.CountDownOperation;
import com.hazelcast.concurrent.countdownlatch.operations.GetCountOperation;
import com.hazelcast.concurrent.countdownlatch.operations.SetCountOperation;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class CountDownLatchProxy
extends AbstractDistributedObject<CountDownLatchService>
implements ICountDownLatch {
    private final String name;
    private final int partitionId;

    public CountDownLatchProxy(String name, NodeEngine nodeEngine) {
        super(nodeEngine, null);
        this.name = name;
        Data nameAsPartitionAwareData = this.getNameAsPartitionAwareData();
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(nameAsPartitionAwareData);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        AwaitOperation op = new AwaitOperation(this.name, CountDownLatchProxy.getTimeInMillis(timeout, unit));
        InternalCompletableFuture f = this.invoke(op);
        try {
            return (Boolean)f.get();
        }
        catch (ExecutionException e) {
            throw ExceptionUtil.rethrowAllowInterrupted(e);
        }
    }

    private static long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    public void countDown() {
        CountDownOperation op = new CountDownOperation(this.name);
        InternalCompletableFuture f = this.invoke(op);
        f.getSafely();
    }

    @Override
    public int getCount() {
        GetCountOperation op = new GetCountOperation(this.name);
        InternalCompletableFuture f = this.invoke(op);
        return (Integer)f.getSafely();
    }

    @Override
    public boolean trySetCount(int count) {
        Preconditions.checkNotNegative(count, "count can't be negative");
        SetCountOperation op = new SetCountOperation(this.name, count);
        InternalCompletableFuture f = this.invoke(op);
        return (Boolean)f.getSafely();
    }

    private InternalCompletableFuture invoke(Operation op) {
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        return operationService.invokeOnPartition("hz:impl:countDownLatchService", op, this.partitionId);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:countDownLatchService";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ICountDownLatch{");
        sb.append("name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

