/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class CacheListenerRegistrationCodec {
    public static final CacheMessageType REQUEST_TYPE = CacheMessageType.CACHE_LISTENERREGISTRATION;
    public static final int RESPONSE_TYPE = 100;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, Data listenerConfig, boolean register, String hostname, int port) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, listenerConfig, register, hostname, port);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(listenerConfig);
        clientMessage.set(register);
        clientMessage.set(hostname);
        clientMessage.set(port);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        int port;
        boolean register;
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        Data listenerConfig = null;
        parameters.listenerConfig = listenerConfig = clientMessage.getData();
        parameters.register = register = clientMessage.getBoolean();
        String hostname = null;
        parameters.hostname = hostname = clientMessage.getStringUtf8();
        parameters.port = port = clientMessage.getInt();
        return parameters;
    }

    public static ClientMessage encodeResponse() {
        int requiredDataSize = ResponseParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(100);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        return parameters;
    }

    public static class ResponseParameters {
        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final CacheMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Data listenerConfig;
        public boolean register;
        public String hostname;
        public int port;

        public static int calculateDataSize(String name, Data listenerConfig, boolean register, String hostname, int port) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateStringDataSize(name);
            dataSize += ParameterUtil.calculateDataSize(listenerConfig);
            ++dataSize;
            dataSize += ParameterUtil.calculateStringDataSize(hostname);
            return dataSize += 4;
        }
    }
}

