/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CachePutAllBackupOperation
extends AbstractNamedOperation
implements BackupOperation,
IdentifiedDataSerializable {
    private Map<Data, CacheRecord> cacheRecords;
    private transient ICacheRecordStore cache;

    public CachePutAllBackupOperation() {
    }

    public CachePutAllBackupOperation(String name, Map<Data, CacheRecord> cacheRecords) {
        super(name);
        this.cacheRecords = cacheRecords;
    }

    @Override
    public void beforeRun() throws Exception {
        CacheService service = (CacheService)this.getService();
        this.cache = service.getOrCreateCache(this.name, this.getPartitionId());
    }

    @Override
    public void run() throws Exception {
        if (this.cacheRecords != null) {
            for (Map.Entry<Data, CacheRecord> entry : this.cacheRecords.entrySet()) {
                this.cache.putRecord(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.cacheRecords != null);
        if (this.cacheRecords != null) {
            out.writeInt(this.cacheRecords.size());
            for (Map.Entry<Data, CacheRecord> entry : this.cacheRecords.entrySet()) {
                Data key = entry.getKey();
                CacheRecord record = entry.getValue();
                out.writeData(key);
                out.writeObject(record);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        boolean recordNotNull = in.readBoolean();
        if (recordNotNull) {
            int size = in.readInt();
            this.cacheRecords = new HashMap<Data, CacheRecord>(size);
            for (int i = 0; i < size; ++i) {
                Data key = in.readData();
                CacheRecord record = (CacheRecord)in.readObject();
                this.cacheRecords.put(key, record);
            }
        }
    }

    @Override
    public int getId() {
        return 10;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }
}

