/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Patch
extends Task {
    private File originalFile;
    private File directory;
    private boolean havePatchfile;
    private Commandline cmd;

    public void setOriginalfile(File file) {
        this.originalFile = file;
    }

    public void setDestfile(File file) {
        if (file != null) {
            this.cmd.createArgument().setValue("-o");
            this.cmd.createArgument().setFile(file);
        }
    }

    public void setPatchfile(File file) {
        if (!file.exists()) {
            throw new BuildException("patchfile " + file + " doesn't exist", this.getLocation());
        }
        this.cmd.createArgument().setValue("-i");
        this.cmd.createArgument().setFile(file);
        this.havePatchfile = true;
    }

    public void setBackups(boolean bl) {
        if (bl) {
            this.cmd.createArgument().setValue("-b");
        }
    }

    public void setIgnorewhitespace(boolean bl) {
        if (bl) {
            this.cmd.createArgument().setValue("-l");
        }
    }

    public void setStrip(int n) throws BuildException {
        if (n < 0) {
            throw new BuildException("strip has to be >= 0", this.getLocation());
        }
        this.cmd.createArgument().setValue("-p" + n);
    }

    public void setQuiet(boolean bl) {
        if (bl) {
            this.cmd.createArgument().setValue("-s");
        }
    }

    public void setReverse(boolean bl) {
        if (bl) {
            this.cmd.createArgument().setValue("-R");
        }
    }

    public void setDir(File file) {
        this.directory = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Execute execute;
        Commandline commandline;
        block7: {
            if (!this.havePatchfile) {
                throw new BuildException("patchfile argument is required", this.getLocation());
            }
            commandline = (Commandline)this.cmd.clone();
            commandline.setExecutable("patch");
            if (this.originalFile != null) {
                commandline.createArgument().setFile(this.originalFile);
            }
            execute = new Execute(new LogStreamHandler(this, 2, 1), null);
            execute.setCommandline(commandline.getCommandline());
            if (this.directory != null) {
                if (this.directory.exists() && this.directory.isDirectory()) {
                    execute.setWorkingDirectory(this.directory);
                    break block7;
                } else {
                    if (this.directory.isDirectory()) throw new BuildException("directory " + this.directory + " doesn't exist", this.getLocation());
                    throw new BuildException(this.directory + " is not a directory.", this.getLocation());
                }
            }
            execute.setWorkingDirectory(this.getProject().getBaseDir());
        }
        this.log(commandline.describeCommand(), 3);
        try {
            execute.execute();
            return;
        }
        catch (IOException iOException) {
            throw new BuildException(iOException, this.getLocation());
        }
    }

    private final /* synthetic */ void this() {
        this.havePatchfile = false;
        this.cmd = new Commandline();
    }

    public Patch() {
        this.this();
    }
}

