/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin.jmx;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConfigurationListenerIF;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.ProxoolListenerIF;
import org.logicalcobwebs.proxool.admin.jmx.ProxoolJMXHelper;

public class ConnectionPoolMBean
implements DynamicMBean,
MBeanRegistration,
NotificationBroadcaster,
ProxoolListenerIF,
ConfigurationListenerIF {
    public static final String NOTIFICATION_TYPE_DEFINITION_UPDATED = "proxool.definitionUpdated";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$logicalcobwebs$proxool$admin$jmx$ConnectionPoolMBean == null ? (class$org$logicalcobwebs$proxool$admin$jmx$ConnectionPoolMBean = ConnectionPoolMBean.class$("org.logicalcobwebs.proxool.admin.jmx.ConnectionPoolMBean")) : class$org$logicalcobwebs$proxool$admin$jmx$ConnectionPoolMBean));
    private static final String CLASS_NAME = (class$org$logicalcobwebs$proxool$admin$jmx$ConnectionPoolMBean == null ? (class$org$logicalcobwebs$proxool$admin$jmx$ConnectionPoolMBean = ConnectionPoolMBean.class$("org.logicalcobwebs.proxool.admin.jmx.ConnectionPoolMBean")) : class$org$logicalcobwebs$proxool$admin$jmx$ConnectionPoolMBean).getName();
    private static final String RECOURCE_NAME_MBEAN_POOL_DESCRIPTION = "mbean.pool.description";
    private static final String RECOURCE_NAME_MBEAN_NOTIFICATION_DESCRIPTION = "mbean.notification.description";
    private static final String RECOURCE_NAME_MBEAN_NOTIFICATION_DEF_UPDATED = "mbean.notification.defUpdated";
    private static final String OPERATION_NAME_SHUTDOWN = "shutdown";
    private static final ResourceBundle ATTRIBUTE_DESCRIPTIONS_RESOURCE = ConnectionPoolMBean.createAttributeDescriptionsResource();
    private static final ResourceBundle JMX_RESOURCE = ConnectionPoolMBean.createJMXResource();
    private static final MBeanNotificationInfo[] NOTIFICATION_INFOS = ConnectionPoolMBean.getNotificationInfos();
    private MBeanInfo mBeanInfo;
    private ConnectionPoolDefinitionIF poolDefinition;
    private Properties poolProperties;
    private long definitionUpdatedSequence;
    private NotificationBroadcasterSupport notificationHelper = new NotificationBroadcasterSupport();
    private boolean active;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$admin$jmx$ConnectionPoolMBean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$management$Notification;

    public ConnectionPoolMBean(String alias, Properties poolProperties) throws ProxoolException {
        this.poolDefinition = ProxoolFacade.getConnectionPoolDefinition(alias);
        this.poolProperties = poolProperties;
        this.mBeanInfo = this.getDynamicMBeanInfo(this.poolDefinition.getAlias());
        ProxoolFacade.addProxoolListener(this);
        ProxoolFacade.addConfigurationListener(alias, this);
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null) {
            String message = "Cannot invoke a getter of " + CLASS_NAME + " with null attribute name";
            LOG.error((Object)message);
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), message);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting attribute " + attributeName + "."));
        }
        return ((Attribute)this.getAttributes(new String[]{attributeName}).get(0)).getValue();
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            String message = "Cannot invoke a setter of " + CLASS_NAME + " with null attribute";
            LOG.error((Object)message);
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), message);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting attribute " + attribute.getName() + "."));
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(attribute);
        this.setAttributes(attributeList);
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            String message = "Cannot invoke a null getter of " + CLASS_NAME;
            LOG.error((Object)message);
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), message);
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                if (this.equalsProperty(attributeNames[i], "alias")) {
                    resultList.add(new Attribute(attributeNames[i], this.poolDefinition.getAlias()));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "driver-properties")) {
                    resultList.add(new Attribute(attributeNames[i], this.getDelegatePropertiesAsString(this.poolProperties)));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "driver-url")) {
                    resultList.add(new Attribute(attributeNames[i], this.poolDefinition.getUrl()));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "fatal-sql-exception")) {
                    resultList.add(new Attribute(attributeNames[i], this.getValueOrEmpty(this.poolProperties.getProperty("proxool.fatal-sql-exception"))));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "house-keeping-sleep-time")) {
                    resultList.add(new Attribute(attributeNames[i], new Long(this.poolDefinition.getHouseKeepingSleepTime())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "house-keeping-test-sql")) {
                    resultList.add(new Attribute(attributeNames[i], this.getValueOrEmpty(this.poolDefinition.getHouseKeepingTestSql())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "test-before-use")) {
                    resultList.add(new Attribute(attributeNames[i], new Boolean(this.poolDefinition.isTestBeforeUse())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "test-after-use")) {
                    resultList.add(new Attribute(attributeNames[i], new Boolean(this.poolDefinition.isTestAfterUse())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "maximum-active-time")) {
                    resultList.add(new Attribute(attributeNames[i], new Long(this.poolDefinition.getMaximumActiveTime())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "maximum-connection-count")) {
                    resultList.add(new Attribute(attributeNames[i], new Integer(this.poolDefinition.getMaximumConnectionCount())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "maximum-connection-lifetime")) {
                    resultList.add(new Attribute(attributeNames[i], new Long(this.poolDefinition.getMaximumConnectionLifetime())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "maximum-new-connections")) {
                    resultList.add(new Attribute(attributeNames[i], new Integer(this.poolDefinition.getMaximumNewConnections())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "simultaneous-build-throttle")) {
                    resultList.add(new Attribute(attributeNames[i], new Integer(this.poolDefinition.getSimultaneousBuildThrottle())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "minimum-connection-count")) {
                    resultList.add(new Attribute(attributeNames[i], new Integer(this.poolDefinition.getMinimumConnectionCount())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "overload-without-refusal-lifetime")) {
                    resultList.add(new Attribute(attributeNames[i], new Long(this.poolDefinition.getOverloadWithoutRefusalLifetime())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "prototype-count")) {
                    resultList.add(new Attribute(attributeNames[i], new Integer(this.poolDefinition.getPrototypeCount())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "recently-started-threshold")) {
                    resultList.add(new Attribute(attributeNames[i], new Long(this.poolDefinition.getRecentlyStartedThreshold())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "statistics")) {
                    resultList.add(new Attribute(attributeNames[i], this.getValueOrEmpty(this.poolDefinition.getStatistics())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "statistics-log-level")) {
                    resultList.add(new Attribute(attributeNames[i], this.getValueOrEmpty(this.poolDefinition.getStatisticsLogLevel())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "trace")) {
                    resultList.add(new Attribute(attributeNames[i], new Boolean(this.poolDefinition.isTrace())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "verbose")) {
                    resultList.add(new Attribute(attributeNames[i], new Boolean(this.poolDefinition.isVerbose())));
                    continue;
                }
                if (this.equalsProperty(attributeNames[i], "fatal-sql-exception-wrapper-class")) {
                    resultList.add(new Attribute(attributeNames[i], this.getValueOrEmpty(this.poolDefinition.getFatalSqlExceptionWrapper())));
                    continue;
                }
                String message = "Unknown attribute: " + attributeNames[i];
                LOG.error((Object)message);
                throw new AttributeNotFoundException(message);
            }
            catch (AttributeNotFoundException e) {
                throw new RuntimeOperationsException(new IllegalArgumentException(e.getMessage()));
            }
        }
        return resultList;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            String message = "AttributeList attributes cannot be null";
            LOG.error((Object)"AttributeList attributes cannot be null");
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList attributes cannot be null"), "Cannot invoke a setter of " + CLASS_NAME);
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        String name = null;
        Object value = null;
        Properties newProperties = new Properties();
        Attribute attribute = null;
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            attribute = (Attribute)i.next();
            try {
                name = attribute.getName();
                value = attribute.getValue();
                if (this.equalsProperty(name, "driver-properties")) {
                    if (this.isEqualProperties(value.toString(), this.getDelegatePropertiesAsString(this.poolProperties))) continue;
                    this.checkAssignable(name, class$java$lang$String == null ? ConnectionPoolMBean.class$("java.lang.String") : class$java$lang$String, value);
                    this.setDelegateProperties(newProperties, value.toString());
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "driver-url")) {
                    this.checkAssignable(name, class$java$lang$String == null ? ConnectionPoolMBean.class$("java.lang.String") : class$java$lang$String, value);
                    if (this.notEmpty(value)) {
                        newProperties.setProperty("proxool.driver-url", value.toString());
                    } else {
                        newProperties.setProperty("proxool.driver-url", "");
                    }
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "fatal-sql-exception")) {
                    if (this.isEqualProperties(value.toString(), this.poolProperties.getProperty("proxool.fatal-sql-exception"))) continue;
                    this.checkAssignable(name, class$java$lang$String == null ? ConnectionPoolMBean.class$("java.lang.String") : class$java$lang$String, value);
                    if (this.notEmpty(value)) {
                        newProperties.setProperty("proxool.fatal-sql-exception", value.toString());
                    } else {
                        newProperties.setProperty("proxool.fatal-sql-exception", "");
                    }
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "house-keeping-sleep-time")) {
                    this.setIntegerAttribute(name, "proxool.house-keeping-sleep-time", value, 30000, newProperties, resultList);
                    continue;
                }
                if (this.equalsProperty(name, "house-keeping-test-sql")) {
                    this.checkAssignable(name, class$java$lang$String == null ? ConnectionPoolMBean.class$("java.lang.String") : class$java$lang$String, value);
                    if (this.notEmpty(value)) {
                        newProperties.setProperty("proxool.house-keeping-test-sql", value.toString());
                    } else {
                        newProperties.setProperty("proxool.house-keeping-test-sql", "");
                    }
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "test-before-use")) {
                    this.checkAssignable(name, class$java$lang$Boolean == null ? ConnectionPoolMBean.class$("java.lang.Boolean") : class$java$lang$Boolean, value);
                    newProperties.setProperty("proxool.test-before-use", value.toString());
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "test-after-use")) {
                    this.checkAssignable(name, class$java$lang$Boolean == null ? ConnectionPoolMBean.class$("java.lang.Boolean") : class$java$lang$Boolean, value);
                    newProperties.setProperty("proxool.test-after-use", value.toString());
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "maximum-active-time")) {
                    this.setIntegerAttribute(name, "proxool.maximum-active-time", value, 300000, newProperties, resultList);
                    continue;
                }
                if (this.equalsProperty(name, "maximum-connection-count")) {
                    this.setIntegerAttribute(name, "proxool.maximum-connection-count", value, 15, newProperties, resultList);
                    continue;
                }
                if (this.equalsProperty(name, "maximum-connection-lifetime")) {
                    this.setIntegerAttribute(name, "proxool.maximum-connection-lifetime", value, 14400000, newProperties, resultList);
                    continue;
                }
                if (this.equalsProperty(name, "maximum-new-connections")) {
                    this.setIntegerAttribute(name, "proxool.maximum-new-connections", value, 10, newProperties, resultList);
                    continue;
                }
                if (this.equalsProperty(name, "simultaneous-build-throttle")) {
                    this.setIntegerAttribute(name, "proxool.simultaneous-build-throttle", value, 10, newProperties, resultList);
                    continue;
                }
                if (this.equalsProperty(name, "minimum-connection-count")) {
                    this.checkAssignable(name, class$java$lang$Integer == null ? ConnectionPoolMBean.class$("java.lang.Integer") : class$java$lang$Integer, value);
                    newProperties.setProperty("proxool.minimum-connection-count", value.toString());
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "overload-without-refusal-lifetime")) {
                    this.setIntegerAttribute(name, "proxool.overload-without-refusal-lifetime", value, 60000, newProperties, resultList);
                    continue;
                }
                if (this.equalsProperty(name, "prototype-count")) {
                    this.checkAssignable(name, class$java$lang$Integer == null ? ConnectionPoolMBean.class$("java.lang.Integer") : class$java$lang$Integer, value);
                    newProperties.setProperty("proxool.prototype-count", value.toString());
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "recently-started-threshold")) {
                    this.setIntegerAttribute(name, "proxool.recently-started-threshold", value, 60000, newProperties, resultList);
                    continue;
                }
                if (this.equalsProperty(name, "statistics")) {
                    this.checkAssignable(name, class$java$lang$String == null ? ConnectionPoolMBean.class$("java.lang.String") : class$java$lang$String, value);
                    if (this.notEmpty(value)) {
                        newProperties.setProperty("proxool.statistics", value.toString());
                    } else {
                        newProperties.setProperty("proxool.statistics", "");
                    }
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "statistics-log-level")) {
                    this.checkAssignable(name, class$java$lang$String == null ? ConnectionPoolMBean.class$("java.lang.String") : class$java$lang$String, value);
                    if (this.notEmpty(value)) {
                        newProperties.setProperty("proxool.statistics-log-level", value.toString());
                    } else {
                        newProperties.setProperty("proxool.statistics-log-level", "");
                    }
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "trace")) {
                    this.checkAssignable(name, class$java$lang$Boolean == null ? ConnectionPoolMBean.class$("java.lang.Boolean") : class$java$lang$Boolean, value);
                    newProperties.setProperty("proxool.trace", value.toString());
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "verbose")) {
                    this.checkAssignable(name, class$java$lang$Boolean == null ? ConnectionPoolMBean.class$("java.lang.Boolean") : class$java$lang$Boolean, value);
                    newProperties.setProperty("proxool.verbose", value.toString());
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                if (this.equalsProperty(name, "fatal-sql-exception-wrapper-class")) {
                    this.checkAssignable(name, class$java$lang$Boolean == null ? ConnectionPoolMBean.class$("java.lang.Boolean") : class$java$lang$Boolean, value);
                    newProperties.setProperty("proxool.fatal-sql-exception-wrapper-class", value.toString());
                    resultList.add(new Attribute(name, value));
                    continue;
                }
                String message = "Unknown attribute: " + name;
                LOG.error((Object)message);
                throw new AttributeNotFoundException(message);
            }
            catch (InvalidAttributeValueException e) {
                String message = "Attribute value was illegal: " + e.getMessage();
                LOG.error((Object)message);
                throw new RuntimeOperationsException(new RuntimeException(message));
            }
            catch (AttributeNotFoundException e) {
                throw new RuntimeOperationsException(new IllegalArgumentException(e.getMessage()));
            }
        }
        try {
            ProxoolFacade.updateConnectionPool("proxool." + this.poolDefinition.getAlias(), newProperties);
        }
        catch (ProxoolException e) {
            LOG.error((Object)"Update of Proxool pool failed: ", (Throwable)e);
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
        return resultList;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + CLASS_NAME);
        }
        if (operationName.equals(OPERATION_NAME_SHUTDOWN)) {
            try {
                ProxoolFacade.removeConnectionPool(this.poolDefinition.getAlias());
            }
            catch (ProxoolException e) {
                LOG.error((Object)("Shutdown of pool " + this.poolDefinition.getAlias() + " failed."), (Throwable)e);
            }
            return null;
        }
        throw new ReflectionException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName + ".");
    }

    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    private MBeanInfo getDynamicMBeanInfo(String alias) {
        MBeanAttributeInfo[] attributeInfos = new MBeanAttributeInfo[]{ConnectionPoolMBean.createProxoolAttribute("alias", class$java$lang$String == null ? (class$java$lang$String = ConnectionPoolMBean.class$("java.lang.String")) : class$java$lang$String, false), ConnectionPoolMBean.createProxoolAttribute("driver-properties", class$java$lang$String == null ? (class$java$lang$String = ConnectionPoolMBean.class$("java.lang.String")) : class$java$lang$String), ConnectionPoolMBean.createProxoolAttribute("driver-url", class$java$lang$String == null ? (class$java$lang$String = ConnectionPoolMBean.class$("java.lang.String")) : class$java$lang$String), ConnectionPoolMBean.createProxoolAttribute("fatal-sql-exception", class$java$lang$String == null ? (class$java$lang$String = ConnectionPoolMBean.class$("java.lang.String")) : class$java$lang$String), ConnectionPoolMBean.createProxoolAttribute("house-keeping-sleep-time", class$java$lang$Integer == null ? (class$java$lang$Integer = ConnectionPoolMBean.class$("java.lang.Integer")) : class$java$lang$Integer), ConnectionPoolMBean.createProxoolAttribute("house-keeping-test-sql", class$java$lang$String == null ? (class$java$lang$String = ConnectionPoolMBean.class$("java.lang.String")) : class$java$lang$String), ConnectionPoolMBean.createProxoolAttribute("test-before-use", class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConnectionPoolMBean.class$("java.lang.Boolean")) : class$java$lang$Boolean), ConnectionPoolMBean.createProxoolAttribute("test-after-use", class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConnectionPoolMBean.class$("java.lang.Boolean")) : class$java$lang$Boolean), ConnectionPoolMBean.createProxoolAttribute("maximum-active-time", class$java$lang$Integer == null ? (class$java$lang$Integer = ConnectionPoolMBean.class$("java.lang.Integer")) : class$java$lang$Integer), ConnectionPoolMBean.createProxoolAttribute("maximum-connection-count", class$java$lang$Integer == null ? (class$java$lang$Integer = ConnectionPoolMBean.class$("java.lang.Integer")) : class$java$lang$Integer), ConnectionPoolMBean.createProxoolAttribute("maximum-connection-lifetime", class$java$lang$Integer == null ? (class$java$lang$Integer = ConnectionPoolMBean.class$("java.lang.Integer")) : class$java$lang$Integer), ConnectionPoolMBean.createProxoolAttribute("simultaneous-build-throttle", class$java$lang$Integer == null ? (class$java$lang$Integer = ConnectionPoolMBean.class$("java.lang.Integer")) : class$java$lang$Integer), ConnectionPoolMBean.createProxoolAttribute("minimum-connection-count", class$java$lang$Integer == null ? (class$java$lang$Integer = ConnectionPoolMBean.class$("java.lang.Integer")) : class$java$lang$Integer), ConnectionPoolMBean.createProxoolAttribute("overload-without-refusal-lifetime", class$java$lang$Integer == null ? (class$java$lang$Integer = ConnectionPoolMBean.class$("java.lang.Integer")) : class$java$lang$Integer), ConnectionPoolMBean.createProxoolAttribute("prototype-count", class$java$lang$Integer == null ? (class$java$lang$Integer = ConnectionPoolMBean.class$("java.lang.Integer")) : class$java$lang$Integer), ConnectionPoolMBean.createProxoolAttribute("recently-started-threshold", class$java$lang$Integer == null ? (class$java$lang$Integer = ConnectionPoolMBean.class$("java.lang.Integer")) : class$java$lang$Integer), ConnectionPoolMBean.createProxoolAttribute("statistics", class$java$lang$String == null ? (class$java$lang$String = ConnectionPoolMBean.class$("java.lang.String")) : class$java$lang$String), ConnectionPoolMBean.createProxoolAttribute("statistics-log-level", class$java$lang$String == null ? (class$java$lang$String = ConnectionPoolMBean.class$("java.lang.String")) : class$java$lang$String), ConnectionPoolMBean.createProxoolAttribute("trace", class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConnectionPoolMBean.class$("java.lang.Boolean")) : class$java$lang$Boolean), ConnectionPoolMBean.createProxoolAttribute("verbose", class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConnectionPoolMBean.class$("java.lang.Boolean")) : class$java$lang$Boolean), ConnectionPoolMBean.createProxoolAttribute("fatal-sql-exception-wrapper-class", class$java$lang$String == null ? (class$java$lang$String = ConnectionPoolMBean.class$("java.lang.String")) : class$java$lang$String)};
        MBeanConstructorInfo[] constructorInfos = new MBeanConstructorInfo[]{new MBeanConstructorInfo("ConnectionPoolMBean(): Construct a ConnectionPoolMBean object.", (class$org$logicalcobwebs$proxool$admin$jmx$ConnectionPoolMBean == null ? (class$org$logicalcobwebs$proxool$admin$jmx$ConnectionPoolMBean = ConnectionPoolMBean.class$("org.logicalcobwebs.proxool.admin.jmx.ConnectionPoolMBean")) : class$org$logicalcobwebs$proxool$admin$jmx$ConnectionPoolMBean).getConstructors()[0])};
        MBeanOperationInfo[] operationInfos = new MBeanOperationInfo[]{new MBeanOperationInfo(OPERATION_NAME_SHUTDOWN, "Stop and dispose this connection pool.", new MBeanParameterInfo[0], "void", 1)};
        return new MBeanInfo(CLASS_NAME, MessageFormat.format(ConnectionPoolMBean.getJMXText(RECOURCE_NAME_MBEAN_POOL_DESCRIPTION), alias), attributeInfos, constructorInfos, operationInfos, new MBeanNotificationInfo[0]);
    }

    private static String getAttributeDescription(String attributeName) {
        String description = "";
        if (ATTRIBUTE_DESCRIPTIONS_RESOURCE != null) {
            try {
                description = ATTRIBUTE_DESCRIPTIONS_RESOURCE.getString(attributeName);
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not get description for attribute '" + attributeName + "' from resource " + "org.logicalcobwebs.proxool.resources.attributeDescriptions" + "."));
            }
        }
        return description;
    }

    private static String getJMXText(String key) {
        String value = "";
        if (JMX_RESOURCE != null) {
            try {
                value = JMX_RESOURCE.getString(key);
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not get value for attribute '" + key + "' from resource " + "org.logicalcobwebs.proxool.resources.jmx" + "."));
            }
        }
        return value;
    }

    private static ResourceBundle createAttributeDescriptionsResource() {
        try {
            return ResourceBundle.getBundle("org.logicalcobwebs.proxool.resources.attributeDescriptions");
        }
        catch (Exception e) {
            LOG.error((Object)"Could not find resource org.logicalcobwebs.proxool.resources.attributeDescriptions", (Throwable)e);
            return null;
        }
    }

    private static ResourceBundle createJMXResource() {
        try {
            return ResourceBundle.getBundle("org.logicalcobwebs.proxool.resources.jmx");
        }
        catch (Exception e) {
            LOG.error((Object)"Could not find resource org.logicalcobwebs.proxool.resources.jmx", (Throwable)e);
            return null;
        }
    }

    private static MBeanAttributeInfo createProxoolAttribute(String attributeName, Class type) {
        return ConnectionPoolMBean.createProxoolAttribute(attributeName, type, true);
    }

    private static MBeanAttributeInfo createProxoolAttribute(String attributeName, Class type, boolean writable) {
        return new MBeanAttributeInfo(ProxoolJMXHelper.getValidIdentifier(attributeName), type.getName(), ConnectionPoolMBean.getAttributeDescription(attributeName), true, writable, false);
    }

    private void checkAssignable(String name, Class clazz, Object value) throws InvalidAttributeValueException {
        if (value == null) {
            if (!(class$java$lang$String == null ? (class$java$lang$String = ConnectionPoolMBean.class$("java.lang.String")) : class$java$lang$String).equals(clazz)) {
                throw new InvalidAttributeValueException("Cannot set attribute " + name + " to null " + " an instance of " + clazz.getName() + " expected.");
            }
        } else {
            Class<?> valueClass = value.getClass();
            if (!clazz.isAssignableFrom(valueClass)) {
                throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + valueClass.getName() + " instance, " + clazz.getName() + " expected.");
            }
        }
    }

    private boolean equalsProperty(String beanAttribute, String proxoolProperty) {
        return beanAttribute.equals(ProxoolJMXHelper.getValidIdentifier(proxoolProperty));
    }

    private void setDelegateProperties(Properties properties, String propertyString) throws InvalidAttributeValueException {
        if (propertyString == null || propertyString.trim().length() == 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(propertyString, ",");
        String keyValuePair = null;
        int equalsIndex = -1;
        while (tokenizer.hasMoreElements()) {
            keyValuePair = tokenizer.nextToken().trim();
            equalsIndex = keyValuePair.indexOf("=");
            if (equalsIndex != -1) {
                properties.put(keyValuePair.substring(0, equalsIndex).trim(), keyValuePair.substring(equalsIndex + 1).trim());
                continue;
            }
            throw new InvalidAttributeValueException("Could not find key/value delimiter '=' in property definition: '" + keyValuePair + "'.");
        }
    }

    private String getDelegatePropertiesAsString(Properties properties) {
        StringBuffer result = new StringBuffer();
        Iterator<Object> keyIterator = properties.keySet().iterator();
        String key = null;
        boolean first = true;
        while (keyIterator.hasNext()) {
            key = (String)keyIterator.next();
            if (key.startsWith("proxool.")) continue;
            if (!first) {
                result.append(", ");
            } else {
                first = false;
            }
            result.append(key).append("=").append(properties.getProperty(key));
        }
        return result.toString();
    }

    private boolean notEmpty(Object object) {
        return object != null && object.toString().trim().length() > 0;
    }

    private boolean notEmptyOrZero(Integer integer) {
        return integer != null && integer > 0;
    }

    private String getValueOrEmpty(String property) {
        return property == null ? "" : property;
    }

    private void setIntegerAttribute(String attributeName, String propertyName, Object value, int defaultValue, Properties properties, AttributeList resultList) throws InvalidAttributeValueException {
        this.checkAssignable(attributeName, class$java$lang$Integer == null ? (class$java$lang$Integer = ConnectionPoolMBean.class$("java.lang.Integer")) : class$java$lang$Integer, value);
        if (this.notEmptyOrZero((Integer)value)) {
            properties.setProperty(propertyName, value.toString());
            resultList.add(new Attribute(attributeName, value));
        } else {
            resultList.add(new Attribute(attributeName, new Integer(defaultValue)));
        }
    }

    private boolean isEqualProperties(String property1, String property2) {
        if (property1 == null) {
            return property2 == null;
        }
        if (property2 == null) {
            return property1 == null;
        }
        return property1.equals(property2);
    }

    private static MBeanNotificationInfo[] getNotificationInfos() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{NOTIFICATION_TYPE_DEFINITION_UPDATED}, (class$javax$management$Notification == null ? (class$javax$management$Notification = ConnectionPoolMBean.class$("javax.management.Notification")) : class$javax$management$Notification).getName(), ConnectionPoolMBean.getJMXText(RECOURCE_NAME_MBEAN_NOTIFICATION_DESCRIPTION))};
    }

    public void onRegistration(ConnectionPoolDefinitionIF connectionPoolDefinition, Properties completeInfo) {
    }

    public void onShutdown(String alias) {
        if (alias.equals(this.poolDefinition.getAlias()) && this.active) {
            this.active = false;
            ProxoolJMXHelper.unregisterPool(this.poolDefinition.getAlias(), this.poolProperties);
            LOG.info((Object)(this.poolDefinition.getAlias() + " MBean unregistered."));
        }
    }

    public void definitionUpdated(ConnectionPoolDefinitionIF connectionPoolDefinition, Properties completeInfo, Properties changedInfo) {
        this.poolDefinition = connectionPoolDefinition;
        this.poolProperties = completeInfo;
        this.notificationHelper.sendNotification(new Notification(NOTIFICATION_TYPE_DEFINITION_UPDATED, this, this.definitionUpdatedSequence++, System.currentTimeMillis(), ConnectionPoolMBean.getJMXText(RECOURCE_NAME_MBEAN_NOTIFICATION_DEF_UPDATED)));
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object handBack) throws IllegalArgumentException {
        this.notificationHelper.addNotificationListener(notificationListener, notificationFilter, handBack);
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.notificationHelper.removeNotificationListener(notificationListener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFOS;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            throw new ProxoolException("objectName was null, but we can not construct an MBean instance without knowing the pool alias.");
        }
        return objectName;
    }

    public void postRegister(Boolean success) {
        if (success.booleanValue()) {
            this.active = true;
        }
    }

    public void preDeregister() throws Exception {
        this.active = false;
    }

    public void postDeregister() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

