/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.HashMap;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.Line;
import org.jrobin.graph.Source;

class CustomLine
extends Line {
    private long xVal1;
    private long xVal2;
    private double yVal1;
    private double yVal2;
    private double dc;

    CustomLine(long startTime, double startValue, long endTime, double endValue, Color color) {
        this.color = color;
        if (color == null) {
            this.visible = false;
        }
        this.xVal1 = startTime;
        this.xVal2 = endTime;
        this.yVal1 = startValue;
        this.yVal2 = endValue;
        try {
            long xc = this.xVal2 - this.xVal1;
            this.dc = xc != 0L ? (this.yVal2 - this.yVal1) / (double)xc : 0.0;
        }
        catch (Exception e) {
            this.dc = 0.0;
        }
    }

    CustomLine(long startTime, double startValue, long endTime, double endValue, Color color, int lineWidth) {
        this(startTime, startValue, endTime, endValue, color);
        this.lineWidth = lineWidth;
    }

    void draw(ChartGraphics g, int[] xValues, double[] stackValues, int lastPlotType) throws RrdException {
        int rx;
        g.setColor(this.color);
        g.setStroke(this.lineWidth != 1 ? new BasicStroke(this.lineWidth) : DEF_LINE_STROKE);
        int ax = this.xVal1 == Long.MIN_VALUE ? g.getMinX() : (this.xVal1 == Long.MAX_VALUE ? g.getMaxX() : g.getX(this.xVal1));
        int nx = this.xVal2 == Long.MIN_VALUE ? g.getMinX() : (this.xVal2 == Long.MAX_VALUE ? g.getMaxX() : g.getX(this.xVal2));
        int ay = this.yVal1 == Double.MIN_VALUE ? g.getMinY() : (this.yVal1 == Double.MAX_VALUE ? g.getMaxY() : g.getY(this.yVal1));
        int ny = this.yVal2 == Double.MIN_VALUE ? g.getMinY() : (this.yVal2 == Double.MAX_VALUE ? g.getMaxY() : g.getY(this.yVal2));
        if (this.visible) {
            g.drawLine(ax, ay, nx, ny);
        }
        if ((rx = nx - ax) != 0) {
            double rc = (double)(ny - ay) * 1.0 / (double)rx;
            for (int i = 0; i < xValues.length; ++i) {
                stackValues[i] = xValues[i] < ax || xValues[i] > nx ? g.getInverseY(0) : (ay == ny ? g.getInverseY(ay) : g.getInverseY((int)(rc * (double)(xValues[i] - ax) + (double)ay)));
            }
        }
        g.setStroke(STROKE);
    }

    double getValue(int tblPos, long[] timestamps) {
        long time = timestamps[tblPos];
        if (time > this.xVal2 || time < this.xVal1) {
            return Double.NaN;
        }
        if (this.yVal1 == this.yVal2) {
            return this.yVal1;
        }
        if (this.yVal1 == Double.MIN_VALUE && this.yVal2 == Double.MAX_VALUE) {
            return Double.NaN;
        }
        if (this.xVal1 == this.xVal2) {
            return Double.NaN;
        }
        return this.dc * (double)(time - this.xVal1) + this.yVal1;
    }

    void setSource(Source[] sources, HashMap sourceIndex) throws RrdException {
    }

    void setValue(int tableRow, long preciseTime, long[] reducedTimestamps) {
    }

    void exportXmlTemplate(XmlWriter xml, String legend) {
        if (this.yVal1 == this.yVal2 && this.xVal1 != this.xVal2) {
            xml.startTag("hrule");
            xml.writeTag("value", this.yVal1);
            xml.writeTag("color", this.color);
            xml.writeTag("legend", legend);
            xml.writeTag("width", this.lineWidth);
            xml.closeTag();
        } else if (this.yVal1 != this.yVal2 && this.xVal1 == this.xVal2) {
            xml.startTag("vrule");
            xml.writeTag("time", this.xVal1);
            xml.writeTag("color", this.color);
            xml.writeTag("legend", legend);
            xml.writeTag("width", this.lineWidth);
            xml.closeTag();
        } else if (this.yVal1 != this.yVal2 && this.xVal1 != this.xVal2) {
            xml.startTag("line");
            xml.writeTag("time1", this.xVal1);
            xml.writeTag("value1", this.yVal1);
            xml.writeTag("time2", this.xVal2);
            xml.writeTag("value2", this.yVal2);
            xml.writeTag("color", this.color);
            xml.writeTag("legend", legend);
            xml.writeTag("width", this.lineWidth);
            xml.closeTag();
        }
    }
}

