/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.IOException;
import org.jrobin.core.DataImporter;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XmlReader
extends DataImporter {
    private Element root;
    private Node[] dsNodes;
    private Node[] arcNodes;

    XmlReader(String xmlFilePath) throws IOException, RrdException {
        this.root = Util.Xml.getRootElement(new File(xmlFilePath));
        this.dsNodes = Util.Xml.getChildNodes(this.root, "ds");
        this.arcNodes = Util.Xml.getChildNodes(this.root, "rra");
    }

    String getVersion() throws RrdException {
        return Util.Xml.getChildValue(this.root, "version");
    }

    long getLastUpdateTime() throws RrdException {
        return Util.Xml.getChildValueAsLong(this.root, "lastupdate");
    }

    long getStep() throws RrdException {
        return Util.Xml.getChildValueAsLong(this.root, "step");
    }

    int getDsCount() {
        return this.dsNodes.length;
    }

    int getArcCount() {
        return this.arcNodes.length;
    }

    String getDsName(int dsIndex) throws RrdException {
        return Util.Xml.getChildValue(this.dsNodes[dsIndex], "name");
    }

    String getDsType(int dsIndex) throws RrdException {
        return Util.Xml.getChildValue(this.dsNodes[dsIndex], "type");
    }

    long getHeartbeat(int dsIndex) throws RrdException {
        return Util.Xml.getChildValueAsLong(this.dsNodes[dsIndex], "minimal_heartbeat");
    }

    double getMinValue(int dsIndex) throws RrdException {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[dsIndex], "min");
    }

    double getMaxValue(int dsIndex) throws RrdException {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[dsIndex], "max");
    }

    double getLastValue(int dsIndex) throws RrdException {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[dsIndex], "last_ds");
    }

    double getAccumValue(int dsIndex) throws RrdException {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[dsIndex], "value");
    }

    long getNanSeconds(int dsIndex) throws RrdException {
        return Util.Xml.getChildValueAsLong(this.dsNodes[dsIndex], "unknown_sec");
    }

    String getConsolFun(int arcIndex) throws RrdException {
        return Util.Xml.getChildValue(this.arcNodes[arcIndex], "cf");
    }

    double getXff(int arcIndex) throws RrdException {
        return Util.Xml.getChildValueAsDouble(this.arcNodes[arcIndex], "xff");
    }

    int getSteps(int arcIndex) throws RrdException {
        return Util.Xml.getChildValueAsInt(this.arcNodes[arcIndex], "pdp_per_row");
    }

    double getStateAccumValue(int arcIndex, int dsIndex) throws RrdException {
        Node cdpNode = Util.Xml.getFirstChildNode(this.arcNodes[arcIndex], "cdp_prep");
        Node[] dsNodes = Util.Xml.getChildNodes(cdpNode, "ds");
        return Util.Xml.getChildValueAsDouble(dsNodes[dsIndex], "value");
    }

    int getStateNanSteps(int arcIndex, int dsIndex) throws RrdException {
        Node cdpNode = Util.Xml.getFirstChildNode(this.arcNodes[arcIndex], "cdp_prep");
        Node[] dsNodes = Util.Xml.getChildNodes(cdpNode, "ds");
        return Util.Xml.getChildValueAsInt(dsNodes[dsIndex], "unknown_datapoints");
    }

    int getRows(int arcIndex) throws RrdException {
        Node dbNode = Util.Xml.getFirstChildNode(this.arcNodes[arcIndex], "database");
        Node[] rows = Util.Xml.getChildNodes(dbNode, "row");
        return rows.length;
    }

    double[] getValues(int arcIndex, int dsIndex) throws RrdException {
        Node dbNode = Util.Xml.getFirstChildNode(this.arcNodes[arcIndex], "database");
        Node[] rows = Util.Xml.getChildNodes(dbNode, "row");
        double[] values = new double[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            Node[] vNodes = Util.Xml.getChildNodes(rows[i], "v");
            Node vNode = vNodes[dsIndex];
            values[i] = Util.parseDouble(vNode.getFirstChild().getNodeValue().trim());
        }
        return values;
    }
}

