/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.HashMap;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.Source;

abstract class PlotDef {
    protected static final int PLOT_LINE = 0;
    protected static final int PLOT_AREA = 1;
    protected static final int PLOT_STACK = 2;
    protected static final BasicStroke STROKE = new BasicStroke();
    protected boolean visible = true;
    protected boolean stacked = false;
    protected int plotType = 0;
    protected String sourceName = "";
    protected Source source = null;
    protected Color color = Color.BLACK;
    protected double[] values = null;

    PlotDef() {
    }

    PlotDef(String sourceName, Color color) {
        this.sourceName = sourceName;
        this.color = color;
        if (color == null) {
            this.visible = false;
        }
    }

    PlotDef(Source source, double[] values, Color color, boolean stacked, boolean visible) {
        this.source = source;
        this.values = values;
        this.color = color;
        this.stacked = stacked;
        this.visible = visible;
    }

    void setSource(Source[] sources, HashMap sourceIndex) throws RrdException {
        if (!sourceIndex.containsKey(this.sourceName)) {
            throw new RrdException("Invalid DEF or CDEF: " + this.sourceName);
        }
        this.source = sources[(Integer)sourceIndex.get(this.sourceName)];
    }

    void prepareValues(int arraySize) {
        this.values = new double[arraySize];
    }

    void setValue(int tableRow, long preciseTime, long[] reducedTimestamps) {
        this.values[tableRow] = this.source.get(preciseTime, reducedTimestamps);
    }

    double getValue(int tblPos, long[] timestamps) {
        return this.source.get(tblPos);
    }

    abstract void draw(ChartGraphics var1, int[] var2, double[] var3, int var4) throws RrdException;

    Source getSource() {
        return this.source;
    }

    String getSourceName() {
        return this.sourceName;
    }

    int getType() {
        return this.plotType;
    }

    Color getColor() {
        return this.color;
    }

    void exportXmlTemplate(XmlWriter xml, String legend) {
    }
}

