/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jrobin.core.Archive;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Util {
    static final String PATTERN = "0.0000000000E00";
    static final String JROBIN_DIR = "jrobin-demo";
    static final DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
    private static final File homeDirFile;
    private static final String homeDirPath;
    static final String ISO_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static Date lastLap;

    public static long getTime() {
        return (System.currentTimeMillis() + 500L) / 1000L;
    }

    public static long getTimestamp() {
        return Util.getTime();
    }

    public static long normalize(long timestamp, long step) {
        return timestamp - timestamp % step;
    }

    public static double max(double x, double y) {
        return Double.isNaN(x) ? y : (Double.isNaN(y) ? x : Math.max(x, y));
    }

    public static double min(double x, double y) {
        return Double.isNaN(x) ? y : (Double.isNaN(y) ? x : Math.min(x, y));
    }

    static double sum(double x, double y) {
        return Double.isNaN(x) ? y : (Double.isNaN(y) ? x : x + y);
    }

    static String formatDouble(double x, String nanString, boolean forceExponents) {
        if (Double.isNaN(x)) {
            return nanString;
        }
        if (forceExponents) {
            return df.format(x);
        }
        return "" + x;
    }

    static String formatDouble(double x, boolean forceExponents) {
        return Util.formatDouble(x, "NaN", forceExponents);
    }

    public static Date getDate(long timestamp) {
        return new Date(timestamp * 1000L);
    }

    public static GregorianCalendar getGregorianCalendar(long timestamp) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(timestamp * 1000L);
        return gc;
    }

    public static GregorianCalendar getGregorianCalendar(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return gc;
    }

    public static long getTimestamp(Date date) {
        return (date.getTime() + 499L) / 1000L;
    }

    public static long getTimestamp(GregorianCalendar gc) {
        return Util.getTimestamp(gc.getTime());
    }

    public static long getTimestamp(int year, int month, int day, int hour, int min) {
        GregorianCalendar gc = new GregorianCalendar(year, month, day, hour, min);
        return Util.getTimestamp(gc);
    }

    public static long getTimestamp(int year, int month, int day) {
        return Util.getTimestamp(year, month, day, 0, 0);
    }

    public static double parseDouble(String valueStr) {
        double value;
        try {
            value = Double.parseDouble(valueStr);
        }
        catch (NumberFormatException nfe) {
            value = Double.NaN;
        }
        return value;
    }

    public static boolean parseBoolean(String valueStr) {
        return valueStr.equalsIgnoreCase("true") || valueStr.equalsIgnoreCase("on") || valueStr.equalsIgnoreCase("yes") || valueStr.equalsIgnoreCase("y") || valueStr.equalsIgnoreCase("1");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getUserHomeDirectory() {
        return System.getProperty("user.home") + Util.getFileSeparator();
    }

    public static String getJRobinDemoDirectory() {
        return homeDirFile.exists() || homeDirFile.mkdirs() ? homeDirPath : null;
    }

    public static String getJRobinDemoPath(String filename) {
        String demoDir = Util.getJRobinDemoDirectory();
        if (demoDir != null) {
            return demoDir + filename;
        }
        return null;
    }

    static boolean sameFilePath(String path1, String path2) throws IOException {
        File file1 = new File(path1);
        File file2 = new File(path2);
        return file1.getCanonicalPath().equals(file2.getCanonicalPath());
    }

    static int getMatchingDatasourceIndex(RrdDb rrd1, int dsIndex, RrdDb rrd2) throws IOException {
        String dsName = rrd1.getDatasource(dsIndex).getDsName();
        try {
            return rrd2.getDsIndex(dsName);
        }
        catch (RrdException e) {
            return -1;
        }
    }

    static int getMatchingArchiveIndex(RrdDb rrd1, int arcIndex, RrdDb rrd2) throws IOException {
        Archive archive = rrd1.getArchive(arcIndex);
        String consolFun = archive.getConsolFun();
        int steps = archive.getSteps();
        try {
            return rrd2.getArcIndex(consolFun, steps);
        }
        catch (RrdException e) {
            return -1;
        }
    }

    static String getTmpFilename() throws IOException {
        return File.createTempFile("JROBIN_", ".tmp").getCanonicalPath();
    }

    public static GregorianCalendar getGregorianCalendar(String timeStr) {
        try {
            long timestamp = Long.parseLong(timeStr);
            return Util.getGregorianCalendar(timestamp);
        }
        catch (NumberFormatException e) {
            SimpleDateFormat df = new SimpleDateFormat(ISO_DATE_FORMAT);
            df.setLenient(false);
            try {
                Date date = df.parse(timeStr);
                return Util.getGregorianCalendar(date);
            }
            catch (ParseException e2) {
                throw new IllegalArgumentException("Time/date not in yyyy-MM-dd HH:mm:ss format: " + timeStr);
            }
        }
    }

    public static String getLapTime() {
        Date newLap = new Date();
        double seconds = (double)(newLap.getTime() - lastLap.getTime()) / 1000.0;
        lastLap = newLap;
        return "[" + seconds + " sec]";
    }

    public static String getJRobinHomeDirectory() {
        String className = Util.class.getName().replace('.', '/');
        String uri = Util.class.getResource("/" + className + ".class").toString();
        if (uri.startsWith("file:/")) {
            uri = uri.substring(6);
            File file = new File(uri);
            for (int i = 0; i < 5; ++i) {
                file = file.getParentFile();
            }
            uri = file.getAbsolutePath();
        } else if (uri.startsWith("jar:file:/")) {
            uri = uri.substring(10, uri.lastIndexOf(33));
            File file = new File(uri);
            for (int i = 0; i < 2; ++i) {
                file = file.getParentFile();
            }
            uri = file.getAbsolutePath();
        } else {
            uri = null;
        }
        return uri;
    }

    public static boolean equal(double x, double y) {
        if (Double.isNaN(x) && Double.isNaN(y)) {
            return true;
        }
        return x == y;
    }

    static {
        df.applyPattern(PATTERN);
        df.setPositivePrefix("+");
        homeDirPath = Util.getUserHomeDirectory() + JROBIN_DIR + Util.getFileSeparator();
        homeDirFile = new File(homeDirPath);
        lastLap = new Date();
    }

    public static class Xml {
        public static Node[] getChildNodes(Node parentNode) {
            return Xml.getChildNodes(parentNode, null);
        }

        public static Node[] getChildNodes(Node parentNode, String childName) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            NodeList nodeList = parentNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (childName != null && !node.getNodeName().equals(childName)) continue;
                nodes.add(node);
            }
            return nodes.toArray(new Node[0]);
        }

        public static Node getFirstChildNode(Node parentNode, String childName) throws RrdException {
            Node[] childs = Xml.getChildNodes(parentNode, childName);
            if (childs.length > 0) {
                return childs[0];
            }
            throw new RrdException("XML Error, no such child: " + childName);
        }

        public static boolean hasChildNode(Node parentNode, String childName) {
            Node[] childs = Xml.getChildNodes(parentNode, childName);
            return childs.length > 0;
        }

        public static String getChildValue(Node parentNode, String childName) throws RrdException {
            return Xml.getChildValue(parentNode, childName, true);
        }

        public static String getChildValue(Node parentNode, String childName, boolean trim) throws RrdException {
            NodeList children = parentNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals(childName)) continue;
                return Xml.getValue(child, trim);
            }
            throw new RrdException("XML Error, no such child: " + childName);
        }

        public static String getValue(Node node) {
            return Xml.getValue(node, true);
        }

        public static String getValue(Node node, boolean trimValue) {
            String value = null;
            Node child = node.getFirstChild();
            if (child != null && (value = child.getNodeValue()) != null && trimValue) {
                value = value.trim();
            }
            return value;
        }

        public static int getChildValueAsInt(Node parentNode, String childName) throws RrdException {
            String valueStr = Xml.getChildValue(parentNode, childName);
            return Integer.parseInt(valueStr);
        }

        public static int getValueAsInt(Node node) {
            String valueStr = Xml.getValue(node);
            return Integer.parseInt(valueStr);
        }

        public static long getChildValueAsLong(Node parentNode, String childName) throws RrdException {
            String valueStr = Xml.getChildValue(parentNode, childName);
            return Long.parseLong(valueStr);
        }

        public static long getValueAsLong(Node node) {
            String valueStr = Xml.getValue(node);
            return Long.parseLong(valueStr);
        }

        public static double getChildValueAsDouble(Node parentNode, String childName) throws RrdException {
            String valueStr = Xml.getChildValue(parentNode, childName);
            return Util.parseDouble(valueStr);
        }

        public static double getValueAsDouble(Node node) {
            String valueStr = Xml.getValue(node);
            return Util.parseDouble(valueStr);
        }

        public static boolean getChildValueAsBoolean(Node parentNode, String childName) throws RrdException {
            String valueStr = Xml.getChildValue(parentNode, childName);
            return Util.parseBoolean(valueStr);
        }

        public static boolean getValueAsBoolean(Node node) {
            String valueStr = Xml.getValue(node);
            return Util.parseBoolean(valueStr);
        }

        public static Element getRootElement(InputSource inputSource) throws RrdException, IOException {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                return doc.getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                throw new RrdException(e);
            }
            catch (SAXException e) {
                throw new RrdException(e);
            }
        }

        public static Element getRootElement(String xmlString) throws RrdException, IOException {
            return Xml.getRootElement(new InputSource(new StringReader(xmlString)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Element getRootElement(File xmlFile) throws RrdException, IOException {
            FileReader reader = null;
            try {
                reader = new FileReader(xmlFile);
                Element element = Xml.getRootElement(new InputSource(reader));
                return element;
            }
            finally {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
        }
    }
}

