/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdCacher;
import org.jrobin.core.RrdUpdater;

abstract class RrdPrimitive {
    static final int STRING_LENGTH = 20;
    static final int RRD_INT = 0;
    static final int RRD_LONG = 1;
    static final int RRD_DOUBLE = 2;
    static final int RRD_STRING = 3;
    static final int[] RRD_PRIM_SIZES;
    private RrdBackend backend;
    private int byteCount;
    private final long pointer;
    protected RrdCacher cache = new RrdCacher();
    static final /* synthetic */ boolean $assertionsDisabled;

    RrdPrimitive(RrdUpdater updater, int type) throws IOException {
        this(updater, type, 1);
    }

    RrdPrimitive(RrdUpdater updater, int type, int count) throws IOException {
        this.backend = updater.getRrdBackend();
        this.byteCount = RRD_PRIM_SIZES[type] * count;
        this.pointer = updater.getRrdAllocator().allocate(this.byteCount);
    }

    byte[] readBytes() throws IOException {
        byte[] b = new byte[this.byteCount];
        this.backend.read(this.pointer, b);
        return b;
    }

    void writeBytes(byte[] b) throws IOException {
        if (!$assertionsDisabled && b.length != this.byteCount) {
            throw new AssertionError((Object)"Invalid number of bytes supplied to RrdPrimitive.write method");
        }
        this.backend.write(this.pointer, b);
    }

    int readInt() throws IOException {
        return this.backend.readInt(this.pointer);
    }

    void writeInt(int value) throws IOException {
        this.backend.writeInt(this.pointer, value);
    }

    long readLong() throws IOException {
        return this.backend.readLong(this.pointer);
    }

    void writeLong(long value) throws IOException {
        this.backend.writeLong(this.pointer, value);
    }

    double readDouble() throws IOException {
        return this.backend.readDouble(this.pointer);
    }

    double readDouble(int index) throws IOException {
        long offset = this.pointer + (long)(index * RRD_PRIM_SIZES[2]);
        return this.backend.readDouble(offset);
    }

    double[] readDouble(int index, int count) throws IOException {
        long offset = this.pointer + (long)(index * RRD_PRIM_SIZES[2]);
        return this.backend.readDouble(offset, count);
    }

    void writeDouble(double value) throws IOException {
        this.backend.writeDouble(this.pointer, value);
    }

    void writeDouble(int index, double value, int count) throws IOException {
        long offset = this.pointer + (long)(index * RRD_PRIM_SIZES[2]);
        this.backend.writeDouble(offset, value, count);
    }

    void writeDouble(int index, double[] values) throws IOException {
        long offset = this.pointer + (long)(index * RRD_PRIM_SIZES[2]);
        this.backend.writeDouble(offset, values);
    }

    String readString() throws IOException {
        return this.backend.readString(this.pointer);
    }

    void writeString(String value) throws IOException {
        this.backend.writeString(this.pointer, value);
    }

    void clearCache() {
        this.cache.clearCache();
    }

    static {
        $assertionsDisabled = !RrdPrimitive.class.desiredAssertionStatus();
        RRD_PRIM_SIZES = new int[]{4, 8, 8, 40};
    }
}

