/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.ulaw;

import com.ibm.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaEncoder
extends AudioCodec {
    private boolean downmix = false;
    private int inputBias;
    private int inputSampleSize;
    private Format lastFormat = null;
    private int lsbOffset;
    private int msbOffset;
    private int numberOfInputChannels;
    private int numberOfOutputChannels = 1;
    private int signMask;

    public JavaEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1), new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1)};
        this.PLUGIN_NAME = "pcm to mu-law converter";
    }

    private int calculateOutputSize(int inputLength) {
        if (this.inputSampleSize == 16) {
            inputLength /= 2;
        }
        if (this.downmix) {
            inputLength /= 2;
        }
        return inputLength;
    }

    private void convert(byte[] input, int inputOffset, int inputLength, byte[] outData, int outputOffset) {
        int i = inputOffset + this.msbOffset;
        while (i < inputLength + inputOffset) {
            int signBit;
            int sample;
            int inputSample;
            if (8 == this.inputSampleSize) {
                inputSample = input[i++] << 8;
                if (this.downmix) {
                    inputSample = (inputSample & this.signMask) + (input[i++] << 8 & this.signMask) >> 1;
                }
            } else {
                inputSample = (input[i] << 8) + (0xFF & input[i + this.lsbOffset]);
                i += 2;
                if (this.downmix) {
                    inputSample = (inputSample & this.signMask) + ((input[i] << 8) + (0xFF & input[i + this.lsbOffset]) & this.signMask) >> 1;
                    i += 2;
                }
            }
            if ((sample = (int)(inputSample + this.inputBias)) >= 0) {
                signBit = 128;
            } else {
                sample = -sample;
                signBit = 0;
            }
            sample = 132 + sample >> 3;
            outData[outputOffset++] = (byte)(sample < 32 ? signBit | 0x70 | 31 - (sample >> 0) : (sample < 64 ? signBit | 0x60 | 31 - (sample >> 1) : (sample < 128 ? signBit | 0x50 | 31 - (sample >> 2) : (sample < 256 ? signBit | 0x40 | 31 - (sample >> 3) : (sample < 512 ? signBit | 0x30 | 31 - (sample >> 4) : (sample < 1024 ? signBit | 0x20 | 31 - (sample >> 5) : (sample < 2048 ? signBit | 0x10 | 31 - (sample >> 6) : (sample < 4096 ? signBit | 0 | 31 - (sample >> 7) : signBit | 0 | 0))))))));
        }
    }

    @Override
    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat inFormat = (AudioFormat)in;
        int channels = inFormat.getChannels();
        int sampleRate = (int)inFormat.getSampleRate();
        this.supportedOutputFormats = channels == 2 ? new AudioFormat[]{new AudioFormat("ULAW", sampleRate, 8, 2, -1, -1), new AudioFormat("ULAW", sampleRate, 8, 1, -1, -1)} : new AudioFormat[]{new AudioFormat("ULAW", sampleRate, 8, 1, -1, -1)};
        return this.supportedOutputFormats;
    }

    private void initConverter(AudioFormat inFormat) {
        this.lastFormat = inFormat;
        this.numberOfInputChannels = inFormat.getChannels();
        if (this.outputFormat != null) {
            this.numberOfOutputChannels = this.outputFormat.getChannels();
        }
        this.inputSampleSize = inFormat.getSampleSizeInBits();
        if (inFormat.getEndian() == 1 || 8 == this.inputSampleSize) {
            this.lsbOffset = 1;
            this.msbOffset = 0;
        } else {
            this.lsbOffset = -1;
            this.msbOffset = 1;
        }
        if (inFormat.getSigned() == 1) {
            this.inputBias = 0;
            this.signMask = -1;
        } else {
            this.inputBias = 32768;
            this.signMask = 65535;
        }
        this.downmix = this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 1;
    }

    @Override
    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        Format newFormat = inputBuffer.getFormat();
        if (this.lastFormat != newFormat) {
            this.initConverter((AudioFormat)newFormat);
        }
        int inpLength = inputBuffer.getLength();
        int outLength = this.calculateOutputSize(inputBuffer.getLength());
        byte[] inpData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, outLength);
        this.convert(inpData, inputBuffer.getOffset(), inpLength, outData, 0);
        this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
        return 0;
    }
}

