/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.control.PacketQueueControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.protocol.BasicSourceStream;
import net.sf.fmj.media.protocol.BufferListener;
import net.sf.fmj.media.protocol.rtp.DataSource;
import net.sf.fmj.media.rtp.AudioJitterBufferBehaviour;
import net.sf.fmj.media.rtp.BasicJitterBufferBehaviour;
import net.sf.fmj.media.rtp.BufferControlImpl;
import net.sf.fmj.media.rtp.JitterBuffer;
import net.sf.fmj.media.rtp.JitterBufferBehaviour;
import net.sf.fmj.media.rtp.JitterBufferStats;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.VideoJitterBufferBehaviour;
import net.sf.fmj.media.rtp.util.RTPMediaThread;

public class RTPSourceStream
extends BasicSourceStream
implements PushBufferStream,
Runnable {
    private BufferControlImpl bc = null;
    private JitterBufferBehaviour behaviour;
    private boolean bufferWhenStopped = true;
    private Format format;
    private boolean hasRead = false;
    private boolean killed = false;
    private long lastSeqRecv = 0x7FFFFFFFFFFFFFFEL;
    private long lastSeqSent = 0x7FFFFFFFFFFFFFFEL;
    final JitterBuffer q;
    private boolean started = false;
    private final Object startSyncRoot = new Object();
    final JitterBufferStats stats;
    private RTPMediaThread thread;
    private BufferTransferHandler transferHandler;

    public RTPSourceStream(DataSource datasource) {
        datasource.setSourceStream(this);
        this.q = new JitterBuffer(4);
        this.stats = new JitterBufferStats(this);
        this.setBehaviour(null);
        this.createThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Buffer buffer, boolean flag, RTPRawReceiver rtprawreceiver) {
        if (!this.started && !this.bufferWhenStopped) {
            return;
        }
        long bufferSN = buffer.getSequenceNumber();
        JitterBuffer jitterBuffer = this.q;
        synchronized (jitterBuffer) {
            if (this.lastSeqRecv - bufferSN > 256L) {
                Log.info("Resetting queue, last seq added: " + this.lastSeqRecv + ", current seq: " + bufferSN);
                this.reset();
                this.lastSeqRecv = bufferSN;
            }
            this.stats.updateMaxSizeReached();
            this.stats.updateSizePerPacket(buffer);
            if (!this.behaviour.preAdd(buffer, rtprawreceiver)) {
                return;
            }
            this.stats.incrementNbAdd();
            this.lastSeqRecv = bufferSN;
            boolean almostFull = false;
            if (this.q.noMoreFree()) {
                this.stats.incrementDiscardedFull();
                long l = this.q.getFirstSeq();
                if (l != 0x7FFFFFFFFFFFFFFEL && bufferSN < l) {
                    return;
                }
                this.behaviour.dropPkt();
            }
            if (this.q.getFreeCount() <= 1) {
                almostFull = true;
            }
            Buffer qBuffer = this.q.getFree();
            boolean added = false;
            try {
                byte[] bufferData = (byte[])buffer.getData();
                byte[] qBufferData = (byte[])qBuffer.getData();
                if (qBufferData == null || qBufferData.length < bufferData.length) {
                    qBufferData = new byte[bufferData.length];
                }
                System.arraycopy(bufferData, buffer.getOffset(), qBufferData, buffer.getOffset(), buffer.getLength());
                qBuffer.copy(buffer);
                qBuffer.setData(qBufferData);
                if (almostFull) {
                    qBuffer.setFlags(qBuffer.getFlags() | 0x2000 | 0x20);
                } else {
                    qBuffer.setFlags(qBuffer.getFlags() | 0x20);
                }
                this.q.addPkt(qBuffer);
                added = true;
            }
            finally {
                if (!added) {
                    this.q.returnFree(qBuffer);
                }
            }
            if (!this.behaviour.willReadBlock()) {
                this.q.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.killed) {
            return;
        }
        this.stats.printStats();
        this.stop();
        this.killed = true;
        Object object = this.startSyncRoot;
        synchronized (object) {
            this.startSyncRoot.notifyAll();
        }
        object = this.q;
        synchronized (object) {
            this.q.notifyAll();
        }
        this.thread = null;
        if (this.bc != null) {
            this.bc.removeSourceStream(this);
        }
    }

    public void connect() {
        this.killed = false;
        this.createThread();
    }

    private void createThread() {
        if (this.thread == null) {
            this.thread = new RTPMediaThread(this, "RTPStream");
            this.thread.useControlPriority();
            this.thread.start();
        }
    }

    JitterBufferBehaviour getBehaviour() {
        return this.behaviour;
    }

    BufferControlImpl getBufferControl() {
        return this.bc;
    }

    public Object getControl(String controlType) {
        return PacketQueueControl.class.getName().equals(controlType) ? this.stats : super.getControl(controlType);
    }

    public Object[] getControls() {
        Object[] superControls = super.getControls();
        Object[] thisControls = new Object[superControls.length + 1];
        System.arraycopy(superControls, 0, thisControls, 0, superControls.length);
        thisControls[superControls.length] = this.stats;
        return thisControls;
    }

    public Format getFormat() {
        return this.format;
    }

    long getLastReadSequenceNumber() {
        return this.lastSeqSent;
    }

    public void prebuffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) {
        JitterBuffer jitterBuffer = this.q;
        synchronized (jitterBuffer) {
            try {
                this.behaviour.read(buffer);
                if (!buffer.isDiscard()) {
                    this.lastSeqSent = buffer.getSequenceNumber();
                }
            }
            finally {
                if (!buffer.isDiscard()) {
                    this.hasRead = true;
                    this.q.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        JitterBuffer jitterBuffer = this.q;
        synchronized (jitterBuffer) {
            this.stats.incrementNbReset();
            this.resetQ();
            this.behaviour.reset();
            this.lastSeqSent = 0x7FFFFFFFFFFFFFFEL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetQ() {
        Log.comment("Resetting the RTP packet queue");
        JitterBuffer jitterBuffer = this.q;
        synchronized (jitterBuffer) {
            while (this.q.fillNotEmpty()) {
                this.stats.incrementDiscardedReset();
                this.behaviour.dropPkt();
            }
            this.q.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do {
            try {
                Object object = this.startSyncRoot;
                synchronized (object) {
                    if (!this.killed && !this.started) {
                        this.startSyncRoot.wait();
                        continue;
                    }
                }
                object = this.q;
                synchronized (object) {
                    if (!this.killed && !this.hasRead && this.behaviour.willReadBlock()) {
                        this.q.wait();
                        continue;
                    }
                    this.hasRead = false;
                }
                BufferTransferHandler transferHandler = this.transferHandler;
                if (transferHandler == null) continue;
                transferHandler.transferData(this);
            }
            catch (InterruptedException ie) {
                Log.error("Thread " + ie.getMessage());
            }
        } while (!this.killed);
    }

    private void setBehaviour(JitterBufferBehaviour behaviour) {
        if (behaviour == null) {
            if (this.behaviour instanceof BasicJitterBufferBehaviour) {
                return;
            }
            behaviour = new BasicJitterBufferBehaviour(this);
        }
        if (this.behaviour != behaviour) {
            this.behaviour = behaviour;
        }
    }

    public void setBufferControl(BufferControl buffercontrol) {
        this.bc = (BufferControlImpl)buffercontrol;
        this.updateBuffer(this.bc.getBufferLength());
        this.updateThreshold(this.bc.getMinimumThreshold());
    }

    public void setBufferListener(BufferListener bufferlistener) {
    }

    public void setBufferWhenStopped(boolean flag) {
        this.bufferWhenStopped = flag;
    }

    void setContentDescriptor(String s) {
        this.contentDescriptor = new ContentDescriptor(s);
    }

    protected void setFormat(Format format) {
        if (this.format != format) {
            this.format = format;
            BasicJitterBufferBehaviour behaviour = this.format instanceof AudioFormat ? new AudioJitterBufferBehaviour(this) : (this.format instanceof VideoFormat ? new VideoJitterBufferBehaviour(this) : null);
            this.setBehaviour(behaviour);
        }
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.transferHandler = transferHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Log.info("Starting RTPSourceStream.");
        Object object = this.startSyncRoot;
        synchronized (object) {
            this.started = true;
            this.startSyncRoot.notifyAll();
        }
        object = this.q;
        synchronized (object) {
            this.q.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Log.info("Stopping RTPSourceStream.");
        Object object = this.startSyncRoot;
        synchronized (object) {
            this.started = false;
            if (!this.bufferWhenStopped) {
                this.reset();
            }
        }
        object = this.q;
        synchronized (object) {
            this.q.notifyAll();
        }
    }

    public long updateBuffer(long l) {
        return l;
    }

    public long updateThreshold(long l) {
        return l;
    }
}

