/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.fmj.media.MimeTable;
import net.sf.fmj.registry.Registry;
import net.sf.fmj.utility.LoggerSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeManager {
    private static final Logger logger = LoggerSingleton.logger;
    private static final MimeTable defaultMimeTable = new MimeTable();

    public static final boolean addMimeType(String fileExtension, String mimeType) {
        fileExtension = MimeManager.nullSafeToLowerCase(fileExtension);
        mimeType = MimeManager.nullSafeToLowerCase(mimeType);
        if (defaultMimeTable.getMimeType(fileExtension) != null) {
            logger.warning("Cannot override default mime-table entries");
            return false;
        }
        Registry.getInstance().addMimeType(fileExtension, mimeType);
        return true;
    }

    public static void commit() {
        try {
            Registry.getInstance().commit();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    public static final String getDefaultExtension(String mimeType) {
        mimeType = MimeManager.nullSafeToLowerCase(mimeType);
        String result = Registry.getInstance().getDefaultExtension(mimeType);
        if (result != null) {
            return result;
        }
        return defaultMimeTable.getDefaultExtension(mimeType);
    }

    public static final Hashtable getDefaultMimeTable() {
        return defaultMimeTable.getMimeTable();
    }

    public static final List<String> getExtensions(String mimeType) {
        mimeType = MimeManager.nullSafeToLowerCase(mimeType);
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(defaultMimeTable.getExtensions(mimeType));
        result.addAll(Registry.getInstance().getExtensions(mimeType));
        return result;
    }

    public static final Hashtable<String, String> getMimeTable() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.putAll(defaultMimeTable.getMimeTable());
        result.putAll(Registry.getInstance().getMimeTable());
        return result;
    }

    public static final String getMimeType(String fileExtension) {
        fileExtension = MimeManager.nullSafeToLowerCase(fileExtension);
        String result = Registry.getInstance().getMimeType(fileExtension);
        if (result != null) {
            return result;
        }
        result = defaultMimeTable.getMimeType(fileExtension);
        return result;
    }

    private static final String nullSafeToLowerCase(String s) {
        if (s == null) {
            return s;
        }
        return s.toLowerCase();
    }

    private static void put(String ext, String type) {
        ext = MimeManager.nullSafeToLowerCase(ext);
        type = MimeManager.nullSafeToLowerCase(type);
        defaultMimeTable.addMimeType(ext, type);
    }

    public static final boolean removeMimeType(String fileExtension) {
        fileExtension = MimeManager.nullSafeToLowerCase(fileExtension);
        return Registry.getInstance().removeMimeType(fileExtension);
    }

    protected MimeManager() {
    }

    static {
        MimeManager.put("mvr", "application/mvr");
        MimeManager.put("aif", "audio/x_aiff");
        MimeManager.put("aiff", "audio/x_aiff");
        MimeManager.put("midi", "audio/midi");
        MimeManager.put("jmx", "application/x_jmx");
        MimeManager.put("mpv", "video/mpeg");
        MimeManager.put("mpg", "video/mpeg");
        MimeManager.put("wav", "audio/x_wav");
        MimeManager.put("mp3", "audio/mpeg");
        MimeManager.put("mpa", "audio/mpeg");
        MimeManager.put("mp2", "audio/mpeg");
        MimeManager.put("spl", "application/futuresplash");
        MimeManager.put("viv", "video/vivo");
        MimeManager.put("au", "audio/basic");
        MimeManager.put("g729", "audio/g729");
        MimeManager.put("mov", "video/quicktime");
        MimeManager.put("avi", "video/x_msvideo");
        MimeManager.put("g728", "audio/g728");
        MimeManager.put("cda", "audio/cdaudio");
        MimeManager.put("g729a", "audio/g729a");
        MimeManager.put("gsm", "audio/x_gsm");
        MimeManager.put("mid", "audio/midi");
        MimeManager.put("swf", "application/x-shockwave-flash");
        MimeManager.put("rmf", "audio/rmf");
        boolean jmfDefaults = false;
        try {
            jmfDefaults = System.getProperty("net.sf.fmj.utility.JmfRegistry.JMFDefaults", "false").equals("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!jmfDefaults) {
            MimeManager.put("ogg", "audio/ogg");
            MimeManager.put("ogx", "application/ogg");
            MimeManager.put("oga", "audio/ogg");
            MimeManager.put("ogv", "video/ogg");
            MimeManager.put("spx", "audio/ogg");
            MimeManager.put("flac", "application/flac");
            MimeManager.put("anx", "application/annodex");
            MimeManager.put("axa", "audio/annodex");
            MimeManager.put("axv", "video/annodex");
            MimeManager.put("xspf", "application/xspf+xml ");
            MimeManager.put("asf", "video/x-ms-asf");
            MimeManager.put("asx", "video/x-ms-asf");
            MimeManager.put("wma", "audio/x-ms-wma");
            MimeManager.put("wax", "audio/x-ms-wax");
            MimeManager.put("wmv", "video/x-ms-wmv");
            MimeManager.put("wvx", "video/x-ms-wvx");
            MimeManager.put("wm", "video/x-ms-wm");
            MimeManager.put("wmx", "video/x-ms-wmx");
            MimeManager.put("wmz", "application/x-ms-wmz");
            MimeManager.put("wmd", "application/x-ms-wmd");
            MimeManager.put("mpeg4", "video/mpeg");
            MimeManager.put("mp4", "video/mpeg");
            MimeManager.put("3gp", "video/3gpp");
            MimeManager.put("3g2", "video/3gpp");
            MimeManager.put("h264", "video/mp4");
            MimeManager.put("m4v", "video/mp4v");
            MimeManager.put("m2v", "video/mp2p");
            MimeManager.put("vob", "video/mp2p");
            MimeManager.put("ts", "video/x-mpegts");
            MimeManager.put("mpeg", "video/mpeg");
            MimeManager.put("m1v", "video/mpeg");
            MimeManager.put("mjpg", "video/x-mjpeg");
            MimeManager.put("mjpeg", "video/x-mjpeg");
            MimeManager.put("flv", "video/x-flv");
            MimeManager.put("fli", "video/fli");
            MimeManager.put("flc", "video/flc");
            MimeManager.put("flx", "video/flc");
            MimeManager.put("mkv", "video/x-matroska");
            MimeManager.put("mka", "audio/x-matroska");
            MimeManager.put("mpc", "audio/x-musepack");
            MimeManager.put("mp+", "audio/x-musepack");
            MimeManager.put("mpp", "audio/x-musepack");
            MimeManager.put("rm", "application/vnd.rn-realmedia");
            MimeManager.put("ra", "application/vnd.rn-realmedia");
            MimeManager.put("dv", "video/x-dv");
            MimeManager.put("dif", "video/x-dv");
            MimeManager.put("aac", "audio/X-HX-AAC-ADTS");
            MimeManager.put("mj2", "video/mj2");
            MimeManager.put("mjp2", "video/mj2");
            MimeManager.put("mtv", "video/x-amv");
            MimeManager.put("amv", "video/x-amv");
            MimeManager.put("nsv", "application/x-nsv-vp3-mp3");
            MimeManager.put("nuv", "video/x-nuv");
            MimeManager.put("nuv", "application/mxf");
            MimeManager.put("shn", "application/x-shorten");
            MimeManager.put("tta", "audio/x-tta");
            MimeManager.put("voc", "audio/x-voc");
            MimeManager.put("wv", "audio/x-wavpack");
            MimeManager.put("wvp", "audio/x-wavpack");
            MimeManager.put("4xm", "video/x-4xm");
            MimeManager.put("aud", "video/x-wsaud");
            MimeManager.put("apc", "audio/x-apc");
            MimeManager.put("avs", "video/x-avs");
            MimeManager.put("c93", "video/x-c93");
            MimeManager.put("cin", "video/x-dsicin");
            MimeManager.put("cin", "video/x-idcin");
            MimeManager.put("cpk", "video/x-film-cpk");
            MimeManager.put("dts", "audio/x-raw-dts");
            MimeManager.put("dxa", "video/x-dxa");
            MimeManager.put("gxf", "video/x-gxf");
            MimeManager.put("mm", "video/x-mm");
            MimeManager.put("mve", "video/x-wc3-movie");
            MimeManager.put("mve", "video/x-mve");
            MimeManager.put("roq", "video/x-roq");
            MimeManager.put("seq", "video/x-seq");
            MimeManager.put("smk", "video/x-smk");
            MimeManager.put("sol", "audio/x-sol");
            MimeManager.put("str", "audio/x-psxstr");
            MimeManager.put("thp", "video/x-thp");
            MimeManager.put("txd", "video/x-txd");
            MimeManager.put("uv2", "video/x-ea");
            MimeManager.put("vc1", "video/x-raw-vc1");
            MimeManager.put("vid", "video/x-bethsoft-vid");
            MimeManager.put("vmd", "video/x-vmd");
            MimeManager.put("vqa", "video/x-wsvqa");
            MimeManager.put("wve", "video/x-ea");
            MimeManager.put("yuv", "video/x-raw-yuv");
            MimeManager.put("mmr", "multipart/x-mixed-replace");
            MimeManager.put("xmv", "video/xml");
        }
    }
}

