/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.impl.ThreadContext;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final ClassLoader classLoader;
    private final ThreadCleanup cleanup;

    public ExecutorThreadFactory(ThreadGroup threadGroup, String threadNamePrefix, ClassLoader classLoader) {
        this(threadGroup, threadNamePrefix, classLoader, null);
    }

    public ExecutorThreadFactory(ThreadGroup threadGroup, String threadNamePrefix, ClassLoader classLoader, ThreadCleanup cleanup) {
        this.group = threadGroup;
        this.classLoader = classLoader;
        this.namePrefix = threadNamePrefix;
        this.cleanup = new CleanupImpl(cleanup);
    }

    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    super.run();
                }
                catch (OutOfMemoryError e) {
                    OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                }
                finally {
                    ExecutorThreadFactory.this.cleanup.cleanup(this);
                }
            }
        };
        t.setContextClassLoader(this.classLoader);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    private class CleanupImpl
    implements ThreadCleanup {
        private final ThreadCleanup externalCleanup;

        private CleanupImpl(ThreadCleanup externalCleanup) {
            this.externalCleanup = externalCleanup;
        }

        public void cleanup(Thread t) {
            if (this.externalCleanup != null) {
                try {
                    this.externalCleanup.cleanup(t);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            try {
                ThreadContext.shutdown(t);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static interface ThreadCleanup {
        public void cleanup(Thread var1);
    }
}

