/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.in;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.RemoteStatus;
import pl.mn.communicator.User;
import pl.mn.communicator.packet.GGConversion;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.in.GGIncomingPackage;

public class GGNotifyReply60
implements GGIncomingPackage {
    public static final int GG_NOTIFY_REPLY60 = 17;
    private static final Log LOGGER = LogFactory.getLog((Class)GGNotifyReply60.class);
    private Map m_statuses = new HashMap();

    public GGNotifyReply60(byte[] data) {
        this.handlePacket(data);
    }

    public int getPacketType() {
        return 17;
    }

    public Map getUsersStatus() {
        return this.m_statuses;
    }

    private void handlePacket(byte[] data) {
        int offset = 0;
        while (offset < data.length) {
            byte flag = data[offset + 3];
            data[offset + 3] = GGUtils.intToByte(0)[0];
            int uin = GGUtils.byteToInt(data, offset);
            int status = GGUtils.unsignedByteToInt(data[offset + 4]);
            User.UserMode userMode = GGConversion.getUserMode(status);
            int remoteIP = GGUtils.byteToInt(data, offset + 5);
            byte[] remoteIPArray = GGUtils.convertIntToByteArray(remoteIP);
            int remotePort = GGUtils.byteToShort(data, offset + 9);
            int version = GGUtils.unsignedByteToInt(data[offset + 11]);
            int imageSize = GGUtils.unsignedByteToInt(data[offset + 12]);
            String description = null;
            int descriptionSize = -1;
            long timeInMillis = -1L;
            if (status == 4 || status == 5 || status == 22 || status == 21) {
                boolean isTimeSet;
                descriptionSize = GGUtils.unsignedByteToInt(data[offset + 14]);
                description = GGUtils.byteToString(data, offset + 15, descriptionSize);
                boolean bl = isTimeSet = data[offset + 15 + descriptionSize - 5] == 0;
                if (isTimeSet) {
                    int timeInSeconds = GGUtils.byteToInt(data, offset + 15 + descriptionSize - 4);
                    timeInMillis = GGUtils.secondsToMillis(timeInSeconds);
                    descriptionSize -= 5;
                }
                offset += 15 + descriptionSize;
                if (isTimeSet) {
                    offset += 5;
                }
            } else {
                offset += 14;
            }
            User user = new User(uin, userMode);
            RemoteStatus status60 = GGConversion.getClientRemoteStatus(status, description, timeInMillis);
            if (remotePort == 0) {
                status60.setSupportsDirectCommunication(false);
            } else if (remotePort == 1) {
                status60.setUserBehindFirewall(true);
            } else if (remotePort == 2) {
                status60.setAreWeInRemoteUserBuddyList(false);
            } else {
                status60.setRemotePort(remotePort);
            }
            status60.setRemoteIP(remoteIPArray);
            status60.setImageSize(imageSize);
            status60.setGGVersion(version);
            if (descriptionSize > 0) {
                status60.setDescriptionSize(descriptionSize);
            }
            if (flag == 64) {
                status60.setSupportsVoiceCommunication(true);
            }
            this.m_statuses.put(user, status60);
        }
    }
}

