/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openymsg.addressBook.BuddyListImport;
import org.openymsg.network.AccountLockedException;
import org.openymsg.network.AuthenticationState;
import org.openymsg.network.ConnectionHandler;
import org.openymsg.network.ContactListType;
import org.openymsg.network.DirectConnectionHandler;
import org.openymsg.network.EventDispatcher;
import org.openymsg.network.FailedLoginException;
import org.openymsg.network.FileTransferFailedException;
import org.openymsg.network.FireEvent;
import org.openymsg.network.FriendManager;
import org.openymsg.network.HTTPConnectionHandler;
import org.openymsg.network.IllegalIdentityException;
import org.openymsg.network.InputThread;
import org.openymsg.network.LoginRefusedException;
import org.openymsg.network.NetworkConstants;
import org.openymsg.network.NoSuchChatroomException;
import org.openymsg.network.NoSuchConferenceException;
import org.openymsg.network.PacketBodyBuffer;
import org.openymsg.network.SOCKSConnectionHandler;
import org.openymsg.network.ServiceType;
import org.openymsg.network.SessionPinger;
import org.openymsg.network.SessionState;
import org.openymsg.network.Status;
import org.openymsg.network.StatusConstants;
import org.openymsg.network.Util;
import org.openymsg.network.YMSG9BadFormatException;
import org.openymsg.network.YMSG9Packet;
import org.openymsg.network.YahooConference;
import org.openymsg.network.YahooException;
import org.openymsg.network.YahooGroup;
import org.openymsg.network.YahooIdentity;
import org.openymsg.network.YahooProtocol;
import org.openymsg.network.YahooUser;
import org.openymsg.network.challenge.ChallengeResponseV10;
import org.openymsg.network.challenge.ChallengeResponseV16;
import org.openymsg.network.challenge.ChallengeResponseV9;
import org.openymsg.network.chatroom.ChatroomManager;
import org.openymsg.network.chatroom.YahooChatLobby;
import org.openymsg.network.chatroom.YahooChatUser;
import org.openymsg.network.event.SessionAuthorizationEvent;
import org.openymsg.network.event.SessionChatEvent;
import org.openymsg.network.event.SessionConferenceDeclineInviteEvent;
import org.openymsg.network.event.SessionConferenceLogoffEvent;
import org.openymsg.network.event.SessionConferenceLogonEvent;
import org.openymsg.network.event.SessionConferenceMessageEvent;
import org.openymsg.network.event.SessionErrorEvent;
import org.openymsg.network.event.SessionEvent;
import org.openymsg.network.event.SessionExceptionEvent;
import org.openymsg.network.event.SessionFileTransferEvent;
import org.openymsg.network.event.SessionFriendAcceptedEvent;
import org.openymsg.network.event.SessionFriendEvent;
import org.openymsg.network.event.SessionFriendFailureEvent;
import org.openymsg.network.event.SessionFriendRejectedEvent;
import org.openymsg.network.event.SessionGroupEvent;
import org.openymsg.network.event.SessionListEvent;
import org.openymsg.network.event.SessionListener;
import org.openymsg.network.event.SessionLogoutEvent;
import org.openymsg.network.event.SessionNewMailEvent;
import org.openymsg.network.event.SessionNotifyEvent;
import org.openymsg.network.event.SessionPictureEvent;
import org.openymsg.network.event.SessionPictureHandler;
import org.openymsg.roster.Roster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
implements StatusConstants,
FriendManager {
    private YahooIdentity primaryID;
    private YahooIdentity loginID;
    private Map<String, YahooIdentity> identities = new HashMap<String, YahooIdentity>();
    private String password;
    private String cookieY;
    private String cookieT;
    private String cookieC;
    private String imvironment;
    protected Status status;
    private String customStatusMessage;
    private boolean customStatusBusy;
    private Roster roster = new Roster(this);
    private volatile SessionState sessionStatus;
    volatile long sessionId = 0L;
    public volatile ConnectionHandler network;
    private Timer scheduledPingerService;
    private TimerTask pingerTask;
    protected InputThread ipThread;
    protected EventDispatcher eventDispatchQueue;
    private YahooException loginException = null;
    private YMSG9Packet cachePacket;
    private ChatroomManager chatroomManager;
    private Hashtable<String, YahooConference> conferences = new Hashtable();
    private SessionState chatSessionStatus;
    private volatile YahooChatLobby currentLobby = null;
    private YahooIdentity chatID;
    private Set<SessionListener> sessionListeners = new HashSet<SessionListener>();
    private SessionPictureHandler pictureHandler = null;
    private int messageNumber;
    private int keepAliveCount;
    private ArrayList<YMSG9Packet> queueOfList15 = new ArrayList();
    private static final Log log = LogFactory.getLog(Session.class);

    public Session() throws NumberFormatException {
        this(null);
    }

    public Session(ConnectionHandler connectionHandler) throws NumberFormatException {
        Properties p;
        this.network = connectionHandler != null ? connectionHandler : ((p = System.getProperties()).containsKey("socksProxyHost") ? new SOCKSConnectionHandler() : (p.containsKey("http.proxyHost") || p.containsKey("proxyHost") ? new HTTPConnectionHandler() : new DirectConnectionHandler()));
        this.status = Status.WEBLOGIN;
        this.sessionId = 0L;
        this.sessionStatus = SessionState.UNSTARTED;
        this.network.install(this);
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (sessionListener == null) {
            throw new IllegalArgumentException("Argument 'sessionListener' cannot be null.");
        }
        this.sessionListeners.add(sessionListener);
    }

    public Set<SessionListener> getSessionListeners() {
        return this.sessionListeners;
    }

    public void removeSessionListener(SessionListener sessionListener) {
        if (sessionListener == null) {
            throw new IllegalArgumentException("Argument 'sessionListener' cannot be null.");
        }
        if (!this.sessionListeners.remove(sessionListener)) {
            log.warn((Object)"SessionListener not found to be removed");
        }
    }

    public ConnectionHandler getConnectionHandler() {
        return this.network;
    }

    public void login(String username, String password) throws IllegalStateException, IOException, AccountLockedException, LoginRefusedException, FailedLoginException {
        this.login(username, password, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String username, String password, boolean createPingerTask) throws IllegalStateException, IOException, AccountLockedException, LoginRefusedException, FailedLoginException {
        this.identities = new HashMap<String, YahooIdentity>();
        this.conferences = new Hashtable();
        this.chatroomManager = new ChatroomManager(null, null);
        if (this.eventDispatchQueue == null) {
            this.eventDispatchQueue = new EventDispatcher(username, this);
            this.eventDispatchQueue.start();
        }
        if (username == null || username.length() == 0) {
            this.sessionStatus = SessionState.FAILED;
            throw new IllegalArgumentException("Argument 'username' cannot be null or an empty String.");
        }
        if (password == null || password.length() == 0) {
            this.sessionStatus = SessionState.FAILED;
            throw new IllegalArgumentException("Argument 'password' cannot be null or an empty String.");
        }
        Session session = this;
        synchronized (session) {
            if (this.sessionStatus != SessionState.UNSTARTED) {
                throw new IllegalStateException("Session should be unstarted");
            }
            this.sessionStatus = SessionState.CONNECTING;
        }
        username = username.toLowerCase();
        this.resetData();
        this.roster = new Roster(this);
        this.addSessionListener(this.roster);
        this.loginID = new YahooIdentity(username);
        this.primaryID = null;
        this.password = password;
        this.sessionId = 0L;
        this.imvironment = "0";
        try {
            log.trace((Object)"Opening session...");
            this.openSession(createPingerTask);
            log.trace((Object)"Transmitting auth...");
            this.transmitAuth();
            long timeout = System.currentTimeMillis() + (long)Util.loginTimeout(60);
            while (this.sessionStatus != SessionState.LOGGED_ON && this.sessionStatus != SessionState.FAILED && !this.past(timeout) && this.loginException == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
            log.trace((Object)("finished waiting for connection: " + (Object)((Object)this.sessionStatus) + "/" + this.past(timeout) + "/" + this.loginException));
            if (this.past(timeout)) {
                this.sessionStatus = SessionState.FAILED;
                throw new InterruptedIOException("Login timed out");
            }
            if (this.sessionStatus == SessionState.FAILED) {
                if (this.loginException instanceof FailedLoginException) {
                    throw (FailedLoginException)this.loginException;
                }
                throw (LoginRefusedException)this.loginException;
            }
        }
        finally {
            if (this.sessionStatus != SessionState.LOGGED_ON) {
                log.error((Object)("Never logged in, sessionStatus is: " + (Object)((Object)this.sessionStatus)));
                this.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void logout() throws IllegalStateException, IOException {
        log.trace((Object)"logout");
        try {
            if (this.sessionStatus == SessionState.CONNECTING || this.sessionStatus == SessionState.CONNECTED) {
                throw new IllegalStateException("Not logged in or connecting");
            }
            this.transmitLogoff();
        }
        finally {
            this.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceCloseSession() throws IOException {
        log.trace((Object)"force close session");
        this.sessionStatus = SessionState.UNSTARTED;
        this.cachePacket = null;
        try {
            this.network.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.closeSession();
        }
    }

    public synchronized void reset() throws IllegalStateException {
        if (this.sessionStatus != SessionState.FAILED && this.sessionStatus != SessionState.UNSTARTED) {
            throw new IllegalStateException("Session currently active");
        }
        this.sessionStatus = SessionState.UNSTARTED;
        this.chatSessionStatus = SessionState.UNSTARTED;
        this.resetData();
    }

    public boolean sendKeepAliveAndPing() {
        try {
            this.transmitKeepAlive();
            if (this.keepAliveCount++ % 60 == 0) {
                this.transmitPings();
                return true;
            }
        }
        catch (IOException ex) {
            if (ex instanceof SocketException) {
                log.warn((Object)("Logging out due to socket exception: " + this.getSessionID() + "/" + this.getLoginID()));
                try {
                    this.forceCloseSession();
                }
                catch (Exception e) {
                    log.error((Object)("Failed to close session: " + this.getSessionID() + "/" + this.getLoginID()), (Throwable)e);
                }
            }
            log.error((Object)("Could not send keep-alive to: " + this.getSessionID() + "/" + this.getLoginID()), (Throwable)ex);
        }
        return false;
    }

    public String sendMessage(String to, String message) throws IllegalStateException, IOException {
        return this.sendMessage(to, message, this.loginID);
    }

    public String sendMessage(String to, String message, YahooIdentity yid) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkStatus();
        if (!this.identities.containsKey(yid.getId())) {
            throw new IllegalIdentityException("The YahooIdentity '" + yid.getId() + "'is not a valid identity for this session.");
        }
        return this.transmitMessage(to, yid, message);
    }

    public void sendBuzz(String to) throws IllegalStateException, IOException {
        this.sendMessage(to, "<ding>");
    }

    public void sendBuzz(String to, YahooIdentity yid) throws IllegalStateException, IOException, IllegalIdentityException {
        this.sendMessage(to, "<ding>", yid);
    }

    public SessionState getSessionStatus() {
        return this.sessionStatus;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public synchronized void setStatus(Status status) throws IllegalArgumentException, IOException {
        log.debug((Object)("setting status: " + (Object)((Object)status)));
        if (status == Status.CUSTOM) {
            throw new IllegalArgumentException("Cannot set custom state without message");
        }
        this.status = status;
        this.customStatusMessage = null;
        if (this.sessionStatus != SessionState.UNSTARTED) {
            this.transmitNewStatus();
        }
    }

    public synchronized void setStatus(String message, boolean showBusyIcon) throws IllegalArgumentException, IOException {
        if (this.sessionStatus == SessionState.UNSTARTED) {
            throw new IllegalArgumentException("Unstarted sessions can be available or invisible only");
        }
        if (message == null) {
            throw new IllegalArgumentException("Cannot set custom state with null message");
        }
        this.status = Status.CUSTOM;
        this.customStatusMessage = message;
        this.customStatusBusy = showBusyIcon;
        this.transmitNewCustomStatus();
    }

    public String getCustomStatusMessage() {
        return this.customStatusMessage;
    }

    public boolean isCustomBusy() {
        return this.customStatusBusy;
    }

    public void refreshStats() throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitUserStat();
    }

    public boolean isValidYahooID(String yahooIdentity) {
        return this.identities.containsKey(yahooIdentity);
    }

    public YahooIdentity getPrimaryIdentity() {
        return this.primaryID;
    }

    public YahooIdentity getLoginIdentity() {
        return this.loginID;
    }

    public void activateIdentity(YahooIdentity yid, boolean activate) throws IllegalStateException, IllegalIdentityException, IOException {
        this.checkStatus();
        if (!this.identities.containsKey(yid.getId())) {
            throw new IllegalIdentityException("The YahooIdentity '" + yid.getId() + "'is not a valid identity for this session.");
        }
        if (yid.equals(this.primaryID)) {
            throw new IllegalIdentityException("Primary identity cannot be de/activated");
        }
        if (activate) {
            this.transmitIdActivate(yid.getId());
        } else {
            this.transmitIdDeactivate(yid.getId());
        }
    }

    public String getImvironment() {
        return this.imvironment;
    }

    public String[] getCookies() {
        String[] arr = new String[]{this.cookieY, this.cookieT, this.cookieC};
        return arr;
    }

    public YahooConference createConference(String[] users, String msg) throws IllegalStateException, IOException, IllegalIdentityException {
        for (int i = 0; i < users.length; ++i) {
            if (!this.primaryID.getId().equals(users[i]) && !this.loginID.getId().equals(users[i]) && !this.identities.containsKey(users[i])) continue;
            throw new IllegalIdentityException(users[i] + " is an identity of this session and cannot be used here");
        }
        return this.createConference(users, msg, this.loginID);
    }

    public YahooConference createConference(String[] users, String msg, YahooIdentity yid) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkStatus();
        if (!this.identities.containsKey(yid.getId())) {
            throw new IllegalIdentityException("The YahooIdentity '" + yid.getId() + "'is not a valid identity for this session.");
        }
        for (int i = 0; i < users.length; ++i) {
            if (!this.primaryID.getId().equals(users[i]) && !this.loginID.getId().equals(users[i]) && !this.identities.containsKey(users[i])) continue;
            throw new IllegalIdentityException(users[i] + " is an identity of this session and cannot be used here");
        }
        String conferenceName = this.getConferenceName(yid.getId());
        this.transmitConfInvite(users, yid.getId(), conferenceName, msg);
        return this.getConference(conferenceName);
    }

    public void acceptConferenceInvite(YahooConference room) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfLogon(room.getName(), room.getIdentity().getId());
    }

    public void declineConferenceInvite(YahooConference room, String msg) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfDecline(room.getName(), room.getIdentity().getId(), msg);
    }

    public void extendConference(YahooConference room, String username, String msg) throws IllegalStateException, IOException, NoSuchConferenceException, IllegalIdentityException {
        this.checkStatus();
        String id = username;
        if (this.primaryID.getId().equals(id) || this.loginID.getId().equals(id) || this.identities.containsKey(id)) {
            throw new IllegalIdentityException(id + " is an identity of this session and cannot be used here");
        }
        this.transmitConfAddInvite(username, room.getName(), room.getIdentity().getId(), msg);
    }

    public void sendConferenceMessage(YahooConference room, String msg) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfMsg(room.getName(), room.getIdentity().getId(), msg);
    }

    public void leaveConference(YahooConference room) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfLogoff(room.getName(), room.getIdentity().getId());
    }

    @Override
    public void sendNewFriendRequest(String userId, String groupId, YahooProtocol yahooProtocol) throws IOException {
        log.trace((Object)("Adding new user: " + userId + ", group: " + groupId + ", protocol: " + (Object)((Object)yahooProtocol)));
        this.transmitFriendAdd(userId, groupId, yahooProtocol);
    }

    @Override
    public void removeFriendFromGroup(String friendId, String groupId) throws IOException {
        this.transmitFriendRemove(friendId, groupId);
    }

    public void renameGroup(String oldName, String newName) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitGroupRename(oldName, newName);
    }

    public void rejectContact(SessionEvent se, String msg) throws IllegalArgumentException, IllegalStateException, IOException {
        if (se.getFrom() == null || se.getTo() == null) {
            throw new IllegalArgumentException("Missing to or from field in event object.");
        }
        this.checkStatus();
        this.transmitContactReject(se.getFrom(), se.getTo(), msg);
    }

    public void ignoreContact(String friend, boolean ignore) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitContactIgnore(friend, ignore);
    }

    public void refreshFriends() throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitList();
    }

    public void rejectFriendAuthorization(SessionAuthorizationEvent ev, String friend, String msg) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitRejectBuddy(friend, ev.getTo(), msg);
    }

    public void acceptFriendAuthorization(String friend, YahooProtocol procotol) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitAcceptBuddy(friend, procotol.getStringValue());
    }

    public void sendFileTransfer(String user, File file, String msg) throws IllegalStateException, FileTransferFailedException, IOException {
        this.checkStatus();
        this.transmitFileTransfer(user, msg, file);
    }

    public void saveFileTransferAs(SessionFileTransferEvent ev, String filename) throws FileTransferFailedException, IOException {
        this.saveFT(ev, null, filename);
    }

    public void saveFileTransferTo(SessionFileTransferEvent ev, String dir) throws FileTransferFailedException, IOException {
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        this.saveFT(ev, dir, ev.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFT(SessionFileTransferEvent ev, String path, String filename) throws FileTransferFailedException, IOException {
        byte[] buff = new byte[4096];
        HttpURLConnection uConn = (HttpURLConnection)ev.getLocation().openConnection();
        Util.initURLConnection(uConn);
        uConn.setRequestProperty("User-Agent", "Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
        uConn.setRequestProperty("Cookie", this.cookieY + "; " + this.cookieT);
        uConn.connect();
        if (uConn.getResponseCode() != 200) {
            throw new FileTransferFailedException("Server HTTP error code: " + uConn.getResponseCode());
        }
        String rp = uConn.getHeaderField("Content-Disposition");
        if (path != null && rp != null) {
            int i = rp.indexOf("filename=");
            if (i >= 0) {
                filename = rp.substring(i + 9);
            }
            if (filename.charAt(0) == '\"') {
                filename = filename.substring(1, filename.length() - 1);
            }
        }
        if (path != null) {
            filename = path + filename;
        }
        InputStream is = uConn.getInputStream();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filename));
        try {
            int len;
            do {
                if ((len = is.read(buff)) <= 0) continue;
                bos.write(buff, 0, len);
            } while (len >= 0);
            bos.flush();
        }
        finally {
            bos.close();
            is.close();
        }
        uConn.disconnect();
    }

    public void chatLogin(YahooChatLobby lobby) throws IllegalStateException, IOException, LoginRefusedException {
        this.chatLogin(lobby, this.loginID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chatLogin(YahooChatLobby lobby, YahooIdentity yahooId) throws IllegalStateException, IOException, LoginRefusedException, IllegalIdentityException {
        this.checkStatus();
        if (!this.identities.containsKey(yahooId.getId())) {
            throw new IllegalIdentityException("The YahooIdentity '" + yahooId.getId() + "'is not a valid identity for this session.");
        }
        Session session = this;
        synchronized (session) {
            if (this.chatSessionStatus != SessionState.UNSTARTED && this.chatSessionStatus != SessionState.LOGGED_ON) {
                throw new IllegalStateException("Chat session should be unstarted or messaging. You can't login to two chatrooms at the same time. Wait for one login to complete before connecting to the next one.");
            }
            this.chatSessionStatus = SessionState.CONNECTING;
        }
        long timeout = System.currentTimeMillis() + (long)Util.loginTimeout(60);
        this.chatID = yahooId;
        try {
            this.transmitChatConnect(this.chatID.getId());
            while (this.chatSessionStatus != SessionState.CONNECTED && !this.past(timeout)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
            if (this.past(timeout)) {
                throw new InterruptedIOException("Chat connect timed out");
            }
            this.transmitChatJoin(lobby.getNetworkName(), lobby.getParentRoomId());
            while (this.chatSessionStatus == SessionState.CONNECTED && !this.past(timeout)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
            if (this.past(timeout)) {
                throw new InterruptedIOException("Chat login timed out");
            }
            if (this.chatSessionStatus == SessionState.FAILED) {
                throw (LoginRefusedException)this.loginException;
            }
            this.currentLobby = this.chatSessionStatus == SessionState.LOGGED_ON ? lobby : null;
        }
        finally {
            if (this.chatSessionStatus != SessionState.LOGGED_ON) {
                this.chatSessionStatus = SessionState.FAILED;
                this.chatID = null;
            }
        }
    }

    public synchronized void chatLogout() throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatDisconnect(this.currentLobby.getNetworkName());
        this.currentLobby = null;
    }

    public synchronized void extendChat(String to, String msg) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        String netName = this.currentLobby.getNetworkName();
        long roomId = this.currentLobby.getParentRoomId();
        this.transmitChatInvite(netName, roomId, to, msg);
    }

    public void sendChatMessage(String msg) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatMsg(this.currentLobby.getNetworkName(), msg, false);
    }

    public void sendChatEmote(String emote) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatMsg(this.currentLobby.getNetworkName(), emote, true);
    }

    public YahooChatLobby getCurrentChatLobby() {
        return this.currentLobby;
    }

    public SessionState getChatSessionStatus() {
        return this.chatSessionStatus;
    }

    public void resetChat() throws IllegalStateException {
        if (this.chatSessionStatus != SessionState.FAILED && this.chatSessionStatus != SessionState.UNSTARTED) {
            throw new IllegalStateException("Chat session currently active");
        }
        this.chatSessionStatus = SessionState.UNSTARTED;
    }

    protected void transmitAuth() throws IOException {
        if (this.sessionStatus != SessionState.CONNECTING) {
            throw new IllegalStateException("Cannot transmit an AUTH packet if you're not completely unconnected to the Yahoo Network. Current state: " + (Object)((Object)this.sessionStatus));
        }
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID.getId());
        this.sendPacket(body, ServiceType.AUTH);
    }

    protected void transmitAuthResp(String plp, String crp, String base64) throws IOException {
        if (this.sessionStatus != SessionState.CONNECTED) {
            throw new IllegalStateException("Cannot transmit an AUTHRESP packet if you're not completely connected to the Yahoo Network. Current state: " + (Object)((Object)this.sessionStatus));
        }
        if (base64 == null) {
            PacketBodyBuffer body = new PacketBodyBuffer();
            body.addElement("0", this.loginID.getId());
            body.addElement("6", plp);
            body.addElement("96", crp);
            body.addElement("2", this.loginID.getId());
            body.addElement("2", "1");
            body.addElement("244", "2097087");
            body.addElement("148", "180");
            body.addElement("135", "9.0.0.2152");
            body.addElement("1", this.loginID.getId());
            if (this.pictureHandler != null && this.pictureHandler.getPictureChecksum() != null) {
                body.addElement("192", this.pictureHandler.getPictureChecksum());
            }
            this.sendPacket(body, ServiceType.AUTHRESP, this.status);
        } else {
            PacketBodyBuffer body = new PacketBodyBuffer();
            body.addElement("1", this.loginID.getId());
            body.addElement("0", this.loginID.getId());
            body.addElement("277", plp);
            body.addElement("278", crp);
            body.addElement("307", base64);
            body.addElement("244", "4194239");
            body.addElement("2", this.loginID.getId());
            body.addElement("2", "1");
            body.addElement("135", "9.0.0.2152");
            if (this.pictureHandler != null && this.pictureHandler.getPictureChecksum() != null) {
                body.addElement("192", this.pictureHandler.getPictureChecksum());
            }
            this.sendPacket(body, ServiceType.AUTHRESP, this.status);
        }
    }

    protected void transmitChatConnect(String yid) throws IOException {
        this.chatSessionStatus = SessionState.CONNECTING;
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("109", this.primaryID.getId());
        body.addElement("1", yid);
        body.addElement("6", "abcde");
        this.sendPacket(body, ServiceType.CHATCONNECT);
    }

    protected void transmitChatCreate(long catId, String rname, String topic, boolean pub) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.chatID.getId());
        body.addElement("104", rname);
        body.addElement("105", topic);
        body.addElement("126", "0");
        body.addElement("128", catId + "");
        body.addElement("129", catId + "");
        body.addElement("62", "2");
        this.sendPacket(body, ServiceType.getServiceType(169));
    }

    protected void transmitChatDisconnect(String room) throws IOException {
        this.chatSessionStatus = SessionState.UNSTARTED;
        this.currentLobby = null;
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("104", room);
        body.addElement("109", this.chatID.getId());
        this.sendPacket(body, ServiceType.CHATDISCONNECT);
    }

    protected void transmitChatInvite(String netname, long id, String to, String msg) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.chatID.getId());
        body.addElement("104", netname);
        body.addElement("117", msg);
        body.addElement("118", to);
        body.addElement("129", id + "");
        this.sendPacket(body, ServiceType.getServiceType(157));
    }

    protected void transmitChatJoin(String netname, long roomId) throws IOException {
        if (this.sessionStatus != SessionState.CONNECTED) {
            throw new IllegalStateException("Logging on is only possible right after successfully connecting to the network.");
        }
        if (netname == null || netname.length() < 3 || !netname.contains(":")) {
            throw new IllegalStateException("Argument 'netname' cannot be null and must include network name, containing a room and lobby name seperated by a colon (':') character.");
        }
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.chatID.getId());
        body.addElement("104", netname);
        body.addElement("129", Long.toString(roomId));
        body.addElement("62", "2");
        this.sendPacket(body, ServiceType.CHATJOIN);
    }

    protected void transmitChatMsg(String netname, String msg, boolean emote) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.chatID.getId());
        body.addElement("104", netname);
        body.addElement("117", msg);
        if (emote) {
            body.addElement("124", "2");
        } else {
            body.addElement("124", "1");
        }
        if (Util.isUtf8(msg)) {
            body.addElement("97", "1");
        }
        this.sendPacket(body, ServiceType.CHATMSG);
    }

    protected void transmitChatPM(String to, String msg) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("5", to);
        body.addElement("14", msg);
        this.sendPacket(body, ServiceType.CHATPM);
    }

    protected void transmitChatPing() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        this.sendPacket(body, ServiceType.CHATPING);
    }

    protected void transmitConfAddInvite(String username, String room, String yid, String msg) throws IOException, NoSuchConferenceException {
        this.getConference(room);
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("51", username);
        body.addElement("57", room);
        Set<YahooUser> users = this.getConference(room).getUsers();
        for (YahooUser u : users) {
            body.addElement("53", u.getId());
        }
        body.addElement("58", msg);
        body.addElement("13", "0");
        this.sendPacket(body, ServiceType.CONFADDINVITE);
    }

    protected void transmitConfDecline(String room, String yid, String msg) throws IOException, NoSuchConferenceException {
        YahooConference yc = this.getConference(room);
        yc.closeConference();
        Set<YahooUser> users = yc.getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (YahooUser user : users) {
            body.addElement("3", user.getId());
        }
        body.addElement("57", room);
        body.addElement("14", msg);
        this.sendPacket(body, ServiceType.CONFDECLINE);
    }

    protected void transmitConfInvite(String[] users, String yid, String room, String msg) throws IOException {
        this.conferences.put(room, new YahooConference(this.identities.get(yid.toLowerCase()), room, msg, this, false));
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("57", room);
        for (int i = 0; i < users.length; ++i) {
            body.addElement("52", users[i]);
        }
        body.addElement("58", msg);
        body.addElement("97", "1");
        body.addElement("13", "0");
        this.sendPacket(body, ServiceType.CONFINVITE);
    }

    protected void transmitConfLogoff(String room, String yid) throws IOException, NoSuchConferenceException {
        YahooConference yc = this.getConference(room);
        yc.closeConference();
        Set<YahooUser> users = yc.getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (YahooUser user : users) {
            body.addElement("3", user.getId());
        }
        body.addElement("57", room);
        this.sendPacket(body, ServiceType.CONFLOGOFF);
    }

    protected void transmitConfLogon(String room, String yid) throws IOException, NoSuchConferenceException {
        Set<YahooUser> users = this.getConference(room).getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (YahooUser user : users) {
            body.addElement("3", user.getId());
        }
        body.addElement("57", room);
        this.sendPacket(body, ServiceType.CONFLOGON);
    }

    protected void transmitConfMsg(String room, String yid, String msg) throws IOException, NoSuchConferenceException {
        Set<YahooUser> users = this.getConference(room).getUsers();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        for (YahooUser user : users) {
            body.addElement("53", user.getId());
        }
        body.addElement("57", room);
        body.addElement("14", msg);
        if (Util.isUtf8(msg)) {
            body.addElement("97", "1");
        }
        this.sendPacket(body, ServiceType.CONFMSG);
    }

    protected void transmitContactIgnore(String friend, boolean ignore) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID.getId());
        body.addElement("7", friend);
        if (ignore) {
            body.addElement("13", "1");
        } else {
            body.addElement("13", "2");
        }
        this.sendPacket(body, ServiceType.CONTACTIGNORE);
    }

    protected void transmitContactReject(String friend, String yid, String msg) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("7", friend);
        body.addElement("14", msg);
        this.sendPacket(body, ServiceType.CONTACTREJECT);
    }

    protected void transmitRejectBuddy(String friend, String yid, String msg) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("7", friend);
        body.addElement("13", "2");
        if (msg != null) {
            body.addElement("14", msg);
        }
        this.sendPacket(body, ServiceType.Y7_AUTHORIZATION, Status.AVAILABLE);
    }

    protected void transmitAcceptBuddy(String friend, String type) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID.getId());
        body.addElement("5", friend);
        body.addElement("241", type);
        body.addElement("13", "1");
        this.sendPacket(body, ServiceType.Y7_AUTHORIZATION, Status.AVAILABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transmitFileTransfer(String to, String message, File file) throws FileTransferFailedException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 'file' cannot be null.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("The provided file object does not denote a normal file (but possibly a directory).");
        }
        if (file.length() == 0L) {
            throw new FileTransferFailedException("File transfer: empty file");
        }
        String cookie = this.cookieY + "; " + this.cookieT;
        byte[] marker = new byte[]{50, 57, -64, -128};
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("0", this.primaryID.getId());
        body.addElement("5", to);
        body.addElement("28", Long.toString(file.length()));
        body.addElement("27", file.getName());
        body.addElement("14", message);
        byte[] packet = body.getBuffer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.write(NetworkConstants.MAGIC, 0, 4);
        dos.write(NetworkConstants.VERSION, 0, 4);
        dos.writeShort(packet.length + 4 & 0xFFFF);
        dos.writeShort(ServiceType.FILETRANSFER.getValue() & 0xFFFF);
        dos.writeInt((int)(this.status.getValue() & 0xFFFFFFFFFFFFFFFFL));
        dos.writeInt((int)(this.sessionId & 0xFFFFFFFFFFFFFFFFL));
        dos.write(packet, 0, packet.length);
        dos.write(marker, 0, 4);
        packet = baos.toByteArray();
        String ftHost = Util.fileTransferHost();
        String ftURL = "http://" + ftHost + ":80/notifyft";
        HttpURLConnection uConn = (HttpURLConnection)new URL(ftURL).openConnection();
        uConn.setRequestMethod("POST");
        uConn.setDoOutput(true);
        Util.initURLConnection(uConn);
        uConn.setRequestProperty("Content-Length", Long.toString(file.length() + (long)packet.length));
        uConn.setRequestProperty("User-Agent", "Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
        uConn.setRequestProperty("Cookie", cookie);
        uConn.connect();
        BufferedOutputStream bos = new BufferedOutputStream(uConn.getOutputStream());
        try {
            bos.write(packet);
            bos.write(Util.getBytesFromFile(file));
            bos.flush();
        }
        finally {
            bos.close();
        }
        int ret = uConn.getResponseCode();
        uConn.disconnect();
        if (ret != 200) {
            throw new FileTransferFailedException("Server rejected upload");
        }
    }

    protected void transmitFriendAdd(String userId, String groupId, YahooProtocol yahooProtocol) throws IOException {
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException("Argument 'userId' cannot be null or an empty String.");
        }
        if (groupId == null || groupId.length() == 0) {
            throw new IllegalArgumentException("Argument 'groupId' cannot be null or an empty String.");
        }
        this.checkStatus();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID.getId());
        body.addElement("302", "319");
        body.addElement("300", "319");
        body.addElement("7", userId);
        body.addElement("241", "" + yahooProtocol.getValue());
        body.addElement("301", "319");
        body.addElement("303", "319");
        body.addElement("65", groupId);
        body.addElement("14", "");
        body.addElement("216", "");
        body.addElement("254", "");
        body.addElement("97", "1");
        this.sendPacket(body, ServiceType.FRIENDADD);
    }

    protected void transmitFriendRemove(String friendId, String groupId) throws IOException {
        if (friendId == null || friendId.length() == 0) {
            throw new IllegalArgumentException("Argument 'friendId' cannot be null or an empty String.");
        }
        if (groupId == null || groupId.length() == 0) {
            throw new IllegalArgumentException("Argument 'groupId' cannot be null or an empty String.");
        }
        this.checkStatus();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID.getId());
        body.addElement("7", friendId);
        body.addElement("241", "0");
        body.addElement("65", groupId);
        this.sendPacket(body, ServiceType.FRIENDREMOVE);
    }

    protected void transmitGroupRename(String oldName, String newName) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID.getId());
        body.addElement("65", oldName);
        body.addElement("67", newName);
        this.sendPacket(body, ServiceType.GROUPRENAME);
    }

    protected void transmitIdActivate(String id) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("3", id);
        this.sendPacket(body, ServiceType.IDACT);
    }

    protected void transmitIdDeactivate(String id) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("3", id);
        this.sendPacket(body, ServiceType.IDDEACT);
    }

    protected void transmitIdle() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.loginID.getId());
        body.addElement("0", this.primaryID.getId());
        this.sendPacket(body, ServiceType.IDLE);
    }

    protected void transmitNewStatus() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("10", String.valueOf(this.status.getValue()));
        body.addElement("19", "");
        this.sendPacket(body, ServiceType.Y6_STATUS_UPDATE);
    }

    protected void transmitNewCustomStatus() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("10", "99");
        body.addElement("19", this.customStatusMessage);
        body.addElement("97", "1");
        this.sendPacket(body, ServiceType.Y6_STATUS_UPDATE, Status.AVAILABLE);
    }

    protected void transmitList() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", this.primaryID.getId());
        this.sendPacket(body, ServiceType.LIST);
    }

    protected void transmitLogoff() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("0", this.loginID.getId());
        this.sendPacket(body, ServiceType.LOGOFF);
        this.ipThread.stopMe();
        this.network.close();
    }

    protected String transmitMessage(String to, YahooIdentity yid, String msg) throws IOException {
        if (to == null || to.length() == 0) {
            throw new IllegalArgumentException("Argument 'to' cannot be null or an empty String.");
        }
        if (yid == null) {
            throw new IllegalArgumentException("Argument 'yid' cannot be null.");
        }
        String type = this.getType(to);
        String messageNumberString = this.buildMessageNumber();
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid.getId());
        body.addElement("5", to);
        body.addElement("241", type);
        body.addElement("14", msg);
        if (Util.isUtf8(msg)) {
            body.addElement("97", "1");
        }
        body.addElement("63", ";" + this.imvironment);
        body.addElement("64", "0");
        body.addElement("206", "0");
        body.addElement("429", messageNumberString);
        body.addElement("450", "0");
        this.sendPacket(body, ServiceType.MESSAGE, Status.OFFLINE);
        return messageNumberString;
    }

    protected String getType(String to) {
        YahooUser user = this.roster.getUser(to);
        if (user == null || user.getProtocol() == null) {
            return YahooProtocol.YAHOO.getStringValue();
        }
        return user.getProtocol().getStringValue();
    }

    protected String buildMessageNumber() {
        String blankMessageNumber = "0000000000000000";
        String messageNumber = "" + this.messageNumber++;
        messageNumber = blankMessageNumber.substring(0, blankMessageNumber.length() - messageNumber.length()) + messageNumber;
        return messageNumber;
    }

    public void sendTypingNotification(String friend, boolean isTyping) throws IOException {
        String type = this.getType(friend);
        this.transmitNotify(friend, this.primaryID.getId(), isTyping, " ", "TYPING", type);
    }

    protected void transmitNotify(String friend, String yid, boolean on, String msg, String mode, String type) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("49", mode);
        body.addElement("1", yid);
        body.addElement("14", msg);
        if (on) {
            body.addElement("13", "1");
        } else {
            body.addElement("13", "0");
        }
        body.addElement("5", friend);
        body.addElement("241", type);
        this.sendPacket(body, ServiceType.NOTIFY, Status.TYPING);
    }

    protected void transmitKeepAlive() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("0", this.primaryID.getId());
        this.sendPacket(body, ServiceType.KEEPALIVE);
    }

    protected void transmitPings() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        this.sendPacket(body, ServiceType.PING);
    }

    protected void transmitUserStat() throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        this.sendPacket(body, ServiceType.USERSTAT);
    }

    protected void transmitStealthSession(int stat, int flag, String yid, String target) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("1", yid);
        body.addElement("31", stat + "");
        body.addElement("13", flag + "");
        body.addElement("7", target);
        this.sendPacket(body, ServiceType.getServiceType(186));
    }

    protected void receiveAddIgnore(YMSG9Packet pkt) {
    }

    protected void receiveAuth(YMSG9Packet pkt) throws IOException, YahooException {
        String[] s;
        if (this.sessionStatus != SessionState.CONNECTING) {
            throw new IllegalStateException("Received a response to an AUTH packet, outside the normal login flow. Current state: " + (Object)((Object)this.sessionStatus));
        }
        log.trace((Object)"Received AUTH from server. Going to parse challenge...");
        String v10 = pkt.getValue("13");
        String seed = pkt.getValue("94");
        try {
            if (v10 != null && v10.equals("0")) {
                log.trace((Object)"Parsing V9 challenge...");
                s = ChallengeResponseV9.getStrings(this.loginID.getId(), this.password, pkt.getValue("94"));
            } else if (v10 != null && v10.equals("1")) {
                log.trace((Object)"Parsing V10 challenge...");
                s = ChallengeResponseV10.getStrings(this.loginID.getId(), this.password, pkt.getValue("94"));
            } else {
                s = this.yahooAuth16Stage1(seed);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new YMSG9BadFormatException("auth", pkt, e);
        }
        catch (IOException e) {
            this.loginException = new FailedLoginException("User " + this.loginID + ": Login failed unexpectedly.", e);
            throw this.loginException;
        }
        catch (LoginRefusedException e) {
            this.loginException = e;
            throw e;
        }
        catch (Exception e) {
            this.loginException = new FailedLoginException("User " + this.loginID + ": Login failed unexpectedly.", e);
            throw this.loginException;
        }
        this.sessionStatus = SessionState.CONNECTED;
        log.trace((Object)"Going to transmit Auth response, containing the challenge...");
        if (s.length > 2) {
            this.transmitAuthResp(s[0], s[1], s[2]);
        } else {
            this.transmitAuthResp(s[0], s[1], null);
        }
        this.loadAddressBook(s);
    }

    private void loadAddressBook(String[] sessionCookies) {
        log.trace((Object)"loadAddressBook");
        BuddyListImport buddyListImport = new BuddyListImport(this.loginID.getId(), this.roster, sessionCookies);
        try {
            buddyListImport.process(this.loginID.getId(), this.password);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String[] yahooAuth16Stage1(String seed) throws LoginRefusedException, IOException, NoSuchAlgorithmException {
        String authLink = "https://login.yahoo.com/config/pwtoken_get?src=ymsgr&ts=&login=" + this.loginID.getId() + "&passwd=" + URLEncoder.encode(this.password, "UTF-8") + "&chal=" + URLEncoder.encode(seed, "UTF-8");
        URL u = new URL(authLink);
        URLConnection uc = u.openConnection();
        if (uc instanceof HttpURLConnection) {
            int responseCode = ((HttpURLConnection)uc).getResponseCode();
            if (responseCode == 200) {
                InputStream in = uc.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int read = -1;
                byte[] buff = new byte[256];
                while ((read = in.read(buff)) != -1) {
                    out.write(buff, 0, read);
                }
                in.close();
                StringTokenizer toks = new StringTokenizer(out.toString(), "\r\n");
                if (toks.countTokens() <= 0) {
                    throw new LoginRefusedException("Login Failed, wrong response in stage 1:" + ((HttpURLConnection)uc).getResponseMessage());
                }
                int responseNo = -1;
                try {
                    responseNo = Integer.valueOf(toks.nextToken());
                }
                catch (NumberFormatException e) {
                    throw new LoginRefusedException("Login Failed, wrong response in stage 1:" + ((HttpURLConnection)uc).getResponseMessage());
                }
                if (responseNo != 0 || !toks.hasMoreTokens()) {
                    switch (responseNo) {
                        case 1235: {
                            throw new LoginRefusedException("Login Failed, Invalid username", AuthenticationState.BADUSERNAME);
                        }
                        case 1212: {
                            throw new LoginRefusedException("Login Failed, Wrong password", AuthenticationState.BAD);
                        }
                        case 1213: {
                            throw new LoginRefusedException("Login locked: Too many failed login attempts", AuthenticationState.LOCKED);
                        }
                        case 1236: {
                            throw new LoginRefusedException("Login locked", AuthenticationState.LOCKED);
                        }
                        case 100: {
                            throw new LoginRefusedException("Username or password missing", AuthenticationState.BAD);
                        }
                    }
                    throw new LoginRefusedException("Login Failed, Unkown error", AuthenticationState.BAD);
                }
                String ymsgr = toks.nextToken();
                if (ymsgr.indexOf("ymsgr=") == -1 && toks.hasMoreTokens()) {
                    ymsgr = toks.nextToken();
                }
                ymsgr = ymsgr.replaceAll("ymsgr=", "");
                return this.yahooAuth16Stage2(ymsgr, seed);
            }
            log.error((Object)("Failed opening login url: " + authLink + " return code: " + responseCode));
            throw new LoginRefusedException("Login Failed, Login url: " + authLink + " return code: " + responseCode);
        }
        Class<?> ucType = null;
        if (uc != null) {
            ucType = uc.getClass();
        }
        log.error((Object)("Failed opening login url: " + authLink + " returns: " + ucType));
        throw new LoginRefusedException("Login Failed, Unable to submit login url");
    }

    private String[] yahooAuth16Stage2(String token, String seed) throws LoginRefusedException, IOException, NoSuchAlgorithmException {
        int responseCode;
        String loginLink = "https://login.yahoo.com/config/pwtoken_login?src=ymsgr&ts=&token=" + token;
        URL u = new URL(loginLink);
        URLConnection uc = u.openConnection();
        if (uc instanceof HttpURLConnection && (responseCode = ((HttpURLConnection)uc).getResponseCode()) == 200) {
            InputStream in = uc.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int read = -1;
            byte[] buff = new byte[256];
            while ((read = in.read(buff)) != -1) {
                out.write(buff, 0, read);
            }
            int responseNo = -1;
            String crumb = null;
            String cookieY = null;
            String cookieT = null;
            StringTokenizer toks = new StringTokenizer(out.toString(), "\r\n");
            if (toks.countTokens() <= 0) {
                throw new LoginRefusedException("Login Failed, wrong response in stage 2:" + ((HttpURLConnection)uc).getResponseMessage());
            }
            try {
                responseNo = Integer.valueOf(toks.nextToken());
            }
            catch (NumberFormatException e) {
                throw new LoginRefusedException("Login Failed, wrong response in stage 2:" + ((HttpURLConnection)uc).getResponseMessage());
            }
            if (responseNo != 0 || !toks.hasMoreTokens()) {
                throw new LoginRefusedException("Login Failed, Unkown error", AuthenticationState.BAD);
            }
            while (toks.hasMoreTokens()) {
                String t = toks.nextToken();
                if (t.startsWith("crumb=")) {
                    crumb = t.replaceAll("crumb=", "");
                    continue;
                }
                if (t.startsWith("Y=")) {
                    cookieY = t.replaceAll("Y=", "");
                    continue;
                }
                if (!t.startsWith("T=")) continue;
                cookieT = t.replaceAll("T=", "");
            }
            if (crumb == null || cookieT == null || cookieY == null) {
                throw new LoginRefusedException("Login Failed, Unkown error", AuthenticationState.BAD);
            }
            this.cookieY = cookieY;
            this.cookieT = cookieT;
            return this.yahooAuth16Stage3(crumb + seed, cookieY, cookieT);
        }
        throw new LoginRefusedException("Login Failed, unable to retrieve stage 2 url");
    }

    private String[] yahooAuth16Stage3(String crypt, String cookieY, String cookieT) throws NoSuchAlgorithmException {
        return ChallengeResponseV16.getStrings(cookieY, cookieT, crypt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveAuthResp(YMSG9Packet pkt) {
        block16: {
            log.trace((Object)"Received AUTHRESP packet.");
            SessionLogoutEvent sessionEvent = null;
            try {
                if (pkt.exists("66")) {
                    long l = Long.parseLong(pkt.getValue("66"));
                    switch (AuthenticationState.getStatus(l)) {
                        case LOCKED: {
                            URL u;
                            try {
                                u = new URL(pkt.getValue("20"));
                            }
                            catch (Exception e) {
                                u = null;
                            }
                            this.loginException = new AccountLockedException("User " + this.loginID + " has been locked out", u);
                            log.info((Object)("AUTHRESP says: authentication failed! " + this.loginID), (Throwable)this.loginException);
                            sessionEvent = new SessionLogoutEvent((Object)AuthenticationState.LOCKED);
                            break;
                        }
                        case BAD2: 
                        case BAD: {
                            this.loginException = new LoginRefusedException("User " + this.loginID + " refused login" + this.loginID, AuthenticationState.BAD);
                            log.info((Object)("AUTHRESP says: authentication failed! " + this.loginID), (Throwable)this.loginException);
                            sessionEvent = new SessionLogoutEvent((Object)AuthenticationState.BAD);
                            break;
                        }
                        case BADUSERNAME: {
                            this.loginException = new LoginRefusedException("User " + this.loginID + " unknown" + this.loginID, AuthenticationState.BADUSERNAME);
                            log.info((Object)("AUTHRESP says: authentication failed! " + this.loginID), (Throwable)this.loginException);
                            sessionEvent = new SessionLogoutEvent((Object)AuthenticationState.BADUSERNAME);
                            break;
                        }
                        case INVALID_CREDENTIALS: {
                            this.loginException = new LoginRefusedException("User " + this.loginID + " invalid Credentials" + this.loginID, AuthenticationState.BADUSERNAME);
                            log.info((Object)("AUTHRESP says: authentication failed! " + this.loginID), (Throwable)this.loginException);
                            sessionEvent = new SessionLogoutEvent((Object)AuthenticationState.INVALID_CREDENTIALS);
                            break;
                        }
                        case DUPLICATE_LOGIN: {
                            this.loginException = new LoginRefusedException("User " + this.loginID + " unknown" + this.loginID, AuthenticationState.DUPLICATE_LOGIN);
                            log.info((Object)("AUTHRESP says: authentication failed! " + this.loginID), (Throwable)this.loginException);
                            sessionEvent = new SessionLogoutEvent((Object)AuthenticationState.DUPLICATE_LOGIN);
                            break;
                        }
                        case UNKNOWN_52: {
                            this.loginException = new LoginRefusedException("User " + this.loginID + " was forced off" + this.loginID, AuthenticationState.UNKNOWN_52);
                            log.info((Object)("AUTHRESP says: authentication failed with unknown: " + (Object)((Object)AuthenticationState.UNKNOWN_52) + " " + this.loginID), (Throwable)this.loginException);
                            sessionEvent = new SessionLogoutEvent((Object)AuthenticationState.UNKNOWN_52);
                        }
                    }
                    break block16;
                }
                this.loginException = new LoginRefusedException("User " + this.loginID + " was forced off" + this.loginID, AuthenticationState.NO_REASON);
                log.info((Object)("AUTHRESP says: authentication failed without a reason " + this.loginID), (Throwable)this.loginException);
                sessionEvent = new SessionLogoutEvent((Object)AuthenticationState.NO_REASON);
            }
            catch (IllegalArgumentException ex) {
                this.loginException = new LoginRefusedException("User " + this.loginID + ": Login refused. The reason why is unrecognized.", ex);
            }
            finally {
                this.ipThread.stopMe();
                this.sessionStatus = SessionState.FAILED;
                this.eventDispatchQueue.append(sessionEvent, ServiceType.LOGOFF);
            }
        }
    }

    protected void receiveChatConnect(YMSG9Packet pkt) {
        if (this.chatSessionStatus != SessionState.CONNECTING) {
            throw new IllegalStateException("Received a 'CHATCONNECT' packet outside of the logon process. Current state: " + (Object)((Object)this.chatSessionStatus));
        }
        this.chatSessionStatus = SessionState.CONNECTED;
    }

    protected void receiveChatDisconnect(YMSG9Packet pkt) {
        if (this.chatSessionStatus != SessionState.UNSTARTED) {
            this.eventDispatchQueue.append(new SessionEvent(this), ServiceType.CHATDISCONNECT);
        }
        this.chatSessionStatus = SessionState.UNSTARTED;
    }

    protected void receiveChatExit(YMSG9Packet pkt) {
        try {
            String netname = pkt.getValue("104");
            String id = pkt.getValue("109");
            YahooChatLobby ycl = this.chatroomManager.getLobby(netname);
            if (ycl == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + netname + " not found.");
            }
            YahooChatUser ycu = ycl.getUser(id);
            if (ycu != null) {
                ycl.removeUser(ycu);
            } else {
                ycu = this.createChatUser(pkt, 0);
            }
            SessionChatEvent se = new SessionChatEvent(this, 1, ycl);
            se.setChatUser(0, ycu);
            this.eventDispatchQueue.append(se, ServiceType.CHATEXIT);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("chat logoff", pkt, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void receiveChatJoin(YMSG9Packet pkt) {
        int cnt;
        YahooChatLobby ycl;
        boolean joining = false;
        try {
            if (pkt.exists("114")) {
                this.loginException = new LoginRefusedException("User " + this.chatID + " refused chat login");
                joining = true;
                this.chatSessionStatus = SessionState.FAILED;
                return;
            }
            if ((pkt = this.compoundChatLoginPacket(pkt)) == null) {
                return;
            }
            String netname = pkt.getValue("104");
            ycl = this.chatroomManager.getLobby(netname);
            if (ycl == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + netname + " not found.");
            }
            if (pkt.exists("105")) {
                try {
                    int idx;
                    String captchaMsg = pkt.getValue("105");
                    String captchaURL = null;
                    int n = idx = captchaMsg != null ? captchaMsg.indexOf("http://captcha.") : -1;
                    if (idx >= 0) {
                        captchaURL = captchaMsg.substring(idx);
                    }
                    SessionChatEvent se = new SessionChatEvent((Object)this, captchaMsg, captchaURL, ycl);
                    this.eventDispatchQueue.append(se, ServiceType.X_CHATCAPTCHA);
                    return;
                }
                catch (Exception e) {
                    throw new YMSG9BadFormatException("chat captcha", pkt, e);
                }
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"error on receveing Chat join ", (Throwable)e);
            throw new YMSG9BadFormatException("chat login", pkt, e);
        }
        for (cnt = Integer.parseInt(pkt.getValue("108")); cnt > 0 && pkt.getNthValue("109", cnt - 1) == null; --cnt) {
        }
        YahooChatUser ycu = ycl.getUser(pkt.getValue("109"));
        if (cnt == 1 && ycu != null) {
            int attributes = Integer.parseInt(pkt.getValue("113"));
            String alias = pkt.getValue("141");
            int age = Integer.parseInt(pkt.getValue("110"));
            String location = pkt.getValue("142");
            ycu.setAttributes(attributes);
            ycu.setAlias(alias);
            ycu.setAge(age);
            ycu.setLocation(location);
            SessionChatEvent se = new SessionChatEvent(this, 1, ycl);
            se.setChatUser(0, ycu);
            this.eventDispatchQueue.append(se, ServiceType.X_CHATUPDATE);
            return;
        }
        joining = pkt.exists("61");
        if (joining) {
            ycl.clearUsers();
        }
        Hashtable<String, YahooChatUser> ht = new Hashtable<String, YahooChatUser>();
        for (int i = 0; i < cnt; ++i) {
            ycu = this.createChatUser(pkt, i);
            ht.put(ycu.getId(), ycu);
        }
        SessionChatEvent se = new SessionChatEvent(this, cnt, ycl);
        int i = 0;
        Enumeration en = ht.elements();
        while (en.hasMoreElements()) {
            ycu = (YahooChatUser)en.nextElement();
            if (!ycl.exists(ycu)) {
                ycl.addUser(ycu);
            }
            se.setChatUser(i++, ycu);
        }
        if (!joining) {
            if (se.getChatUsers().length <= 0) return;
            this.eventDispatchQueue.append(se, ServiceType.CHATJOIN);
            return;
        }
        this.chatSessionStatus = SessionState.LOGGED_ON;
        return;
        finally {
            if (joining && this.chatSessionStatus != SessionState.FAILED) {
                this.chatSessionStatus = SessionState.LOGGED_ON;
            }
        }
    }

    protected void receiveChatMsg(YMSG9Packet pkt) {
        if (this.chatSessionStatus != SessionState.LOGGED_ON) {
            throw new IllegalStateException("Time out on chat login.");
        }
        try {
            String netname = pkt.getValue("104");
            YahooChatLobby ycl = this.chatroomManager.getLobby(netname);
            if (ycl == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + netname + " not found.");
            }
            YahooChatUser ycu = ycl.getUser(pkt.getValue("109"));
            if (ycu == null) {
                ycu = this.createChatUser(pkt, 0);
            }
            SessionChatEvent se = new SessionChatEvent((Object)this, ycu, pkt.getValue("117"), pkt.getValue("124"), ycl);
            this.eventDispatchQueue.append(se, ServiceType.CHATMSG);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("chat message", pkt, e);
        }
    }

    protected void receiveChatPM(YMSG9Packet pkt) {
        if (this.chatSessionStatus != SessionState.LOGGED_ON) {
            throw new IllegalStateException("Time out on chat login.");
        }
        try {
            SessionEvent se = new SessionEvent(this, pkt.getValue("5"), pkt.getValue("4"), pkt.getValue("14"));
            this.eventDispatchQueue.append(se, ServiceType.MESSAGE);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("chat PM", pkt, e);
        }
    }

    protected void receiveConfDecline(YMSG9Packet pkt) {
        try {
            YahooConference yc = this.getOrCreateConference(pkt);
            String to = pkt.getValue("1");
            String from = pkt.getValue("54");
            String message = pkt.getValue("14");
            SessionConferenceDeclineInviteEvent se = new SessionConferenceDeclineInviteEvent((Object)this, to, from, message, yc);
            yc.removeUser(se.getFrom());
            if (!yc.isClosed()) {
                this.eventDispatchQueue.append(se, ServiceType.CONFDECLINE);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference decline", pkt, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfLogoff(YMSG9Packet pkt) {
        YahooConference yc = this.getOrCreateConference(pkt);
        String to = pkt.getValue("1");
        String from = pkt.getValue("56");
        YahooConference yahooConference = yc;
        synchronized (yahooConference) {
            if (!yc.isInvited()) {
                yc.addPacket(pkt);
                return;
            }
        }
        try {
            SessionConferenceLogoffEvent se = new SessionConferenceLogoffEvent((Object)this, to, from, yc);
            yc.removeUser(se.getFrom());
            if (!yc.isClosed()) {
                this.eventDispatchQueue.append(se, ServiceType.CONFLOGOFF);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference logoff", pkt, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfLogon(YMSG9Packet pkt) {
        YahooConference yc = this.getOrCreateConference(pkt);
        String to = pkt.getValue("1");
        String from = pkt.getValue("53");
        YahooConference yahooConference = yc;
        synchronized (yahooConference) {
            if (!yc.isInvited()) {
                yc.addPacket(pkt);
                return;
            }
        }
        try {
            SessionConferenceLogonEvent se = new SessionConferenceLogonEvent((Object)this, to, from, yc);
            yc.addUser(se.getFrom());
            if (!yc.isClosed()) {
                this.eventDispatchQueue.append(se, ServiceType.CONFLOGON);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference logon", pkt, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfMsg(YMSG9Packet pkt) {
        YahooConference yc = this.getOrCreateConference(pkt);
        String to = pkt.getValue("1");
        String from = pkt.getValue("3");
        String message = pkt.getValue("14");
        YahooConference yahooConference = yc;
        synchronized (yahooConference) {
            if (!yc.isInvited()) {
                yc.addPacket(pkt);
                return;
            }
        }
        try {
            SessionConferenceMessageEvent se = new SessionConferenceMessageEvent((Object)this, to, from, message, yc);
            if (!yc.isClosed()) {
                this.eventDispatchQueue.append(se, ServiceType.CONFMSG);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("conference mesg", pkt, e);
        }
    }

    protected void receiveContactIgnore(YMSG9Packet pkt) {
        try {
            String userId = pkt.getValue("0");
            boolean ignored = pkt.getValue("13").charAt(0) == '1';
            int st = Integer.parseInt(pkt.getValue("66"));
            if (st == 0) {
                YahooUser user = this.roster.getUser(userId);
                user.setIgnored(ignored);
                SessionFriendEvent se = new SessionFriendEvent(this, user);
                this.eventDispatchQueue.append(se, ServiceType.Y6_STATUS_UPDATE);
            } else {
                String m = "Contact ignore error: ";
                switch (st) {
                    case 2: {
                        m = m + "Already on ignore list";
                        break;
                    }
                    case 3: {
                        m = m + "Not currently ignored";
                        break;
                    }
                    case 12: {
                        m = m + "Cannot ignore friend";
                        break;
                    }
                    default: {
                        m = m + "Unknown error";
                    }
                }
                this.errorMessage(pkt, m);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("contact ignore", pkt, e);
        }
    }

    protected void receiveContactRejected(YMSG9Packet pkt) {
        String from = pkt.getValue("1");
        log.debug((Object)(from + " has rejected to been added like friend"));
    }

    protected void receiveContactNew(YMSG9Packet pkt) {
        if (pkt.length <= 0) {
            log.trace((Object)"Received an empty CONTACTNEW packet, which is probably sent back to us after we transmitted a FRIENDADD/REMOVE. Just ignore it.");
            return;
        }
        try {
            if (pkt.exists("7")) {
                log.trace((Object)"Received a CONTACTNEW packet, which is probably sent back to us after we transmitted a FRIENDADD/REMOVE. Pass it to updateFriendStatus.");
                this.updateFriendsStatus(pkt);
                return;
            }
            String userId = pkt.getValue("3");
            String message = pkt.getValue("14");
            if (pkt.status == 7L) {
                log.trace((Object)("A friend refused our subscription request: " + userId));
                YahooUser user = this.roster.getUser(userId);
                SessionFriendRejectedEvent se = new SessionFriendRejectedEvent(this, user, message);
                this.eventDispatchQueue.append(se, ServiceType.CONTACTREJECT);
                return;
            }
            log.trace((Object)("Someone is sending us a subscription request: " + userId));
            String to = pkt.getValue("1");
            String protocolString = pkt.getValue("241");
            YahooProtocol protocol = YahooProtocol.getProtocol(protocolString);
            SessionAuthorizationEvent se = new SessionAuthorizationEvent((Object)this, to, message, protocol);
            se.setStatus(pkt.status);
            this.eventDispatchQueue.append(se, ServiceType.CONTACTNEW);
        }
        catch (RuntimeException e) {
            throw new YMSG9BadFormatException("contact request", pkt, e);
        }
    }

    protected void receiveAuthorization(YMSG9Packet pkt) {
        try {
            if (pkt.length <= 0) {
                return;
            }
            String who = pkt.getValue("4");
            String msg = pkt.getValue("14");
            String fname = pkt.getValue("216");
            String lname = pkt.getValue("254");
            String id = pkt.getValue("5");
            String authStatus = pkt.getValue("13");
            String protocolString = pkt.getValue("241");
            YahooProtocol protocol = this.getUserProtocol(protocolString, who);
            if (pkt.status == 1L) {
                if (authStatus.equals("1")) {
                    log.trace((Object)("A friend accepted our authorization request: " + who));
                    YahooUser user = this.roster.getUser(who);
                    SessionFriendAcceptedEvent ser = new SessionFriendAcceptedEvent((Object)this, user, msg, protocol);
                    int eventStatus = 1;
                    ser.setStatus(eventStatus);
                    this.eventDispatchQueue.append(ser, ServiceType.Y7_AUTHORIZATION);
                } else if (authStatus.equals("2")) {
                    log.trace((Object)("A friend refused our subscription request: " + who));
                    log.debug((Object)("roster: " + this.roster));
                    log.debug((Object)("who: " + who));
                    YahooUser user = this.roster.getUser(who);
                    log.debug((Object)("user: " + user));
                    SessionFriendRejectedEvent ser = new SessionFriendRejectedEvent(this, user, msg);
                    log.debug((Object)("ser: " + ser));
                    int eventStatus = 2;
                    log.debug((Object)("eventStatus: " + eventStatus));
                    ser.setStatus(eventStatus);
                    this.eventDispatchQueue.append(ser, ServiceType.Y7_AUTHORIZATION);
                } else {
                    log.info((Object)("Unexpected authorization packet. Do not know how to handle: " + pkt));
                }
            } else if (pkt.status == 3L) {
                SessionAuthorizationEvent se = new SessionAuthorizationEvent(this, id, who, fname, lname, msg, protocol);
                se.setStatus(pkt.status);
                log.trace((Object)("Someone is sending us a subscription request: " + who));
                this.eventDispatchQueue.append(se, ServiceType.Y7_AUTHORIZATION);
            } else {
                log.info((Object)("Unexpected authorization packet. Do not know how to handle: " + pkt));
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("contact request", pkt, e);
        }
    }

    private YahooProtocol getUserProtocol(String protocolString, String who) {
        try {
            return YahooProtocol.getProtocol(protocolString);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Failed finding protocol: " + protocolString + " for user: " + who));
            return YahooProtocol.YAHOO;
        }
    }

    protected void receiveFileTransfer(YMSG9Packet pkt) {
        try {
            String to = pkt.getValue("5");
            String from = pkt.getValue("4");
            String message = pkt.getValue("14");
            if (!pkt.exists("38")) {
                SessionEvent se = new SessionEvent(this, to, from, message);
                this.eventDispatchQueue.append(se, ServiceType.MESSAGE);
            } else {
                String expires = pkt.getValue("38");
                String url = pkt.getValue("20");
                SessionFileTransferEvent se = new SessionFileTransferEvent(this, to, from, message, Long.valueOf(expires), url);
                this.eventDispatchQueue.append(se, ServiceType.FILETRANSFER);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("file transfer", pkt, e);
        }
    }

    protected void receiveFriendAdd(YMSG9Packet pkt) {
        try {
            String userId = null;
            String groupName = null;
            YahooUser user = null;
            String friendAddStatus = pkt.getValue("66");
            String myName = pkt.getValue("1");
            if (!"0".equals(friendAddStatus)) {
                log.warn((Object)("Me: " + myName + " Friend add status is not 0: " + friendAddStatus));
            }
            userId = pkt.getValue("7");
            groupName = pkt.getValue("65");
            if (pkt.status == 1L) {
                String pending = pkt.getValue("223");
                String protocol = pkt.getValue("241");
                log.trace((Object)("Me: " + myName + " Friend add is an ack: " + pkt.status + "/" + userId + ", error code: " + friendAddStatus + ", pending: " + pending + ", protocol: " + protocol));
                if (friendAddStatus.equals("0")) {
                    log.info((Object)("Me: " + myName + " friend added: " + userId + ", pending: " + pending + ", protocol: " + protocol));
                    user = this.roster.getUser(userId);
                    if (user == null) {
                        YahooProtocol yahooProtocol = this.getUserProtocol(protocol, userId);
                        user = new YahooUser(userId, groupName, yahooProtocol);
                    }
                    SessionFriendEvent se = new SessionFriendEvent(this, user, groupName);
                    this.eventDispatchQueue.append(se, ServiceType.FRIENDADD);
                } else {
                    if (friendAddStatus.equals("2")) {
                        log.warn((Object)("Me: " + myName + " friend already in list: " + userId + ", pending: " + pending + ", protocol: " + protocol));
                    } else if (friendAddStatus.equals("3")) {
                        log.warn((Object)("Me: " + myName + " friend does not exist in yahoo: " + userId + ", pending: " + pending + ", protocol: " + protocol));
                    } else {
                        log.warn((Object)("Me: " + myName + " problem adding friend: " + userId + ", pending: " + pending + ", protocol: " + protocol + ", error code: " + friendAddStatus));
                    }
                    if (userId != null) {
                        user = this.roster.getUser(userId);
                        if (user == null) {
                            YahooProtocol yahooProtocol = this.getUserProtocol(protocol, userId);
                            user = new YahooUser(userId, groupName, yahooProtocol);
                        } else if (!friendAddStatus.equals("2")) {
                            log.warn((Object)("Adding friend failed and friend is in our roster: " + userId));
                        }
                    } else {
                        user = null;
                    }
                    SessionFriendFailureEvent se = new SessionFriendFailureEvent((Object)this, user, groupName, friendAddStatus);
                    this.eventDispatchQueue.append(se, ServiceType.FRIENDADD);
                }
            } else {
                log.warn((Object)("Me: " + myName + " Add buddy attempt: " + this.primaryID + ", " + userId + " problem: " + friendAddStatus + " not an ack: " + pkt.status));
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("friend added", pkt, e);
        }
    }

    protected void receiveFriendRemove(YMSG9Packet pkt) {
        String userId = null;
        String groupName = null;
        YahooUser user = null;
        try {
            if (pkt.status == 1L) {
                userId = pkt.getValue("7");
                groupName = pkt.getValue("65");
                user = this.roster.getUser(userId);
                user = new YahooUser(userId);
            } else {
                userId = pkt.getValue("7");
                groupName = pkt.getValue("65");
                user = this.roster.getUser(userId);
                if (user == null) {
                    log.info((Object)("Unable to remove a user that's not on the roster: " + userId));
                    return;
                }
            }
            SessionFriendEvent se = new SessionFriendEvent(this, user, groupName);
            this.eventDispatchQueue.append(se, ServiceType.FRIENDREMOVE);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("friend removed", pkt, e);
        }
    }

    protected void receiveGroupRename(YMSG9Packet pkt) {
        try {
            String oldName = pkt.getValue("67");
            String newName = pkt.getValue("65");
            if (oldName == null || newName == null) {
                return;
            }
            log.trace((Object)("Received a GROUPRENAME packet for group '" + oldName + "' which should be renamed to '" + newName + "'"));
            SessionGroupEvent se = new SessionGroupEvent(this, oldName, newName);
            this.eventDispatchQueue.append(se, ServiceType.GROUPRENAME);
        }
        catch (RuntimeException ex) {
            throw new YMSG9BadFormatException("group rename", pkt, ex);
        }
    }

    protected void receiveIdAct(YMSG9Packet pkt) {
    }

    protected void receiveIdDeact(YMSG9Packet pkt) {
    }

    protected void receiveStatusUpdate(YMSG9Packet pkt) {
        this.updateFriendsStatus(pkt);
    }

    protected void receiveIsAway(YMSG9Packet pkt) {
        if (pkt.exists("7")) {
            this.updateFriendsStatus(pkt);
        }
    }

    protected void receiveIsBack(YMSG9Packet pkt) {
        if (pkt.exists("7")) {
            this.updateFriendsStatus(pkt);
        }
    }

    protected void receiveStatus15(YMSG9Packet pkt) {
        this.updateFriendsStatus(pkt);
    }

    protected void receiveList(YMSG9Packet pkt) {
        String[] concatFields = new String[]{"87", "88", "89"};
        if (this.cachePacket == null) {
            this.cachePacket = pkt;
        } else {
            this.cachePacket.merge(pkt, concatFields);
        }
        if (pkt.exists("59")) {
            this._receiveList(this.cachePacket);
        }
    }

    private void _receiveList(YMSG9Packet pkt) {
        YahooUser yu;
        String userId;
        StringTokenizer st;
        String string;
        Cloneable usersOnList;
        try {
            String grps = pkt.getValue("87");
            if (grps != null) {
                usersOnList = new Hashtable();
                StringTokenizer st1 = new StringTokenizer(grps, "\n");
                while (st1.hasMoreTokens()) {
                    String s1 = st1.nextToken();
                    String groupId = s1.substring(0, s1.indexOf(":"));
                    StringTokenizer st2 = new StringTokenizer(s1.substring(s1.indexOf(":") + 1), ",");
                    while (st2.hasMoreTokens()) {
                        String userId2 = st2.nextToken();
                        YahooUser user = (YahooUser)usersOnList.get(userId2);
                        if (user == null) {
                            user = new YahooUser(userId2);
                        }
                        user.addGroupId(groupId);
                        usersOnList.put(userId2, user);
                    }
                    log.debug((Object)("add new group from list " + groupId));
                }
                if (!usersOnList.isEmpty()) {
                    HashSet<YahooUser> users = new HashSet<YahooUser>(usersOnList.values());
                    this.eventDispatchQueue.append(new SessionListEvent(this, ContactListType.Friends, users), ServiceType.LIST);
                }
            }
        }
        catch (RuntimeException ex) {
            throw new YMSG9BadFormatException("friends list in list", pkt, ex);
        }
        try {
            string = pkt.getValue("88");
            if (string != null) {
                usersOnList = new HashSet();
                st = new StringTokenizer(string, ",");
                while (st.hasMoreTokens()) {
                    userId = st.nextToken();
                    yu = new YahooUser(userId);
                    yu.setIgnored(true);
                    usersOnList.add(yu);
                }
                if (!usersOnList.isEmpty()) {
                    this.eventDispatchQueue.append(new SessionListEvent(this, ContactListType.Ignored, (Set<YahooUser>)((Object)usersOnList)), ServiceType.LIST);
                }
            }
        }
        catch (RuntimeException ex) {
            throw new YMSG9BadFormatException("ignored list in list", pkt, ex);
        }
        try {
            String s = pkt.getValue("89");
            if (s != null) {
                StringTokenizer st2 = new StringTokenizer(s, ",");
                this.identities.clear();
                while (st2.hasMoreTokens()) {
                    String id = st2.nextToken().toLowerCase();
                    this.identities.put(id, new YahooIdentity(id));
                }
            }
        }
        catch (RuntimeException ex) {
            throw new YMSG9BadFormatException("identities list in list", pkt, ex);
        }
        try {
            string = pkt.getValue("185");
            if (string != null) {
                usersOnList = new HashSet();
                st = new StringTokenizer(string, ",");
                while (st.hasMoreTokens()) {
                    userId = st.nextToken();
                    yu = new YahooUser(userId);
                    yu.setStealthBlocked(true);
                    usersOnList.add(yu);
                }
                if (!usersOnList.isEmpty()) {
                    this.eventDispatchQueue.append(new SessionListEvent(this, ContactListType.StealthBlocked, (Set<YahooUser>)((Object)usersOnList)), ServiceType.LIST);
                }
            }
        }
        catch (RuntimeException ex) {
            throw new YMSG9BadFormatException("ignored list in list", pkt, ex);
        }
        try {
            String[] ck = ConnectionHandler.extractCookies(pkt);
            this.cookieY = ck[0];
            this.cookieT = ck[1];
            this.cookieC = ck[2];
        }
        catch (RuntimeException ex) {
            throw new YMSG9BadFormatException("cookies in list", pkt, ex);
        }
        try {
            this.primaryID = pkt.exists("3") ? new YahooIdentity(pkt.getValue("3").trim()) : this.loginID;
        }
        catch (RuntimeException ex) {
            throw new YMSG9BadFormatException("primary identity in list", pkt, ex);
        }
        this.primaryID.setPrimaryIdentity(true);
        this.loginID.setLoginIdentity(true);
    }

    protected void receiveList15(YMSG9Packet pkt) {
        this.queueOfList15.add(pkt);
        if (pkt.status != 0L) {
            return;
        }
        String username = null;
        YahooProtocol protocol = YahooProtocol.YAHOO;
        YahooGroup currentListGroup = null;
        ArrayList<YahooGroup> receivedGroups = new ArrayList<YahooGroup>();
        HashSet<YahooUser> usersOnFriendsList = new HashSet<YahooUser>();
        HashSet<YahooUser> usersOnIgnoreList = new HashSet<YahooUser>();
        HashSet<YahooUser> usersOnPendingList = new HashSet<YahooUser>();
        boolean isPending = false;
        for (YMSG9Packet qPkt : this.queueOfList15) {
            for (String[] s : qPkt.entries()) {
                int key = Integer.valueOf(s[0]);
                String value = s[1];
                switch (key) {
                    case 302: {
                        if (value == null || !value.equals("320")) break;
                        currentListGroup = null;
                        break;
                    }
                    case 301: {
                        if (username == null) break;
                        YahooUser yu = null;
                        if (currentListGroup != null) {
                            for (YahooUser friend : usersOnFriendsList) {
                                if (!friend.getId().equals(username)) continue;
                                yu = friend;
                                yu.addGroupId(currentListGroup.getName());
                                if (yu.getProtocol().equals((Object)protocol) || !yu.getProtocol().equals((Object)YahooProtocol.YAHOO)) continue;
                                log.debug((Object)("Switching protocols because user is in list more that once: " + yu.getId() + " from: " + (Object)((Object)yu.getProtocol()) + " to: " + (Object)((Object)protocol)));
                                yu.update(protocol);
                            }
                            if (yu == null) {
                                yu = new YahooUser(username, currentListGroup.getName(), protocol);
                                usersOnFriendsList.add(yu);
                            }
                            currentListGroup.addUser(yu);
                        } else {
                            yu = new YahooUser(username, new HashSet<String>(), protocol);
                            yu.setIgnored(true);
                            usersOnIgnoreList.add(yu);
                        }
                        if (isPending) {
                            usersOnPendingList.add(yu);
                        }
                        username = null;
                        isPending = false;
                        protocol = YahooProtocol.YAHOO;
                        break;
                    }
                    case 223: {
                        isPending = true;
                        break;
                    }
                    case 300: {
                        break;
                    }
                    case 65: {
                        currentListGroup = new YahooGroup(value);
                        receivedGroups.add(currentListGroup);
                        break;
                    }
                    case 7: {
                        username = value;
                        break;
                    }
                    case 241: {
                        protocol = this.getUserProtocol(value, username);
                        break;
                    }
                    case 59: {
                        break;
                    }
                }
            }
            if (username == null) continue;
            YahooUser yu = null;
            if (currentListGroup != null) {
                for (YahooUser friend : usersOnFriendsList) {
                    if (!friend.getId().equals(username)) continue;
                    yu = friend;
                    yu.addGroupId(currentListGroup.getName());
                }
                if (yu == null) {
                    yu = new YahooUser(username, currentListGroup.getName(), protocol);
                    usersOnFriendsList.add(yu);
                }
                currentListGroup.addUser(yu);
            } else {
                yu = new YahooUser(username, new HashSet<String>(), protocol);
                yu.setIgnored(true);
                usersOnIgnoreList.add(yu);
            }
            if (isPending) {
                usersOnPendingList.add(yu);
            }
            username = null;
            isPending = false;
            protocol = YahooProtocol.YAHOO;
        }
        if (!usersOnFriendsList.isEmpty()) {
            this.eventDispatchQueue.append(new SessionListEvent(this, ContactListType.Friends, usersOnFriendsList), ServiceType.LIST);
        }
        if (!usersOnIgnoreList.isEmpty()) {
            this.eventDispatchQueue.append(new SessionListEvent(this, ContactListType.Ignored, usersOnIgnoreList), ServiceType.LIST);
        }
        if (!usersOnPendingList.isEmpty()) {
            this.eventDispatchQueue.append(new SessionListEvent(this, ContactListType.Pending, usersOnPendingList), ServiceType.LIST);
        }
        this.sessionStatus = SessionState.LOGGED_ON;
        log.trace((Object)"Yahoo logged in successfully");
        this.identities.put(this.loginID.getId(), new YahooIdentity(this.loginID.getId()));
        this.primaryID = this.loginID;
        this.primaryID.setPrimaryIdentity(true);
        this.loginID.setPrimaryIdentity(true);
        try {
            this.setStatus(Status.AVAILABLE);
        }
        catch (IOException e) {
            log.trace((Object)"Failed to set status to available");
        }
    }

    public void receiveLogoff(YMSG9Packet pkt) {
        block6: {
            try {
                if (!pkt.exists("7")) {
                    log.info((Object)("Logging out because I received a logoff" + this.primaryID + "/" + pkt));
                    this.sessionStatus = SessionState.UNSTARTED;
                    this.ipThread.stopMe();
                    SessionLogoutEvent logoutEvent = new SessionLogoutEvent((Object)AuthenticationState.YAHOO_LOGOFF);
                    if (pkt.status == -1L) {
                        logoutEvent = new SessionLogoutEvent((Object)AuthenticationState.DUPLICATE_LOGIN);
                    }
                    this.eventDispatchQueue.append(logoutEvent, ServiceType.LOGOFF);
                    this.closeSession();
                    break block6;
                }
                try {
                    this.updateFriendsStatus(pkt);
                }
                catch (Exception e) {
                    throw new YMSG9BadFormatException("online friends in logoff", pkt, e);
                }
            }
            catch (IOException e) {
                log.error((Object)"error in receiveLogoff", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveLogon(YMSG9Packet pkt) throws IOException {
        block6: {
            try {
                if (!pkt.exists("7")) break block6;
                try {
                    this.updateFriendsStatus(pkt);
                }
                catch (Exception e) {
                    throw new YMSG9BadFormatException("online friends in logon", pkt, e);
                }
            }
            finally {
                if (this.sessionStatus != SessionState.LOGGED_ON) {
                    this.setStatus(this.status);
                    this.sessionStatus = SessionState.LOGGED_ON;
                    this.eventDispatchQueue.append(ServiceType.LOGON);
                }
            }
        }
    }

    protected void receiveMessage(YMSG9Packet pkt) {
        try {
            if (!pkt.exists("14")) {
                return;
            }
            if (pkt.status == Status.NOTINOFFICE.getValue()) {
                int i = 0;
                while (pkt.getNthValue("31", i) != null) {
                    SessionEvent se;
                    String to = pkt.getNthValue("5", i);
                    String from = pkt.getNthValue("4", i);
                    String message = pkt.getNthValue("14", i);
                    String timestamp = pkt.getNthValue("15", i);
                    if (timestamp == null || timestamp.length() == 0) {
                        se = new SessionEvent(this, to, from, message);
                    } else {
                        long timestampInMillis = 1000L * Long.parseLong(timestamp);
                        se = new SessionEvent(this, to, from, message, timestampInMillis);
                    }
                    se.setStatus(pkt.status);
                    this.eventDispatchQueue.append(se, ServiceType.X_OFFLINE);
                    ++i;
                }
            } else {
                String to = pkt.getValue("5");
                String from = pkt.getValue("4");
                String message = pkt.getValue("14");
                String id = pkt.getValue("429");
                SessionEvent se = new SessionEvent(this, to, from, message);
                if (se.getMessage().equalsIgnoreCase("<ding>")) {
                    this.eventDispatchQueue.append(se, ServiceType.X_BUZZ);
                } else {
                    this.eventDispatchQueue.append(se, ServiceType.MESSAGE);
                }
                if (id != null) {
                    PacketBodyBuffer body = new PacketBodyBuffer();
                    body.addElement("1", this.loginID.getId());
                    body.addElement("5", from);
                    body.addElement("302", "430");
                    body.addElement("430", id);
                    body.addElement("303", "430");
                    body.addElement("450", "0");
                    this.sendPacket(body, ServiceType.MESSAGE_ACK, this.status);
                }
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("message", pkt, e);
        }
    }

    protected void receiveNewMail(YMSG9Packet pkt) {
        try {
            SessionNewMailEvent se = !pkt.exists("43") ? new SessionNewMailEvent(this, pkt.getValue("9")) : new SessionNewMailEvent(this, pkt.getValue("43"), pkt.getValue("42"), pkt.getValue("18"));
            this.eventDispatchQueue.append(se, ServiceType.NEWMAIL);
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("new mail", pkt, e);
        }
    }

    protected void receiveNotify(YMSG9Packet pkt) {
        try {
            if (pkt.status == 1L) {
                SessionNotifyEvent se = SessionNotifyEvent.createSessionNotifyEvent(this, pkt.getValue("5"), pkt.getValue("4"), pkt.getValue("14"), pkt.getValue("49"), pkt.getValue("13"));
                se.setStatus(pkt.status);
                this.eventDispatchQueue.append(se, ServiceType.NOTIFY);
            }
        }
        catch (Exception e) {
            throw new YMSG9BadFormatException("notify", pkt, e);
        }
    }

    protected void receiveUserStat(YMSG9Packet pkt) {
        try {
            this.status = Status.getStatus(pkt.status);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void erroneousChatLogin(YMSG9Packet pkt) {
        this.chatSessionStatus = SessionState.FAILED;
    }

    protected void sendPacket(PacketBodyBuffer body, ServiceType service, Status status) throws IOException {
        log.debug((Object)("Sending packet on/to the network. SessionId[0x" + Long.toHexString(this.sessionId) + "] ServiceType[" + (Object)((Object)service) + "] Status[" + (Object)((Object)status) + "] Body[" + body + "]"));
        this.network.sendPacket(body, service, status.getValue(), this.sessionId);
    }

    protected void sendPacket(PacketBodyBuffer body, ServiceType service) throws IOException {
        this.sendPacket(body, service, Status.AVAILABLE);
    }

    private boolean past(long time) {
        return System.currentTimeMillis() > time;
    }

    private void openSession(boolean createPingerTask) throws IOException {
        this.network.open();
        this.initThread();
        if (createPingerTask) {
            this.pingerTask = new SessionPinger(this);
            this.scheduledPingerService = new Timer("OpenYMSG session ping timer", true);
            this.scheduledPingerService.schedule(this.pingerTask, 60000L, 60000L);
        }
    }

    protected void initThread() {
        this.ipThread = new InputThread(this);
        this.ipThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession() throws IOException {
        log.trace((Object)"close session");
        this.sessionStatus = SessionState.UNSTARTED;
        if (this.ipThread != null && Thread.currentThread() != this.ipThread) {
            this.ipThread.stopMe();
            this.ipThread.interrupt();
            this.ipThread = null;
        }
        if (this.pingerTask != null) {
            this.pingerTask.cancel();
            this.pingerTask = null;
        }
        try {
            this.network.close();
        }
        finally {
            if (this.eventDispatchQueue != null) {
                this.eventDispatchQueue.kill();
                this.eventDispatchQueue.runEventNOW(new FireEvent(null, ServiceType.LOGOFF));
                this.eventDispatchQueue = null;
            }
        }
    }

    protected void checkStatus() throws IllegalStateException {
        if (this.sessionStatus != SessionState.LOGGED_ON) {
            throw new IllegalStateException("Not logged in");
        }
    }

    private void checkChatStatus() throws IllegalStateException {
        if (this.chatSessionStatus != SessionState.LOGGED_ON) {
            throw new IllegalStateException("Not logged in to a chatroom");
        }
    }

    private void resetData() {
        this.primaryID = null;
        this.loginID = null;
        this.password = null;
        this.cookieY = null;
        this.cookieT = null;
        this.cookieC = null;
        this.imvironment = null;
        this.customStatusMessage = null;
        this.customStatusBusy = false;
        this.conferences.clear();
        this.removeSessionListener(this.roster);
        this.roster = null;
        this.identities.clear();
        this.loginException = null;
    }

    void errorMessage(YMSG9Packet pkt, String m) {
        if (m == null) {
            m = pkt.getValue("16");
        }
        SessionErrorEvent se = new SessionErrorEvent(this, m, pkt.service);
        if (pkt.exists("114")) {
            se.setCode(Integer.parseInt(pkt.getValue("114").trim()));
        }
        this.eventDispatchQueue.append(se, ServiceType.X_ERROR);
    }

    void sendExceptionEvent(Exception e, String msg) {
        this.sessionStatus = SessionState.FAILED;
        SessionExceptionEvent se = new SessionExceptionEvent(this, msg, e);
        this.eventDispatchQueue.append(se, ServiceType.X_EXCEPTION);
    }

    private YMSG9Packet compoundChatLoginPacket(YMSG9Packet pkt) {
        if (pkt.status != 5L && pkt.status != 1L) {
            throw new IllegalArgumentException("Status must be either 1 or 5.");
        }
        if (pkt.status == 5L) {
            if (this.cachePacket == null) {
                this.cachePacket = pkt;
            } else {
                this.cachePacket.append(pkt);
            }
            return null;
        }
        if (this.cachePacket != null) {
            this.cachePacket.append(pkt);
            pkt = this.cachePacket;
            this.cachePacket = null;
        }
        return pkt;
    }

    protected void updateFriendsStatus(YMSG9Packet pkt) {
        boolean logoff = pkt.service == ServiceType.LOGOFF;
        Iterator<String[]> iter = pkt.entries().iterator();
        long longStatus = 0L;
        Boolean onChat = null;
        Boolean onPager = null;
        String visibility = null;
        String clearIdleTime = null;
        String idleTime = null;
        String customMessage = null;
        String customStatus = null;
        YahooProtocol protocol = YahooProtocol.YAHOO;
        String userId = null;
        while (iter.hasNext()) {
            String[] s = iter.next();
            int key = Integer.valueOf(s[0]);
            String value = s[1];
            switch (key) {
                case 300: {
                    break;
                }
                case 7: {
                    if (userId != null) {
                        this.updateFriendStatus(logoff, userId, onChat, onPager, visibility, clearIdleTime, idleTime, customMessage, customStatus, longStatus, protocol);
                        longStatus = 0L;
                        onChat = null;
                        onPager = null;
                        visibility = null;
                        clearIdleTime = null;
                        idleTime = null;
                        customMessage = null;
                        customStatus = null;
                        userId = null;
                        protocol = YahooProtocol.YAHOO;
                    }
                    userId = value;
                    break;
                }
                case 10: {
                    try {
                        longStatus = Long.parseLong(value);
                    }
                    catch (NumberFormatException e) {
                        customMessage = value;
                    }
                    break;
                }
                case 17: {
                    onChat = value.equals("1");
                    break;
                }
                case 13: {
                    onPager = value.equals("1");
                    visibility = value;
                    break;
                }
                case 19: {
                    customMessage = value;
                    break;
                }
                case 47: {
                    customStatus = value;
                    break;
                }
                case 138: {
                    clearIdleTime = value;
                    break;
                }
                case 241: {
                    protocol = this.getUserProtocol(value, userId);
                    break;
                }
                case 137: {
                    idleTime = value;
                    break;
                }
            }
        }
        if (userId != null) {
            this.updateFriendStatus(logoff, userId, onChat, onPager, visibility, clearIdleTime, idleTime, customMessage, customStatus, longStatus, protocol);
        }
    }

    private void updateFriendStatus(boolean logoff, String userId, Boolean onChat, Boolean onPager, String visibility, String clearIdleTime, String idleTime, String customMessage, String customStatus, long longStatus, YahooProtocol protocol) {
        log.trace((Object)("UpdateFriendStatus arguments: logoff: " + logoff + ", user: " + userId + ", onChat: " + onChat + ", onPager: " + onPager + ", visibility: " + visibility + ", clearIdleTime: " + clearIdleTime + ", idleTime: " + idleTime + ", customMessage: " + customMessage + ", customStatus: " + customStatus + ", longStatus: " + longStatus + ", protocol: " + (Object)((Object)protocol)));
        Status newStatus = Status.AVAILABLE;
        YahooUser user = this.roster.getUser(userId);
        if (user == null) {
            log.debug((Object)("Presence of a new friend seems to have arrived before the details of the new friend. Adding them now: " + userId + "/" + (Object)((Object)protocol)));
            this.roster.dispatch(new FireEvent(new SessionFriendEvent(this, new YahooUser(userId, new HashSet<String>(), protocol)), ServiceType.FRIENDADD));
            user = this.roster.getUser(userId);
        }
        if (user.getProtocol() == null || !user.getProtocol().equals((Object)protocol)) {
            log.warn((Object)("In updateFriendStatus, Protocols do not match for user: " + user.getId() + " " + (Object)((Object)user.getProtocol()) + "/" + (Object)((Object)protocol)));
        }
        if (!(longStatus != -1L || onPager != null && onPager.booleanValue())) {
            logoff = true;
        }
        try {
            newStatus = logoff ? Status.OFFLINE : Status.getStatus(longStatus);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (onChat != null) {
            user.update(newStatus, onChat, onPager);
        } else if (onPager != null) {
            user.update(newStatus, visibility);
        } else if (logoff) {
            user.update(newStatus, false, false);
        } else {
            user.update(newStatus);
        }
        if (customMessage != null) {
            user.setCustom(customMessage, customStatus);
        }
        if (clearIdleTime != null) {
            user.setIdleTime(-1L);
        }
        if (idleTime != null) {
            user.setIdleTime(Long.parseLong(idleTime));
        }
        SessionFriendEvent event = new SessionFriendEvent(this, user);
        if (this.eventDispatchQueue != null) {
            this.eventDispatchQueue.append(event, ServiceType.Y6_STATUS_UPDATE);
        }
    }

    private YahooChatUser createChatUser(YMSG9Packet pkt, int i) {
        pkt.generateQuickSetAccessors("109");
        String userId = pkt.getNthValue("109", i);
        YahooUser user = this.roster.containsUser(userId) ? this.roster.getUser(userId) : new YahooUser(userId);
        int attributes = Integer.parseInt(pkt.getValueFromNthSetQA("113", i));
        String alias = pkt.getValueFromNthSetQA("141", i);
        int age = Integer.parseInt(pkt.getValueFromNthSetQA("110", i));
        String location = pkt.getValueFromNthSetQA("142", i);
        return new YahooChatUser(user, attributes, alias, age, location);
    }

    private String getConferenceName(String yid) {
        String uuid = UUID.randomUUID().toString();
        String conferencePart = uuid.substring(0, 12) + "--";
        return yid + "-" + conferencePart;
    }

    public YahooConference getConference(String room) throws NoSuchConferenceException {
        YahooConference yc = this.conferences.get(room);
        if (yc == null) {
            throw new NoSuchConferenceException("Conference " + room + " not found.");
        }
        return yc;
    }

    YahooConference getOrCreateConference(YMSG9Packet pkt) {
        String room = pkt.getValue("57");
        String message = pkt.getValue("58");
        YahooIdentity yid = this.identities.get(pkt.getValue("1").toLowerCase());
        YahooConference yc = this.conferences.get(room);
        if (yc == null) {
            yc = new YahooConference(yid, room, message, this);
            this.conferences.put(room, yc);
        }
        return yc;
    }

    void fire(SessionEvent event, ServiceType type) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 'event' cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' cannot be null.");
        }
        this.eventDispatchQueue.append(event, type);
    }

    public long getSessionID() {
        return this.sessionId;
    }

    public void requestPicture(String friend) throws IOException {
        PacketBodyBuffer body = new PacketBodyBuffer();
        body.addElement("4", this.loginID.getId());
        body.addElement("5", friend);
        body.addElement("13", "1");
        this.sendPacket(body, ServiceType.PICTURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receivePicture(YMSG9Packet pkt) {
        String imgUrlStr = pkt.getValue("20");
        if (imgUrlStr == null) {
            return;
        }
        InputStream imgIn = null;
        try {
            int bytesRead;
            URL imgUrl = new URL(imgUrlStr);
            imgIn = imgUrl.openStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            while ((bytesRead = imgIn.read(buff)) > 0) {
                out.write(buff, 0, bytesRead);
            }
            SessionPictureEvent se = new SessionPictureEvent((Object)this, pkt.getValue("5"), pkt.getValue("4"), out.toByteArray());
            this.eventDispatchQueue.append(se, ServiceType.NOTIFY);
        }
        catch (MalformedURLException ex) {
            log.warn((Object)"Received a picture, but it appears to contain an invalid image location.", (Throwable)ex);
        }
        catch (IOException ex) {
            log.warn((Object)"Received a picture, but reading its data caused an unexpected exception.", (Throwable)ex);
        }
        finally {
            if (imgIn == null) {
                return;
            }
            try {
                imgIn.close();
            }
            catch (IOException ex) {
                log.warn((Object)"Unable to close the image stream object.", (Throwable)ex);
            }
        }
    }

    public void setSessionPictureHandler(SessionPictureHandler pictureHandler) {
        this.pictureHandler = pictureHandler;
    }

    public Roster getRoster() {
        return this.roster;
    }

    public YahooIdentity getLoginID() {
        return this.loginID;
    }

    public Collection<YahooConference> getConferences() {
        return Collections.unmodifiableCollection(this.conferences.values());
    }
}

