/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.client;

import com.hazelcast.client.TargetClientRequest;
import com.hazelcast.executor.ExecutorDataSerializerHook;
import com.hazelcast.executor.MemberCallableTaskOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.concurrent.Callable;

public final class LocalTargetCallableRequest
extends TargetClientRequest
implements IdentifiedDataSerializable {
    private String name;
    private Callable callable;

    public LocalTargetCallableRequest() {
    }

    public LocalTargetCallableRequest(String name, Callable callable) {
        this.name = name;
        this.callable = callable;
    }

    @Override
    protected Operation prepareOperation() {
        SecurityContext securityContext = this.getClientEngine().getSecurityContext();
        if (securityContext != null) {
            this.callable = securityContext.createSecureCallable(this.getEndpoint().getSubject(), this.callable);
        }
        return new MemberCallableTaskOperation(this.name, null, this.callable);
    }

    @Override
    public Address getTarget() {
        return this.getClientEngine().getThisAddress();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public int getFactoryId() {
        return ExecutorDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.callable);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.callable = (Callable)in.readObject();
    }
}

