/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ValidationUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class AbstractCompletableFuture<V>
implements ICompletableFuture<V> {
    static final Object INITIAL_STATE = new ExecutionCallbackNode(null, null, null);
    private static final AtomicReferenceFieldUpdater<AbstractCompletableFuture, Object> STATE = AtomicReferenceFieldUpdater.newUpdater(AbstractCompletableFuture.class, Object.class, "state");
    volatile Object state = INITIAL_STATE;
    private final ILogger logger;
    private final Executor defaultExecutor;

    protected AbstractCompletableFuture(NodeEngine nodeEngine, ILogger logger) {
        this(nodeEngine.getExecutionService().getExecutor("hz:async"), logger);
    }

    protected AbstractCompletableFuture(Executor defaultExecutor, ILogger logger) {
        this.defaultExecutor = defaultExecutor;
        this.logger = logger;
    }

    @Override
    public void andThen(ExecutionCallback<V> callback) {
        this.andThen(callback, this.defaultExecutor);
    }

    @Override
    public void andThen(ExecutionCallback<V> callback, Executor executor) {
        ExecutionCallbackNode newState;
        Object currentState;
        ValidationUtil.isNotNull(callback, "callback");
        ValidationUtil.isNotNull(executor, "executor");
        do {
            if (!this.isDone(currentState = this.state)) continue;
            this.runAsynchronous(callback, executor, currentState);
            return;
        } while (!STATE.compareAndSet(this, currentState, newState = new ExecutionCallbackNode(callback, executor, (ExecutionCallbackNode)currentState)));
    }

    @Override
    public boolean isDone() {
        return this.isDone(this.state);
    }

    private boolean isDone(Object state) {
        return !(state instanceof ExecutionCallbackNode);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.logger.severe("Unexpected timeout while processing " + this, e);
            return null;
        }
    }

    public void setResult(Object result) {
        Object currentState;
        do {
            if (!this.isDone(currentState = this.state)) continue;
            return;
        } while (!STATE.compareAndSet(this, currentState, result));
        this.runAsynchronous((ExecutionCallbackNode)currentState, result);
    }

    protected V getResult() {
        Object state = this.state;
        if (!this.isDone(state)) {
            return null;
        }
        if (state instanceof Throwable) {
            ExceptionUtil.sneakyThrow((Throwable)state);
        }
        return (V)state;
    }

    protected void runAsynchronous(ExecutionCallbackNode head, Object result) {
        while (head != INITIAL_STATE) {
            this.runAsynchronous(head.callback, head.executor, result);
            head = head.next;
        }
    }

    private void runAsynchronous(ExecutionCallback<V> callback, Executor executor, Object result) {
        executor.execute(new ExecutionCallbackRunnable<V>(result, callback));
    }

    private class ExecutionCallbackRunnable<V>
    implements Runnable {
        private final Object result;
        private final ExecutionCallback<V> callback;

        public ExecutionCallbackRunnable(Object result, ExecutionCallback<V> callback) {
            this.result = result;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                if (this.result instanceof Throwable) {
                    this.callback.onFailure((Throwable)this.result);
                } else {
                    this.callback.onResponse(this.result);
                }
            }
            catch (Throwable cause) {
                AbstractCompletableFuture.this.logger.severe("Failed asynchronous execution of execution callback: " + this.callback + "for call " + AbstractCompletableFuture.this, cause);
            }
        }
    }

    static final class ExecutionCallbackNode<E> {
        final ExecutionCallback<E> callback;
        final Executor executor;
        final ExecutionCallbackNode<E> next;

        private ExecutionCallbackNode(ExecutionCallback<E> callback, Executor executor, ExecutionCallbackNode<E> next) {
            this.callback = callback;
            this.executor = executor;
            this.next = next;
        }
    }
}

