/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;

public class ContainsKeyOperation
extends KeyBasedMapOperation
implements ReadonlyOperation,
WaitSupport {
    private boolean containsKey;

    public ContainsKeyOperation() {
    }

    public ContainsKeyOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    @Override
    public void run() {
        this.containsKey = this.recordStore.containsKey(this.dataKey);
    }

    @Override
    public Object getResponse() {
        return this.containsKey;
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        DefaultObjectNamespace namespace = new DefaultObjectNamespace("hz:impl:mapService", this.name);
        return new LockWaitNotifyKey(namespace, this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        if (this.recordStore.isTransactionallyLocked(this.dataKey)) {
            return !this.recordStore.canAcquireLock(this.dataKey, this.getCallerUuid(), this.getThreadId());
        }
        return false;
    }

    @Override
    public void onWaitExpire() {
        ResponseHandler responseHandler = this.getResponseHandler();
        responseHandler.sendResponse(new OperationTimeoutException("Cannot read transactionally locked entry!"));
    }

    @Override
    public String toString() {
        return "ContainsKeyOperation{}";
    }
}

