/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl.client;

import com.hazelcast.client.impl.client.TargetClientRequest;
import com.hazelcast.executor.impl.ExecutorPortableHook;
import com.hazelcast.executor.impl.operations.MemberCallableTaskOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;

public class SpecificTargetCallableRequest
extends TargetClientRequest {
    private String name;
    private String uuid;
    private Callable callable;
    private Address target;

    public SpecificTargetCallableRequest() {
    }

    public SpecificTargetCallableRequest(String name, String uuid, Callable callable, Address target) {
        this.name = name;
        this.uuid = uuid;
        this.callable = callable;
        this.target = target;
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        return this.operationService.createInvocationBuilder(this.getServiceName(), op, this.target);
    }

    @Override
    protected Operation prepareOperation() {
        SecurityContext securityContext = this.getClientEngine().getSecurityContext();
        if (securityContext != null) {
            Subject subject = this.getEndpoint().getSubject();
            this.callable = securityContext.createSecureCallable(subject, this.callable);
        }
        Object callableData = this.serializationService.toData(this.callable);
        return this.getOperation(this.name, this.uuid, (Data)callableData);
    }

    private Operation getOperation(String name, String uuid, Data callableData) {
        return new MemberCallableTaskOperation(name, uuid, callableData);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public int getFactoryId() {
        return ExecutorPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("u", this.uuid);
        ObjectDataOutput rawDataOutput = writer.getRawDataOutput();
        rawDataOutput.writeObject(this.callable);
        rawDataOutput.writeObject(this.target);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.uuid = reader.readUTF("u");
        ObjectDataInput rawDataInput = reader.getRawDataInput();
        this.callable = (Callable)rawDataInput.readObject();
        this.target = (Address)rawDataInput.readObject();
    }

    public Address getTarget() {
        return this.target;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

