/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.ClientPortableHook;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.client.ClientInitialMembershipEvent;
import com.hazelcast.cluster.client.MemberAttributeChange;
import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.instance.MemberImpl;
import java.security.Permission;
import java.util.Collection;

public final class RegisterMembershipListenerRequest
extends CallableClientRequest {
    public Object call() throws Exception {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        ClientEndpoint endpoint = this.getEndpoint();
        String registrationId = service.addMembershipListener(new MembershipListenerImpl(endpoint));
        String name = "hz:core:clusterService";
        endpoint.setListenerRegistration(name, name, registrationId);
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    private class MembershipListenerImpl
    implements InitialMembershipListener {
        private final ClientEndpoint endpoint;

        public MembershipListenerImpl(ClientEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void init(InitialMembershipEvent membershipEvent) {
            ClusterService service = (ClusterService)RegisterMembershipListenerRequest.this.getService();
            Collection<MemberImpl> memberList = service.getMemberList();
            ClientInitialMembershipEvent event = new ClientInitialMembershipEvent(memberList);
            this.endpoint.sendEvent(this.endpoint.getUuid(), event, RegisterMembershipListenerRequest.this.getCallId());
        }

        @Override
        public void memberAdded(MembershipEvent membershipEvent) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            MemberImpl member = (MemberImpl)membershipEvent.getMember();
            ClientInitialMembershipEvent event = new ClientInitialMembershipEvent((Member)member, 1);
            this.endpoint.sendEvent(this.endpoint.getUuid(), event, RegisterMembershipListenerRequest.this.getCallId());
        }

        @Override
        public void memberRemoved(MembershipEvent membershipEvent) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            MemberImpl member = (MemberImpl)membershipEvent.getMember();
            ClientInitialMembershipEvent event = new ClientInitialMembershipEvent((Member)member, 2);
            this.endpoint.sendEvent(this.endpoint.getUuid(), event, RegisterMembershipListenerRequest.this.getCallId());
        }

        @Override
        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            MemberImpl member = (MemberImpl)memberAttributeEvent.getMember();
            String uuid = member.getUuid();
            MemberAttributeOperationType op = memberAttributeEvent.getOperationType();
            String key = memberAttributeEvent.getKey();
            Object value = memberAttributeEvent.getValue();
            MemberAttributeChange memberAttributeChange = new MemberAttributeChange(uuid, op, key, value);
            ClientInitialMembershipEvent event = new ClientInitialMembershipEvent((Member)member, memberAttributeChange);
            this.endpoint.sendEvent(this.endpoint.getUuid(), event, RegisterMembershipListenerRequest.this.getCallId());
        }
    }
}

