/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEndpointManager;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.ClientEndpointManagerImpl;
import com.hazelcast.client.impl.ClientHeartbeatMonitor;
import com.hazelcast.client.impl.client.AuthenticationRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.ClientResponse;
import com.hazelcast.client.impl.operations.ClientDisconnectionOperation;
import com.hazelcast.client.impl.operations.GetConnectedClientsOperation;
import com.hazelcast.client.impl.operations.PostJoinClientOperation;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.MessageTaskFactory;
import com.hazelcast.client.impl.protocol.task.MessageTask;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.Config;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.ClientType;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.CoreService;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.util.executor.ExecutorType;
import java.security.Permission;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;

public class ClientEngineImpl
implements ClientEngine,
CoreService,
PostJoinAwareService,
ManagedService,
MembershipAwareService,
EventPublishingService<ClientEndpointImpl, ClientListener> {
    public static final String SERVICE_NAME = "hz:core:clientEngine";
    private static final int ENDPOINT_REMOVE_DELAY_SECONDS = 10;
    private static final int EXECUTOR_QUEUE_CAPACITY_PER_CORE = 100000;
    private static final int THREADS_PER_CORE = 20;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final Executor executor;
    private final SerializationService serializationService;
    private final ConcurrentMap<String, String> ownershipMappings = new ConcurrentHashMap<String, String>();
    private final ClientEndpointManagerImpl endpointManager;
    private final ILogger logger;
    private final ConnectionListener connectionListener = new ConnectionListenerImpl();
    private final MessageTaskFactory messageTaskFactory;

    public ClientEngineImpl(Node node) {
        this.logger = node.getLogger(ClientEngine.class);
        this.node = node;
        this.serializationService = node.getSerializationService();
        this.nodeEngine = node.nodeEngine;
        this.endpointManager = new ClientEndpointManagerImpl(this, this.nodeEngine);
        this.executor = this.newExecutor();
        this.messageTaskFactory = node.getNodeExtension().createMessageTaskFactory(node);
        ClientHeartbeatMonitor heartBeatMonitor = new ClientHeartbeatMonitor(this.endpointManager, this, this.nodeEngine.getExecutionService(), node.groupProperties);
        heartBeatMonitor.start();
    }

    private Executor newExecutor() {
        InternalExecutionService executionService = this.nodeEngine.getExecutionService();
        int coreSize = Runtime.getRuntime().availableProcessors();
        int threadCount = this.node.getGroupProperties().CLIENT_ENGINE_THREAD_COUNT.getInteger();
        if (threadCount <= 0) {
            threadCount = coreSize * 20;
        }
        return executionService.register("hz:client", threadCount, coreSize * 100000, ExecutorType.CONCRETE);
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public int getClientEndpointCount() {
        return this.endpointManager.size();
    }

    public void handlePacket(Packet packet) {
        int partitionId = packet.getPartitionId();
        if (partitionId < 0) {
            this.executor.execute(new ClientPacketProcessor(packet));
        } else {
            InternalOperationService operationService = this.nodeEngine.getOperationService();
            operationService.execute(new ClientPacketProcessor(packet));
        }
    }

    public void handleClientMessage(ClientMessage clientMessage, Connection connection) {
        int partitionId = clientMessage.getPartitionId();
        MessageTask messageTask = this.messageTaskFactory.create(clientMessage, connection);
        if (partitionId < 0) {
            this.executor.execute(messageTask);
        } else {
            InternalOperationService operationService = this.nodeEngine.getOperationService();
            operationService.execute(messageTask);
        }
    }

    @Override
    public InternalPartitionService getPartitionService() {
        return this.nodeEngine.getPartitionService();
    }

    @Override
    public ClusterService getClusterService() {
        return this.nodeEngine.getClusterService();
    }

    @Override
    public EventService getEventService() {
        return this.nodeEngine.getEventService();
    }

    @Override
    public ProxyService getProxyService() {
        return this.nodeEngine.getProxyService();
    }

    public void sendResponse(ClientEndpoint endpoint, Object key, Object response, int callId, boolean isError, boolean isEvent) {
        Object data = this.serializationService.toData(response);
        ClientResponse clientResponse = new ClientResponse((Data)data, callId, isError);
        Object responseData = this.serializationService.toData(clientResponse);
        int partitionId = key == null ? -1 : this.getPartitionService().getPartitionId(key);
        Packet packet = new Packet((Data)responseData, partitionId);
        if (isEvent) {
            packet.setHeader(2);
        }
        Connection conn = endpoint.getConnection();
        conn.write(packet);
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public MemberImpl getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.node.getLogger(clazz);
    }

    public ClientEndpointManager getEndpointManager() {
        return this.endpointManager;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.node.securityContext;
    }

    public void bind(ClientEndpoint endpoint) {
        Connection conn = endpoint.getConnection();
        if (conn instanceof TcpIpConnection) {
            Address address = new Address(conn.getRemoteSocketAddress());
            ((TcpIpConnection)conn).setEndPoint(address);
        }
        this.sendClientEvent(endpoint);
    }

    void sendClientEvent(ClientEndpoint endpoint) {
        InternalEventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> regs = eventService.getRegistrations(SERVICE_NAME, SERVICE_NAME);
        String uuid = endpoint.getUuid();
        eventService.publishEvent(SERVICE_NAME, regs, (Object)endpoint, uuid.hashCode());
    }

    @Override
    public void dispatchEvent(ClientEndpointImpl event, ClientListener listener) {
        if (event.isAuthenticated()) {
            listener.clientConnected(event);
        } else {
            listener.clientDisconnected(event);
        }
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        block3: {
            if (event.getMember().localMember()) {
                return;
            }
            String deadMemberUuid = event.getMember().getUuid();
            try {
                this.nodeEngine.getExecutionService().schedule(new DestroyEndpointTask(deadMemberUuid), 10L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException e) {
                if (!this.logger.isFinestEnabled()) break block3;
                this.logger.finest(e);
            }
        }
    }

    @Override
    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    public Collection<Client> getClients() {
        HashSet<Client> clients = new HashSet<Client>();
        for (ClientEndpoint endpoint : this.endpointManager.getEndpoints()) {
            clients.add((Client)((Object)endpoint));
        }
        return clients;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.node.getConnectionManager().addConnectionListener(this.connectionListener);
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        for (ClientEndpoint ce : this.endpointManager.getEndpoints()) {
            ClientEndpointImpl endpoint = (ClientEndpointImpl)ce;
            try {
                endpoint.destroy();
            }
            catch (LoginException e) {
                this.logger.finest(e.getMessage());
            }
            try {
                Connection conn = endpoint.getConnection();
                if (!conn.isAlive()) continue;
                conn.close();
            }
            catch (Exception e) {
                this.logger.finest(e);
            }
        }
        this.endpointManager.clear();
        this.ownershipMappings.clear();
    }

    public void addOwnershipMapping(String clientUuid, String ownerUuid) {
        this.ownershipMappings.put(clientUuid, ownerUuid);
    }

    public void removeOwnershipMapping(String clientUuid) {
        this.ownershipMappings.remove(clientUuid);
    }

    public TransactionManagerService getTransactionManagerService() {
        return this.node.nodeEngine.getTransactionManagerService();
    }

    private ClientDisconnectionOperation createClientDisconnectionOperation(String clientUuid) {
        ClientDisconnectionOperation op = new ClientDisconnectionOperation(clientUuid);
        op.setNodeEngine(this.nodeEngine).setServiceName(SERVICE_NAME).setService(this).setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
        return op;
    }

    @Override
    public Operation getPostJoinOperation() {
        return this.ownershipMappings.isEmpty() ? null : new PostJoinClientOperation(this.ownershipMappings);
    }

    @Override
    public Map<ClientType, Integer> getConnectedClientStats() {
        int numberOfCppClients = 0;
        int numberOfDotNetClients = 0;
        int numberOfJavaClients = 0;
        int numberOfOtherClients = 0;
        GetConnectedClientsOperation clientInfoOperation = new GetConnectedClientsOperation();
        InternalOperationService operationService = this.node.nodeEngine.getOperationService();
        HashMap<ClientType, Integer> resultMap = new HashMap<ClientType, Integer>();
        HashMap clientsMap = new HashMap();
        for (MemberImpl member : this.node.getClusterService().getMemberList()) {
            Address target = member.getAddress();
            InternalCompletableFuture future = operationService.invokeOnTarget(SERVICE_NAME, clientInfoOperation, target);
            try {
                Map endpoints = (Map)future.get();
                if (endpoints == null) continue;
                for (Map.Entry entry : endpoints.entrySet()) {
                    clientsMap.put(entry.getKey(), entry.getValue());
                }
            }
            catch (Exception e) {
                this.logger.warning("Cannot get client information from: " + target.toString(), e);
            }
        }
        block9: for (ClientType clientType : clientsMap.values()) {
            switch (clientType) {
                case JAVA: {
                    ++numberOfJavaClients;
                    continue block9;
                }
                case CSHARP: {
                    ++numberOfDotNetClients;
                    continue block9;
                }
                case CPP: {
                    ++numberOfCppClients;
                    continue block9;
                }
            }
            ++numberOfOtherClients;
        }
        resultMap.put(ClientType.CPP, numberOfCppClients);
        resultMap.put(ClientType.CSHARP, numberOfDotNetClients);
        resultMap.put(ClientType.JAVA, numberOfJavaClients);
        resultMap.put(ClientType.OTHER, numberOfOtherClients);
        return resultMap;
    }

    private class DestroyEndpointTask
    implements Runnable {
        private final String deadMemberUuid;

        public DestroyEndpointTask(String deadMemberUuid) {
            this.deadMemberUuid = deadMemberUuid;
        }

        @Override
        public void run() {
            ClientEngineImpl.this.endpointManager.removeEndpoints(this.deadMemberUuid);
            this.removeMappings();
        }

        void removeMappings() {
            Iterator iterator = ClientEngineImpl.this.ownershipMappings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String clientUuid = (String)entry.getKey();
                String memberUuid = (String)entry.getValue();
                if (!this.deadMemberUuid.equals(memberUuid)) continue;
                iterator.remove();
                ClientDisconnectionOperation op = ClientEngineImpl.this.createClientDisconnectionOperation(clientUuid);
                ClientEngineImpl.this.nodeEngine.getOperationService().runOperationOnCallingThread(op);
            }
        }
    }

    private final class ConnectionListenerImpl
    implements ConnectionListener {
        private ConnectionListenerImpl() {
        }

        @Override
        public void connectionAdded(Connection conn) {
        }

        @Override
        public void connectionRemoved(Connection connection) {
            if (connection.isClient() && ClientEngineImpl.this.nodeEngine.isActive()) {
                String ownerUuid;
                ClientEndpointImpl endpoint = (ClientEndpointImpl)ClientEngineImpl.this.endpointManager.getEndpoint(connection);
                if (endpoint == null) {
                    return;
                }
                if (!endpoint.isFirstConnection()) {
                    return;
                }
                String localMemberUuid = ClientEngineImpl.this.node.getLocalMember().getUuid();
                if (localMemberUuid.equals(ownerUuid = endpoint.getPrincipal().getOwnerUuid())) {
                    this.callDisconnectionOperation(endpoint);
                }
            }
        }

        private void callDisconnectionOperation(ClientEndpointImpl endpoint) {
            Collection<MemberImpl> memberList = ClientEngineImpl.this.nodeEngine.getClusterService().getMemberList();
            InternalOperationService operationService = ClientEngineImpl.this.nodeEngine.getOperationService();
            ClientDisconnectionOperation op = ClientEngineImpl.this.createClientDisconnectionOperation(endpoint.getUuid());
            operationService.runOperationOnCallingThread(op);
            for (MemberImpl member : memberList) {
                if (member.localMember()) continue;
                op = ClientEngineImpl.this.createClientDisconnectionOperation(endpoint.getUuid());
                operationService.send(op, member.getAddress());
            }
        }
    }

    private final class ClientPacketProcessor
    implements PartitionSpecificRunnable {
        final Packet packet;

        private ClientPacketProcessor(Packet packet) {
            this.packet = packet;
        }

        @Override
        public int getPartitionId() {
            return this.packet.getPartitionId();
        }

        @Override
        public void run() {
            Connection conn = this.packet.getConn();
            ClientEndpointImpl endpoint = (ClientEndpointImpl)ClientEngineImpl.this.endpointManager.getEndpoint(conn);
            ClientRequest request = null;
            try {
                request = this.loadRequest();
                if (request == null) {
                    this.handlePacketWithNullRequest();
                } else if (request instanceof AuthenticationRequest) {
                    if (conn.isAlive()) {
                        endpoint = new ClientEndpointImpl(ClientEngineImpl.this, conn);
                        this.processRequest(endpoint, request);
                    } else {
                        this.handleEndpointNotCreatedConnectionNotAlive();
                    }
                } else if (endpoint == null) {
                    this.handleMissingEndpoint(conn);
                } else if (endpoint.isAuthenticated()) {
                    this.processRequest(endpoint, request);
                } else {
                    this.handleAuthenticationFailure(endpoint, request);
                }
            }
            catch (Throwable e) {
                this.logProcessingFailure(request, e);
                this.handleProcessingFailure(endpoint, request, this.packet.getData(), e);
            }
        }

        private ClientRequest loadRequest() {
            Data data = this.packet.getData();
            return (ClientRequest)ClientEngineImpl.this.serializationService.toObject(data);
        }

        private void handleEndpointNotCreatedConnectionNotAlive() {
            ClientEngineImpl.this.logger.warning("Dropped: " + this.packet + " -> endpoint not created for AuthenticationRequest, " + "connection not alive");
        }

        private void handlePacketWithNullRequest() {
            ClientEngineImpl.this.logger.warning("Dropped: " + this.packet + " -> null request");
        }

        private void handleMissingEndpoint(Connection conn) {
            if (conn.isAlive()) {
                ClientEngineImpl.this.logger.severe("Dropping: " + this.packet + " -> no endpoint found for live connection.");
            } else if (ClientEngineImpl.this.logger.isFinestEnabled()) {
                ClientEngineImpl.this.logger.finest("Dropping: " + this.packet + " -> no endpoint found for dead connection.");
            }
        }

        private void logProcessingFailure(ClientRequest request, Throwable e) {
            Level level;
            Level level2 = level = ClientEngineImpl.this.nodeEngine.isActive() ? Level.SEVERE : Level.FINEST;
            if (ClientEngineImpl.this.logger.isLoggable(level)) {
                if (request == null) {
                    ClientEngineImpl.this.logger.log(level, e.getMessage(), e);
                } else {
                    ClientEngineImpl.this.logger.log(level, "While executing request: " + request + " -> " + e.getMessage(), e);
                }
            }
        }

        private void handleProcessingFailure(ClientEndpointImpl endpoint, ClientRequest request, Data data, Throwable e) {
            int callId;
            if (request != null && endpoint != null) {
                endpoint.sendResponse(e, request.getCallId());
            } else if (data != null && endpoint != null && (callId = this.extractCallId(data)) != -1) {
                endpoint.sendResponse(e, callId);
            }
        }

        private int extractCallId(Data data) {
            try {
                PortableReader portableReader = ClientEngineImpl.this.serializationService.createPortableReader(data);
                return portableReader.readInt("cId");
            }
            catch (Throwable e) {
                Level level;
                Level level2 = level = ClientEngineImpl.this.nodeEngine.isActive() ? Level.SEVERE : Level.FINEST;
                if (ClientEngineImpl.this.logger.isLoggable(level)) {
                    ClientEngineImpl.this.logger.log(level, e.getMessage(), e);
                }
                return -1;
            }
        }

        private void processRequest(ClientEndpointImpl endpoint, ClientRequest request) throws Exception {
            if (!ClientEngineImpl.this.node.joined()) {
                throw new HazelcastInstanceNotActiveException("Hazelcast instance is not ready yet!");
            }
            request.setEndpoint(endpoint);
            this.initService(request);
            request.setClientEngine(ClientEngineImpl.this);
            Credentials credentials = endpoint.getCredentials();
            request.setSerializationService(ClientEngineImpl.this.serializationService);
            request.setOperationService(ClientEngineImpl.this.nodeEngine.getOperationService());
            this.interceptBefore(credentials, request);
            this.checkPermissions(endpoint, request);
            request.process();
            this.interceptAfter(credentials, request);
        }

        private void interceptBefore(Credentials credentials, ClientRequest request) {
            SecurityContext securityContext = ClientEngineImpl.this.getSecurityContext();
            String methodName = request.getMethodName();
            if (securityContext != null && methodName != null) {
                String objectType = request.getDistributedObjectType();
                String objectName = request.getDistributedObjectName();
                securityContext.interceptBefore(credentials, objectType, objectName, methodName, request.getParameters());
            }
        }

        private void interceptAfter(Credentials credentials, ClientRequest request) {
            SecurityContext securityContext = ClientEngineImpl.this.getSecurityContext();
            String methodName = request.getMethodName();
            if (securityContext != null && methodName != null) {
                String objectType = request.getDistributedObjectType();
                String objectName = request.getDistributedObjectName();
                securityContext.interceptAfter(credentials, objectType, objectName, methodName);
            }
        }

        private void checkPermissions(ClientEndpointImpl endpoint, ClientRequest request) {
            Permission permission;
            SecurityContext securityContext = ClientEngineImpl.this.getSecurityContext();
            if (securityContext != null && (permission = request.getRequiredPermission()) != null) {
                securityContext.checkPermission(endpoint.getSubject(), permission);
            }
        }

        private void initService(ClientRequest request) {
            String serviceName = request.getServiceName();
            if (serviceName == null) {
                return;
            }
            Object service = ClientEngineImpl.this.nodeEngine.getService(serviceName);
            if (service == null) {
                if (ClientEngineImpl.this.nodeEngine.isActive()) {
                    throw new IllegalArgumentException("No service registered with name: " + serviceName);
                }
                throw new HazelcastInstanceNotActiveException();
            }
            request.setService(service);
        }

        private void handleAuthenticationFailure(ClientEndpointImpl endpoint, ClientRequest request) {
            RuntimeException exception;
            if (ClientEngineImpl.this.nodeEngine.isActive()) {
                String message = "Client " + endpoint + " must authenticate before any operation.";
                ClientEngineImpl.this.logger.severe(message);
                exception = new AuthenticationException(message);
            } else {
                exception = new HazelcastInstanceNotActiveException();
            }
            endpoint.sendResponse(exception, request.getCallId());
            ClientEngineImpl.this.endpointManager.removeEndpoint(endpoint);
        }
    }
}

