/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Logger;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.DelegatingSocket;
import org.ice4j.socket.MultiplexedSocket;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.ice4j.socket.SocketReceiveBuffer;
import org.ice4j.socket.TCPInputStream;
import org.ice4j.socket.TCPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexingSocket
extends DelegatingSocket {
    private static final Logger logger = Logger.getLogger(MultiplexingSocket.class.getName());
    private static final MultiplexedSocket[] NO_SOCKETS = new MultiplexedSocket[0];
    private final InputStream inputStream = new TCPInputStream(this);
    private boolean inReceive = false;
    private TCPOutputStream outputStream = null;
    private final List<DatagramPacket> received = new SocketReceiveBuffer(){
        private static final long serialVersionUID = 4097024214973676873L;

        public int getReceiveBufferSize() throws SocketException {
            return MultiplexingSocket.this.getReceiveBufferSize();
        }
    };
    private final Object receiveSyncRoot = new Object();
    private MultiplexedSocket[] sockets = NO_SOCKETS;
    private final Object socketsSyncRoot = new Object();
    private int soTimeout = 0;

    public MultiplexingSocket() {
        this((Socket)null);
    }

    public MultiplexingSocket(InetAddress address, int port) throws IOException {
        this((Socket)null);
    }

    public MultiplexingSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this((Socket)null);
    }

    public MultiplexingSocket(Proxy proxy) {
        this((Socket)null);
    }

    public MultiplexingSocket(Socket socket) {
        super(socket);
        try {
            this.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            logger.info("Cannot SO_TCPNODELAY");
        }
    }

    protected MultiplexingSocket(SocketImpl impl) throws SocketException {
        this((Socket)null);
    }

    public MultiplexingSocket(String host, int port) throws UnknownHostException, IOException {
        this((Socket)null);
    }

    public MultiplexingSocket(String host, int port, InetAddress localAddr, int localPort) {
        this((Socket)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(MultiplexedSocket multiplexed) {
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            int socketCount = this.sockets.length;
            for (int i = 0; i < socketCount; ++i) {
                if (!this.sockets[i].equals(multiplexed)) continue;
                if (socketCount == 1) {
                    this.sockets = NO_SOCKETS;
                    break;
                }
                MultiplexedSocket[] newSockets = new MultiplexedSocket[socketCount - 1];
                System.arraycopy(this.sockets, 0, newSockets, 0, i);
                System.arraycopy(this.sockets, i + 1, newSockets, i, newSockets.length - i);
                this.sockets = newSockets;
                break;
            }
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public InputStream getOriginalInputStream() throws IOException {
        return super.getInputStream();
    }

    public OutputStream getOriginalOutputStream() throws IOException {
        return super.getOutputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new TCPOutputStream(super.getOutputStream());
        }
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexedSocket getSocket(DatagramPacketFilter filter) throws SocketException {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            for (MultiplexedSocket socket : this.sockets) {
                if (!filter.equals(socket.getFilter())) continue;
                return socket;
            }
            MultiplexedSocket socket = new MultiplexedSocket(this, filter);
            this.sockets = MultiplexingDatagramSocket.add(this.sockets, socket);
            return socket;
        }
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        try {
            this.setOriginalInputStream(super.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.receive(this.received, p, this.soTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive(List<DatagramPacket> received, DatagramPacket p, int timeout) throws IOException {
        long startTime = System.currentTimeMillis();
        DatagramPacket r = null;
        while (true) {
            boolean wait;
            long remainingTimeout;
            long now = System.currentTimeMillis();
            List<DatagramPacket> list = received;
            synchronized (list) {
                if (!received.isEmpty() && (r = received.remove(0)) != null) {
                    break;
                }
            }
            if (timeout > 0) {
                remainingTimeout = (long)timeout - (now - startTime);
                if (remainingTimeout <= 0L) {
                    throw new SocketTimeoutException(Long.toString(remainingTimeout));
                }
            } else {
                remainingTimeout = 1000L;
            }
            Object object = this.receiveSyncRoot;
            synchronized (object) {
                if (this.inReceive) {
                    wait = true;
                } else {
                    wait = false;
                    this.inReceive = true;
                }
            }
            try {
                if (wait) {
                    object = received;
                    synchronized (object) {
                        if (received.isEmpty()) {
                            try {
                                received.wait(remainingTimeout);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            received.notifyAll();
                        }
                        continue;
                    }
                }
                DatagramPacket c = MultiplexingDatagramSocket.clone(p, false);
                super.receive(c);
                Object object2 = this.socketsSyncRoot;
                synchronized (object2) {
                    boolean accepted = false;
                    for (MultiplexedSocket socket : this.sockets) {
                        if (!socket.getFilter().accept(c)) continue;
                        List<DatagramPacket> list2 = socket.received;
                        synchronized (list2) {
                            socket.received.add(accepted ? MultiplexingDatagramSocket.clone(c, true) : c);
                            socket.received.notifyAll();
                        }
                        accepted = true;
                    }
                    if (!accepted) {
                        List<DatagramPacket> list3 = this.received;
                        synchronized (list3) {
                            this.received.add(c);
                            this.received.notifyAll();
                        }
                    }
                    continue;
                }
            }
            finally {
                object = this.receiveSyncRoot;
                synchronized (object) {
                    if (!wait) {
                        this.inReceive = false;
                    }
                }
                continue;
            }
            break;
        }
        MultiplexingDatagramSocket.copy(r, p);
    }

    void receive(MultiplexedSocket multiplexed, DatagramPacket p) throws IOException {
        try {
            this.setOriginalInputStream(super.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.receive(multiplexed.received, p, multiplexed.getSoTimeout());
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        super.setSoTimeout(timeout);
        this.soTimeout = timeout;
    }
}

