/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import net.sf.fmj.media.RegistryDefaults;
import net.sf.fmj.registry.RegistryContents;
import net.sf.fmj.registry.RegistryIOFactory;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.PlugInInfo;
import net.sf.fmj.utility.PlugInUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry {
    private static final Logger logger = LoggerSingleton.logger;
    private static final int[] REGISTRY_FORMATS = new int[]{0, 1};
    private static final int DEFAULT_REGISTRY_WRITE_FORMAT = 0;
    private static Registry registry = null;
    private static Object registryMutex = new Object();
    private final RegistryContents registryContents = new RegistryContents();
    private static final boolean READD_JAVAX = false;
    public static final int NUM_PLUGIN_TYPES = 5;
    private final boolean disableCommit;
    private static final String SYSTEM_PROPERTY_DISABLE_COMMIT = "net.sf.fmj.utility.JmfRegistry.disableCommit";
    private static final String SYSTEM_PROPERTY_DISABLE_LOAD = "net.sf.fmj.utility.JmfRegistry.disableLoad";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry getInstance() {
        Object object = registryMutex;
        synchronized (object) {
            if (null == registry) {
                registry = new Registry();
            }
            return registry;
        }
    }

    private Registry() {
        String TRUE = Boolean.TRUE.toString();
        String FALSE = Boolean.FALSE.toString();
        this.disableCommit = System.getProperty(SYSTEM_PROPERTY_DISABLE_COMMIT, FALSE).equals(TRUE);
        try {
            if (System.getProperty(SYSTEM_PROPERTY_DISABLE_LOAD, FALSE).equals(TRUE)) {
                this.setDefaults();
                return;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!this.load()) {
            logger.fine("Using registry defaults.");
            this.setDefaults();
        }
    }

    public synchronized boolean addDevice(CaptureDeviceInfo newDevice) {
        return this.registryContents.captureDeviceInfoList.add(newDevice);
    }

    public synchronized void addMimeType(String extension, String type) {
        this.registryContents.mimeTable.addMimeType(extension, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws IOException {
        if (this.disableCommit) {
            return;
        }
        boolean registryFormat = false;
        File file = this.getRegistryFile(0);
        FileOutputStream fos = new FileOutputStream(file);
        try {
            RegistryIOFactory.createRegistryIO(0, this.registryContents).write(fos);
            fos.flush();
        }
        finally {
            fos.close();
        }
        logger.info("Wrote registry file: " + file.getAbsolutePath());
    }

    public synchronized Vector<String> getContentPrefixList() {
        return (Vector)this.registryContents.contentPrefixList.clone();
    }

    public synchronized String getDefaultExtension(String mimeType) {
        return this.registryContents.mimeTable.getDefaultExtension(mimeType);
    }

    public synchronized Vector<CaptureDeviceInfo> getDeviceList() {
        return (Vector)this.registryContents.captureDeviceInfoList.clone();
    }

    public synchronized List<String> getExtensions(String mimeType) {
        return this.registryContents.mimeTable.getExtensions(mimeType);
    }

    public synchronized Hashtable<String, String> getMimeTable() {
        return this.registryContents.mimeTable.getMimeTable();
    }

    public synchronized String getMimeType(String extension) {
        return this.registryContents.mimeTable.getMimeType(extension);
    }

    public synchronized List<String> getPluginList(int pluginType) {
        Vector<String> pluginList = this.registryContents.plugins[pluginType - 1];
        return (List)pluginList.clone();
    }

    public synchronized Vector<String> getProtocolPrefixList() {
        return (Vector)this.registryContents.protocolPrefixList.clone();
    }

    private File getRegistryFile(int registryFormat) {
        String filename = System.getProperty("net.sf.fmj.utility.JmfRegistry.filename", registryFormat == 1 ? ".fmj.registry.properties" : ".fmj.registry.xml");
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.home"), filename);
        }
        return file;
    }

    private InputStream getRegistryResourceStream(int registryFormat) {
        return Registry.class.getResourceAsStream(registryFormat == 1 ? "/fmj.registry.properties" : "/fmj.registry.xml");
    }

    private synchronized boolean load() {
        for (int registryFormat : REGISTRY_FORMATS) {
            if (!this.loadFromResource(registryFormat)) continue;
            return true;
        }
        for (int registryFormat : REGISTRY_FORMATS) {
            if (!this.loadFromFile(registryFormat)) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean loadFromFile(int registryFormat) {
        try {
            File f = this.getRegistryFile(registryFormat);
            if (f.isFile() && f.length() > 0L) {
                FileInputStream fis = new FileInputStream(f);
                RegistryIOFactory.createRegistryIO(registryFormat, this.registryContents).load(fis);
                logger.info("Loaded registry from file: " + f.getAbsolutePath());
                return true;
            }
        }
        catch (Throwable t) {
            logger.warning("Problem loading registry from file: " + t.getMessage());
        }
        return false;
    }

    private synchronized boolean loadFromResource(int registryFormat) {
        try {
            InputStream is = this.getRegistryResourceStream(registryFormat);
            if (is == null) {
                return false;
            }
            RegistryIOFactory.createRegistryIO(registryFormat, this.registryContents).load(is);
            logger.info("Loaded registry from resource, format: " + (registryFormat == 1 ? "Properties" : "XML"));
            return true;
        }
        catch (Throwable t) {
            logger.warning("Problem loading registry from resource: " + t.getMessage());
            return false;
        }
    }

    public synchronized boolean removeDevice(CaptureDeviceInfo device) {
        return this.registryContents.captureDeviceInfoList.remove(device);
    }

    public synchronized boolean removeMimeType(String fileExtension) {
        return this.registryContents.mimeTable.removeMimeType(fileExtension);
    }

    public synchronized void setContentPrefixList(List<String> list) {
        this.registryContents.contentPrefixList.clear();
        this.registryContents.contentPrefixList.addAll(list);
    }

    private void setDefaults() {
        int flags = RegistryDefaults.getDefaultFlags();
        this.registryContents.protocolPrefixList.addAll(RegistryDefaults.protocolPrefixList(flags));
        this.registryContents.contentPrefixList.addAll(RegistryDefaults.contentPrefixList(flags));
        List<Object> list = RegistryDefaults.plugInList(flags);
        for (Object o : list) {
            PlugInInfo i;
            if (o instanceof PlugInInfo) {
                i = (PlugInInfo)o;
                this.registryContents.plugins[i.type - 1].add(i.className);
                continue;
            }
            i = PlugInUtility.getPlugInInfo((String)o);
            if (i == null) continue;
            this.registryContents.plugins[i.type - 1].add(i.className);
        }
    }

    public synchronized void setPluginList(int pluginType, List<String> plugins) {
        Vector<String> pluginList = this.registryContents.plugins[pluginType - 1];
        pluginList.clear();
        pluginList.addAll(plugins);
    }

    public synchronized void setProtocolPrefixList(List<String> list) {
        this.registryContents.protocolPrefixList.clear();
        this.registryContents.protocolPrefixList.addAll(list);
    }
}

