/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import javax.media.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFormat
extends Format {
    public static final int BIG_ENDIAN = 1;
    public static final int LITTLE_ENDIAN = 0;
    public static final int SIGNED = 1;
    public static final int UNSIGNED = 0;
    protected double sampleRate = -1.0;
    protected int sampleSizeInBits = -1;
    protected int channels = -1;
    protected int endian = -1;
    protected int signed = -1;
    protected double frameRate = -1.0;
    protected int frameSizeInBits = -1;
    public static final String LINEAR = "LINEAR";
    public static final String ULAW = "ULAW";
    public static final String ULAW_RTP = "ULAW/rtp";
    public static final String ALAW = "alaw";
    public static final String IMA4 = "ima4";
    public static final String IMA4_MS = "ima4/ms";
    public static final String MSADPCM = "msadpcm";
    public static final String DVI = "dvi";
    public static final String DVI_RTP = "dvi/rtp";
    public static final String G723 = "g723";
    public static final String G723_RTP = "g723/rtp";
    public static final String G728 = "g728";
    public static final String G728_RTP = "g728/rtp";
    public static final String G729 = "g729";
    public static final String G729_RTP = "g729/rtp";
    public static final String G729A = "g729a";
    public static final String G729A_RTP = "g729a/rtp";
    public static final String GSM = "gsm";
    public static final String GSM_MS = "gsm/ms";
    public static final String GSM_RTP = "gsm/rtp";
    public static final String MAC3 = "MAC3";
    public static final String MAC6 = "MAC6";
    public static final String TRUESPEECH = "truespeech";
    public static final String MSNAUDIO = "msnaudio";
    public static final String MPEGLAYER3 = "mpeglayer3";
    public static final String VOXWAREAC8 = "voxwareac8";
    public static final String VOXWAREAC10 = "voxwareac10";
    public static final String VOXWAREAC16 = "voxwareac16";
    public static final String VOXWAREAC20 = "voxwareac20";
    public static final String VOXWAREMETAVOICE = "voxwaremetavoice";
    public static final String VOXWAREMETASOUND = "voxwaremetasound";
    public static final String VOXWARERT29H = "voxwarert29h";
    public static final String VOXWAREVR12 = "voxwarevr12";
    public static final String VOXWAREVR18 = "voxwarevr18";
    public static final String VOXWARETQ40 = "voxwaretq40";
    public static final String VOXWARETQ60 = "voxwaretq60";
    public static final String MSRT24 = "msrt24";
    public static final String MPEG = "mpegaudio";
    public static final String MPEG_RTP = "mpegaudio/rtp";
    public static final String DOLBYAC3 = "dolbyac3";
    double multiplier = -1.0;
    int margin = 0;
    boolean init = false;

    public AudioFormat(String encoding) {
        super(encoding);
    }

    public AudioFormat(String encoding, double sampleRate, int sampleSizeInBits, int channels) {
        this(encoding);
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
    }

    public AudioFormat(String encoding, double sampleRate, int sampleSizeInBits, int channels, int endian, int signed) {
        this(encoding, sampleRate, sampleSizeInBits, channels);
        this.endian = endian;
        this.signed = signed;
    }

    public AudioFormat(String encoding, double sampleRate, int sampleSizeInBits, int channels, int endian, int signed, int frameSizeInBits, double frameRate, Class<?> dataType) {
        this(encoding, sampleRate, sampleSizeInBits, channels, endian, signed);
        this.frameSizeInBits = frameSizeInBits;
        this.frameRate = frameRate;
        this.dataType = dataType;
    }

    @Override
    public Object clone() {
        AudioFormat f = new AudioFormat(this.encoding);
        f.copy(this);
        return f;
    }

    public long computeDuration(long length) {
        if (this.init) {
            if (this.multiplier < 0.0) {
                return -1L;
            }
            return (long)((double)(length - (long)this.margin) * this.multiplier) * 1000L;
        }
        if (this.encoding == null) {
            this.init = true;
            return -1L;
        }
        if (this.encoding.equalsIgnoreCase(LINEAR) || this.encoding.equalsIgnoreCase(ULAW)) {
            if (this.sampleSizeInBits > 0 && this.channels > 0 && this.sampleRate > 0.0) {
                this.multiplier = (double)(8000000 / this.sampleSizeInBits / this.channels) / this.sampleRate;
            }
        } else if (this.encoding.equalsIgnoreCase(ULAW_RTP)) {
            if (this.sampleSizeInBits > 0 && this.channels > 0 && this.sampleRate > 0.0) {
                this.multiplier = (double)(8000000 / this.sampleSizeInBits / this.channels) / this.sampleRate;
            }
        } else if (this.encoding.equalsIgnoreCase(DVI_RTP)) {
            if (this.sampleSizeInBits > 0 && this.sampleRate > 0.0) {
                this.multiplier = (double)(8000000 / this.sampleSizeInBits) / this.sampleRate;
            }
            this.margin = 4;
        } else if (this.encoding.equalsIgnoreCase(GSM_RTP)) {
            if (this.sampleRate > 0.0) {
                this.multiplier = 4848484.0 / this.sampleRate;
            }
        } else if (this.encoding.equalsIgnoreCase(G723_RTP)) {
            if (this.sampleRate > 0.0) {
                this.multiplier = 1.0E7 / this.sampleRate;
            }
        } else if (this.frameSizeInBits != -1 && this.frameRate != -1.0 && this.frameSizeInBits > 0 && this.frameRate > 0.0) {
            this.multiplier = (double)(8000000 / this.frameSizeInBits) / this.frameRate;
        }
        this.init = true;
        if (this.multiplier > 0.0) {
            return (long)((double)(length - (long)this.margin) * this.multiplier) * 1000L;
        }
        return -1L;
    }

    @Override
    protected void copy(Format f) {
        super.copy(f);
        AudioFormat other = (AudioFormat)f;
        this.sampleRate = other.sampleRate;
        this.sampleSizeInBits = other.sampleSizeInBits;
        this.channels = other.channels;
        this.endian = other.endian;
        this.signed = other.signed;
        this.frameSizeInBits = other.frameSizeInBits;
        this.frameRate = other.frameRate;
    }

    @Override
    public boolean equals(Object format) {
        if (format instanceof AudioFormat) {
            AudioFormat other = (AudioFormat)format;
            return super.equals(format) && this.sampleRate == other.sampleRate && this.sampleSizeInBits == other.sampleSizeInBits && this.channels == other.channels && this.endian == other.endian && this.signed == other.signed && this.frameSizeInBits == other.frameSizeInBits && this.frameRate == other.frameRate;
        }
        return false;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getEndian() {
        return this.endian;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public int getFrameSizeInBits() {
        return this.frameSizeInBits;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public int getSigned() {
        return this.signed;
    }

    @Override
    public Format intersects(Format format) {
        Format fmt = super.intersects(format);
        if (fmt == null) {
            return null;
        }
        if (!(fmt instanceof AudioFormat)) {
            return fmt;
        }
        AudioFormat other = (AudioFormat)format;
        AudioFormat res = (AudioFormat)fmt;
        res.sampleRate = this.sampleRate != -1.0 ? this.sampleRate : other.sampleRate;
        res.sampleSizeInBits = this.sampleSizeInBits != -1 ? this.sampleSizeInBits : other.sampleSizeInBits;
        res.channels = this.channels != -1 ? this.channels : other.channels;
        res.endian = this.endian != -1 ? this.endian : other.endian;
        res.signed = this.signed != -1 ? this.signed : other.signed;
        res.frameSizeInBits = this.frameSizeInBits != -1 ? this.frameSizeInBits : other.frameSizeInBits;
        res.frameRate = this.frameRate != -1.0 ? this.frameRate : other.frameRate;
        return res;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof AudioFormat)) {
            return true;
        }
        AudioFormat other = (AudioFormat)format;
        return !(this.sampleRate != -1.0 && other.sampleRate != -1.0 && this.sampleRate != other.sampleRate || this.sampleSizeInBits != -1 && other.sampleSizeInBits != -1 && this.sampleSizeInBits != other.sampleSizeInBits || this.channels != -1 && other.channels != -1 && this.channels != other.channels || this.endian != -1 && other.endian != -1 && this.endian != other.endian || this.signed != -1 && other.signed != -1 && this.signed != other.signed || this.frameSizeInBits != -1 && other.frameSizeInBits != -1 && this.frameSizeInBits != other.frameSizeInBits || this.frameRate != -1.0 && other.frameRate != -1.0 && this.frameRate != other.frameRate);
    }

    @Override
    public String toString() {
        String strChannels = "";
        String strEndian = "";
        if (this.channels == 1) {
            strChannels = ", Mono";
        } else if (this.channels == 2) {
            strChannels = ", Stereo";
        } else if (this.channels != -1) {
            strChannels = ", " + this.channels + "-channel";
        }
        if (this.sampleSizeInBits > 8) {
            if (this.endian == 1) {
                strEndian = ", BigEndian";
            } else if (this.endian == 0) {
                strEndian = ", LittleEndian";
            }
        }
        return this.getEncoding() + (this.sampleRate != -1.0 ? ", " + this.sampleRate + " Hz" : ", Unknown Sample Rate") + (this.sampleSizeInBits != -1 ? ", " + this.sampleSizeInBits + "-bit" : "") + strChannels + strEndian + (this.signed != -1 ? (this.signed == 1 ? ", Signed" : ", Unsigned") : "") + (this.frameRate != -1.0 ? ", " + this.frameRate + " frame rate" : "") + (this.frameSizeInBits != -1 ? ", FrameSize=" + this.frameSizeInBits + " bits" : "") + (this.dataType != Format.byteArray && this.dataType != null ? ", " + this.dataType : "");
    }
}

