/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Component;
import java.io.IOException;
import java.util.Vector;
import javax.media.AudioDeviceUnavailableEvent;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DownloadProgressListener;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.ExtendedCachingControl;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaLocator;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.ResourceUnavailableEvent;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopByRequestEvent;
import javax.media.StopEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.protocol.DataSource;
import javax.media.protocol.Positionable;
import javax.media.protocol.RateConfiguration;
import javax.media.protocol.RateConfigureable;
import javax.media.protocol.RateRange;
import net.sf.fmj.media.BasicController;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.PlayThread;
import net.sf.fmj.media.SeekFailedEvent;
import net.sf.fmj.media.StatsThread;
import net.sf.fmj.media.control.SliderRegionControl;
import net.sf.fmj.media.control.SliderRegionControlAdapter;

public abstract class BasicPlayer
extends BasicController
implements Player,
ControllerListener,
DownloadProgressListener {
    protected DataSource source = null;
    protected Vector controllerList = new Vector();
    private Vector optionalControllerList = new Vector();
    private Vector removedControllerList = new Vector();
    private Vector currentControllerList = new Vector();
    private Vector potentialEventsList = null;
    private Vector receivedEventList = new Vector();
    private boolean receivedAllEvents = false;
    private Vector configureEventList = new Vector();
    private Vector realizeEventList = new Vector();
    private Vector prefetchEventList = new Vector();
    private Vector stopEventList = new Vector();
    private Controller restartFrom = null;
    private Vector eomEventsReceivedFrom = new Vector();
    private Vector stopAtTimeReceivedFrom = new Vector();
    private PlayThread playThread = null;
    private StatsThread statsThread = null;
    private Time duration = DURATION_UNKNOWN;
    private Time startTime;
    private Time mediaTimeAtStart;
    private boolean aboutToRestart = false;
    private boolean closing = false;
    private boolean prefetchFailed = false;
    protected boolean framePositioning = true;
    protected Control[] controls = null;
    protected Component controlComp = null;
    public SliderRegionControl regionControl = null;
    protected CachingControl cachingControl = null;
    protected ExtendedCachingControl extendedCachingControl = null;
    protected BufferControl bufferControl = null;
    private Object startSync = new Object();
    private Object mediaTimeSync = new Object();
    long lastTime = 0L;
    static final int LOCAL_STOP = 0;
    static final int STOP_BY_REQUEST = 1;
    static final int RESTARTING = 2;

    public BasicPlayer() {
        this.configureEventList.addElement("javax.media.ConfigureCompleteEvent");
        this.configureEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.realizeEventList.addElement("javax.media.RealizeCompleteEvent");
        this.realizeEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.prefetchEventList.addElement("javax.media.PrefetchCompleteEvent");
        this.prefetchEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.stopEventList.addElement("javax.media.StopEvent");
        this.stopEventList.addElement("javax.media.StopByRequestEvent");
        this.stopEventList.addElement("javax.media.StopAtTimeEvent");
        this.stopThreadEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void abortPrefetch() {
        if (this.controllerList != null) {
            int n = this.controllerList.size();
            while (--n >= 0) {
                Controller controller = (Controller)this.controllerList.elementAt(n);
                controller.deallocate();
            }
        }
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void abortRealize() {
        if (this.controllerList != null) {
            int n = this.controllerList.size();
            while (--n >= 0) {
                Controller controller = (Controller)this.controllerList.elementAt(n);
                controller.deallocate();
            }
        }
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    public synchronized void addController(Controller controller) throws IncompatibleTimeBaseException {
        int n = this.getState();
        if (n == 600) {
            this.throwError(new ClockStartedError("Cannot add controller to a started player"));
        }
        if (n == 100 || n == 200) {
            this.throwError(new NotRealizedError("A Controller cannot be added to an Unrealized Player"));
        }
        if (controller == null || controller == this) {
            return;
        }
        int n2 = controller.getState();
        if (n2 == 100 || n2 == 200) {
            this.throwError(new NotRealizedError("An Unrealized Controller cannot be added to a Player"));
        }
        if (this.controllerList.contains(controller)) {
            return;
        }
        if (n == 500 && (n2 == 300 || n2 == 400)) {
            this.deallocate();
        }
        this.manageController(controller);
        controller.setTimeBase(this.getTimeBase());
        controller.setMediaTime(this.getMediaTime());
        controller.setStopTime(this.getStopTime());
        if (controller.setRate(this.getRate()) != this.getRate()) {
            this.setRate(1.0f);
        }
    }

    protected abstract boolean audioEnabled();

    float checkRateConfig(RateConfigureable rateConfigureable, float f) {
        RateConfiguration[] rateConfigurationArray = rateConfigureable.getRateConfigurations();
        if (rateConfigurationArray == null) {
            return 1.0f;
        }
        float f2 = 1.0f;
        for (int i = 0; i < rateConfigurationArray.length; ++i) {
            RateRange rateRange = rateConfigurationArray[i].getRate();
            if (rateRange == null || !rateRange.inRange(f)) continue;
            rateRange.setCurrentRate(f);
            f2 = f;
            RateConfiguration rateConfiguration = rateConfigureable.setRateConfiguration(rateConfigurationArray[i]);
            if (rateConfiguration == null || (rateRange = rateConfiguration.getRate()) == null) break;
            f2 = rateRange.getCurrentRate();
            break;
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeConfigure() {
        super.completeConfigure();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completePrefetch() {
        super.completePrefetch();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeRealize() {
        this.state = 300;
        try {
            this.slaveToMasterTimeBase(this.getMasterTimeBase());
        }
        catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
            Log.error(incompatibleTimeBaseException);
        }
        super.completeRealize();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void controllerSetStopTime(Time time) {
        super.setStopTime(time);
    }

    protected void controllerStopAtTime() {
        super.stopAtTime();
    }

    public final void controllerUpdate(ControllerEvent controllerEvent) {
        this.processEvent(controllerEvent);
    }

    protected boolean deviceBusy(BasicController basicController) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        Controller controller = this;
        synchronized (controller) {
            this.closing = true;
            this.notifyAll();
        }
        if (this.getState() == 600) {
            this.stop(0);
        }
        if (this.controllerList != null) {
            while (!this.controllerList.isEmpty()) {
                controller = (Controller)this.controllerList.firstElement();
                controller.close();
                this.controllerList.removeElement(controller);
            }
        }
        this.controlComp = null;
        if (this.statsThread != null) {
            this.statsThread.kill();
        }
        this.sendEvent(new ControllerClosedEvent(this));
    }

    protected synchronized boolean doConfigure() {
        Controller controller;
        this.potentialEventsList = this.configureEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        int n = this.controllerList.size();
        while (--n >= 0) {
            controller = (Controller)this.controllerList.elementAt(n);
            if (controller.getState() != 100 || !(controller instanceof Processor) && !(controller instanceof BasicController)) continue;
            this.currentControllerList.addElement(controller);
        }
        n = this.currentControllerList.size();
        while (--n >= 0) {
            controller = (Controller)this.currentControllerList.elementAt(n);
            if (controller instanceof Processor) {
                ((Processor)controller).configure();
                continue;
            }
            if (!(controller instanceof BasicController)) continue;
            ((BasicController)controller).configure();
        }
        if (!this.currentControllerList.isEmpty()) {
            try {
                while (!this.closing && !this.receivedAllEvents) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.currentControllerList.removeAllElements();
        }
        n = this.controllerList.size();
        while (--n >= 0) {
            controller = (Controller)this.controllerList.elementAt(n);
            if (!(controller instanceof Processor) && !(controller instanceof BasicController) || controller.getState() >= 180) continue;
            Log.error("Error: Unable to configure " + controller);
            this.source.disconnect();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFailedConfigure() {
        super.doFailedConfigure();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFailedPrefetch() {
        super.doFailedPrefetch();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFailedRealize() {
        super.doFailedRealize();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doPrefetch() {
        Controller controller;
        this.potentialEventsList = this.prefetchEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        Vector vector = this.controllerList;
        if (vector == null) {
            return false;
        }
        int n = vector.size();
        while (--n >= 0) {
            controller = (Controller)vector.elementAt(n);
            if (controller.getState() != 300) continue;
            this.currentControllerList.addElement(controller);
            controller.prefetch();
        }
        if (!this.currentControllerList.isEmpty()) {
            controller = this;
            synchronized (controller) {
                try {
                    while (!this.closing && !this.receivedAllEvents) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.currentControllerList.removeAllElements();
            }
        }
        n = vector.size();
        while (--n >= 0) {
            controller = (Controller)vector.elementAt(n);
            if (controller.getState() >= 500) continue;
            Log.error("Error: Unable to prefetch " + controller + "\n");
            if (this.optionalControllerList.contains(controller)) {
                this.removedControllerList.addElement(controller);
                continue;
            }
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.prefetchFailed = true;
                this.notifyAll();
            }
            return false;
        }
        if (this.removedControllerList != null) {
            n = this.removedControllerList.size();
            while (--n >= 0) {
                controller = this.removedControllerList.elementAt(n);
                this.controllerList.removeElement(controller);
                ((BasicController)controller).close();
                if (this.deviceBusy((BasicController)controller)) continue;
                BasicPlayer basicPlayer = this;
                synchronized (basicPlayer) {
                    this.prefetchFailed = true;
                    this.notifyAll();
                }
                return false;
            }
            this.removedControllerList.removeAllElements();
        }
        return true;
    }

    protected synchronized boolean doRealize() {
        Controller controller;
        this.potentialEventsList = this.realizeEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        int n = this.controllerList.size();
        while (--n >= 0) {
            controller = (Controller)this.controllerList.elementAt(n);
            if (controller.getState() != 100 && controller.getState() != 180) continue;
            this.currentControllerList.addElement(controller);
        }
        n = this.currentControllerList.size();
        while (--n >= 0) {
            controller = (Controller)this.currentControllerList.elementAt(n);
            controller.realize();
        }
        if (!this.currentControllerList.isEmpty()) {
            try {
                while (!this.closing && !this.receivedAllEvents) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.currentControllerList.removeAllElements();
        }
        n = this.controllerList.size();
        while (--n >= 0) {
            controller = (Controller)this.controllerList.elementAt(n);
            if (controller.getState() >= 300) continue;
            Log.error("Error: Unable to realize " + controller);
            this.source.disconnect();
            return false;
        }
        this.updateDuration();
        this.statsThread = new StatsThread(this);
        this.statsThread.start();
        return true;
    }

    protected void doSetMediaTime(Time time) {
    }

    protected float doSetRate(float f) {
        return f;
    }

    private void doSetStopTime(Time time) {
        this.getClock().setStopTime(time);
        Vector vector = this.controllerList;
        int n = vector.size();
        while (--n >= 0) {
            Controller controller = (Controller)this.controllerList.elementAt(n);
            controller.setStopTime(time);
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    public void downloadUpdate() {
        int n;
        if (this.extendedCachingControl == null) {
            return;
        }
        this.sendEvent(new CachingControlEvent(this, this.cachingControl, this.cachingControl.getContentProgress()));
        if (this.regionControl == null) {
            return;
        }
        long l = this.cachingControl.getContentLength();
        if (l == -1L || l <= 0L) {
            n = 0;
        } else {
            long l2 = this.extendedCachingControl.getEndOffset();
            n = (int)(100.0 * (double)l2 / (double)l);
            if (n < 0) {
                n = 0;
            } else if (n > 100) {
                n = 100;
            }
        }
        this.regionControl.setMinValue(0L);
        this.regionControl.setMaxValue(n);
    }

    public String getContentType() {
        if (this.source != null) {
            return this.source.getContentType();
        }
        return null;
    }

    public final Vector getControllerList() {
        return this.controllerList;
    }

    public Component getControlPanelComponent() {
        int n = this.getState();
        if (n < 300) {
            this.throwError(new NotRealizedError("Cannot get control panel component on an unrealized player"));
        }
        return this.controlComp;
    }

    public Control[] getControls() {
        int n;
        if (this.controls != null) {
            return this.controls;
        }
        Vector<Control> vector = new Vector<Control>();
        if (this.cachingControl != null) {
            vector.addElement(this.cachingControl);
        }
        if (this.bufferControl != null) {
            vector.addElement(this.bufferControl);
        }
        int n2 = this.controllerList.size();
        for (n = 0; n < n2; ++n) {
            Controller controller = (Controller)this.controllerList.elementAt(n);
            Control[] controlArray = controller.getControls();
            if (controlArray == null) continue;
            for (int i = 0; i < controlArray.length; ++i) {
                vector.addElement(controlArray[i]);
            }
        }
        n2 = vector.size();
        Control[] controlArray = new Control[n2];
        for (n = 0; n < n2; ++n) {
            controlArray[n] = (Control)vector.elementAt(n);
        }
        if (this.getState() >= 300) {
            this.controls = controlArray;
        }
        return controlArray;
    }

    public Time getDuration() {
        long l = this.getMediaNanoseconds();
        if (l > this.lastTime) {
            this.lastTime = l;
            this.updateDuration();
        }
        return this.duration;
    }

    public GainControl getGainControl() {
        int n = this.getState();
        if (n >= 300) {
            return (GainControl)this.getControl("javax.media.GainControl");
        }
        this.throwError(new NotRealizedError("Cannot get gain control on an unrealized player"));
        return null;
    }

    protected abstract TimeBase getMasterTimeBase();

    public MediaLocator getMediaLocator() {
        if (this.source != null) {
            return this.source.getLocator();
        }
        return null;
    }

    private Vector getPotentialEventsList() {
        return this.potentialEventsList;
    }

    private Vector getReceivedEventsList() {
        return this.receivedEventList;
    }

    protected DataSource getSource() {
        return this.source;
    }

    public Time getStartLatency() {
        super.getStartLatency();
        long l = 0L;
        for (int i = 0; i < this.controllerList.size(); ++i) {
            Controller controller = (Controller)this.controllerList.elementAt(i);
            Time time = controller.getStartLatency();
            if (time == LATENCY_UNKNOWN || time.getNanoseconds() <= l) continue;
            l = time.getNanoseconds();
        }
        if (l == 0L) {
            return LATENCY_UNKNOWN;
        }
        return new Time(l);
    }

    public Component getVisualComponent() {
        int n = this.getState();
        if (n < 300) {
            this.throwError(new NotRealizedError("Cannot get visual component on an unrealized player"));
        }
        return null;
    }

    public boolean isAboutToRestart() {
        return this.aboutToRestart;
    }

    protected boolean isConfigurable() {
        return false;
    }

    public boolean isFramePositionable() {
        return this.framePositioning;
    }

    protected final void manageController(Controller controller) {
        this.manageController(controller, false);
    }

    protected final void manageController(Controller controller, boolean bl) {
        if (controller != null && !this.controllerList.contains(controller)) {
            this.controllerList.addElement(controller);
            if (bl) {
                this.optionalControllerList.addElement(controller);
            }
            controller.addControllerListener(this);
        }
        this.updateDuration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIfAllEventsArrived(Vector vector, Vector vector2) {
        if (vector2 != null && vector2.size() == this.currentControllerList.size()) {
            this.receivedAllEvents = true;
            this.resetReceivedEventList();
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.notifyAll();
            }
        }
    }

    final synchronized void play() {
        if (this.getTargetState() != 600) {
            return;
        }
        this.prefetchFailed = false;
        int n = this.getState();
        if (n == 100 || n == 180 || n == 300) {
            this.prefetch();
        }
        while (!(this.closing || this.prefetchFailed || this.getState() != 140 && this.getState() != 200 && this.getState() != 300 && this.getState() != 400)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.getState() != 600 && this.getTargetState() == 600 && this.getState() == 500) {
            this.syncStart(this.getTimeBase().getTime());
        }
    }

    protected final void processEndOfMedia() {
        super.stop();
        this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvent(ControllerEvent controllerEvent) {
        Controller controller;
        int n;
        int n2;
        Controller controller2 = controllerEvent.getSourceController();
        if (controllerEvent instanceof AudioDeviceUnavailableEvent) {
            this.sendEvent(new AudioDeviceUnavailableEvent(this));
            return;
        }
        if (controllerEvent instanceof ControllerClosedEvent && !this.closing && this.controllerList.contains(controller2) && !(controllerEvent instanceof ResourceUnavailableEvent)) {
            this.controllerList.removeElement(controller2);
            if (controllerEvent instanceof ControllerErrorEvent) {
                this.sendEvent(new ControllerErrorEvent(this, ((ControllerErrorEvent)controllerEvent).getMessage()));
            }
            this.close();
        }
        if (controllerEvent instanceof SizeChangeEvent && this.controllerList.contains(controller2)) {
            this.sendEvent(new SizeChangeEvent(this, ((SizeChangeEvent)controllerEvent).getWidth(), ((SizeChangeEvent)controllerEvent).getHeight(), ((SizeChangeEvent)controllerEvent).getScale()));
            return;
        }
        if (controllerEvent instanceof DurationUpdateEvent && this.controllerList.contains(controller2)) {
            this.updateDuration();
            return;
        }
        if (controllerEvent instanceof RestartingEvent && this.controllerList.contains(controller2)) {
            this.restartFrom = controller2;
            n2 = this.controllerList.size();
            super.stop();
            this.setTargetState(500);
            for (n = 0; n < n2; ++n) {
                controller = (Controller)this.controllerList.elementAt(n);
                if (controller == controller2) continue;
                controller.stop();
            }
            super.stop();
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
        }
        if (controllerEvent instanceof StartEvent && controller2 == this.restartFrom) {
            this.restartFrom = null;
            this.start();
        }
        if (controllerEvent instanceof SeekFailedEvent && this.controllerList.contains(controller2)) {
            n2 = this.controllerList.size();
            super.stop();
            this.setTargetState(500);
            for (n = 0; n < n2; ++n) {
                controller = (Controller)this.controllerList.elementAt(n);
                if (controller == controller2) continue;
                controller.stop();
            }
            this.sendEvent(new SeekFailedEvent(this, 600, 500, 500, this.getMediaTime()));
        }
        if (controllerEvent instanceof EndOfMediaEvent && this.controllerList.contains(controller2)) {
            if (this.eomEventsReceivedFrom.contains(controller2)) {
                return;
            }
            this.eomEventsReceivedFrom.addElement(controller2);
            if (this.eomEventsReceivedFrom.size() == this.controllerList.size()) {
                super.stop();
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
            }
            return;
        }
        if (controllerEvent instanceof StopAtTimeEvent && this.controllerList.contains(controller2) && this.getState() == 600) {
            Vector vector = this.stopAtTimeReceivedFrom;
            synchronized (vector) {
                if (this.stopAtTimeReceivedFrom.contains(controller2)) {
                    return;
                }
                this.stopAtTimeReceivedFrom.addElement(controller2);
                int n3 = n = this.stopAtTimeReceivedFrom.size() == this.controllerList.size() ? 1 : 0;
                if (n == 0) {
                    n = 1;
                    for (int i = 0; i < this.controllerList.size(); ++i) {
                        Controller controller3 = (Controller)this.controllerList.elementAt(i);
                        if (this.stopAtTimeReceivedFrom.contains(controller3) || this.eomEventsReceivedFrom.contains(controller3)) continue;
                        n = 0;
                        break;
                    }
                }
                if (n != 0) {
                    super.stop();
                    this.doSetStopTime(Clock.RESET);
                    this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                }
                return;
            }
        }
        if (controllerEvent instanceof CachingControlEvent && this.controllerList.contains(controller2)) {
            CachingControl cachingControl = ((CachingControlEvent)controllerEvent).getCachingControl();
            this.sendEvent(new CachingControlEvent(this, cachingControl, cachingControl.getContentProgress()));
            return;
        }
        Vector vector = this.potentialEventsList;
        if (this.controllerList != null && this.controllerList.contains(controller2) && vector != null && vector.contains(controllerEvent.getClass().getName())) {
            this.updateReceivedEventsList(controllerEvent);
            this.notifyIfAllEventsArrived(this.controllerList, this.getReceivedEventsList());
        }
    }

    public final synchronized void removeController(Controller controller) {
        int n = this.getState();
        if (n < 300) {
            this.throwError(new NotRealizedError("Cannot remove controller from a unrealized player"));
        }
        if (n == 600) {
            this.throwError(new ClockStartedError("Cannot remove controller from a started player"));
        }
        if (controller == null) {
            return;
        }
        if (this.controllerList.contains(controller)) {
            this.controllerList.removeElement(controller);
            controller.removeControllerListener(this);
            this.updateDuration();
            try {
                controller.setTimeBase(null);
            }
            catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
                // empty catch block
            }
        }
    }

    private void resetReceivedEventList() {
        if (this.receivedEventList != null) {
            this.receivedEventList.removeAllElements();
        }
    }

    protected void setMediaLength(long l) {
        this.duration = new Time(l);
        super.setMediaLength(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMediaTime(Time time) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(MediaTimeError));
        }
        Object object = this.mediaTimeSync;
        synchronized (object) {
            if (this.syncStartInProgress()) {
                return;
            }
            if (this.getState() == 600) {
                this.aboutToRestart = true;
                this.stop(2);
            }
            if (this.source instanceof Positionable) {
                time = ((Positionable)((Object)this.source)).setPosition(time, 2);
            }
            super.setMediaTime(time);
            int n = this.controllerList.size();
            while (--n >= 0) {
                ((Controller)this.controllerList.elementAt(n)).setMediaTime(time);
            }
            this.doSetMediaTime(time);
            if (this.aboutToRestart) {
                this.syncStart(this.getTimeBase().getTime());
                this.aboutToRestart = false;
            }
        }
    }

    public float setRate(float f) {
        float f2;
        float f3;
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set rate on an unrealized Player."));
        }
        if (this.source instanceof RateConfigureable) {
            f = this.checkRateConfig((RateConfigureable)((Object)this.source), f);
        }
        if ((f3 = this.getRate()) == f) {
            return f;
        }
        if (this.getState() == 600) {
            this.aboutToRestart = true;
            this.stop(2);
        }
        if (!this.trySetRate(f)) {
            if (!this.trySetRate(f3)) {
                this.trySetRate(1.0f);
                f2 = 1.0f;
            } else {
                f2 = f3;
            }
        } else {
            f2 = f;
        }
        super.setRate(f2);
        if (this.aboutToRestart) {
            this.syncStart(this.getTimeBase().getTime());
            this.aboutToRestart = false;
        }
        return f2;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        this.source = dataSource;
        try {
            this.cachingControl = (CachingControl)dataSource.getControl(CachingControl.class.getName());
            if (this.cachingControl != null && this.cachingControl instanceof ExtendedCachingControl) {
                this.extendedCachingControl = (ExtendedCachingControl)this.cachingControl;
                if (this.extendedCachingControl != null) {
                    this.regionControl = new SliderRegionControlAdapter();
                    this.extendedCachingControl.addDownloadProgressListener(this, 100);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void setStopTime(Time time) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set stop time on an unrealized controller."));
        }
        if (this.getClock().getStopTime() == null || this.getClock().getStopTime().getNanoseconds() != time.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, time));
        }
        this.doSetStopTime(time);
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        TimeBase timeBase2 = this.getMasterTimeBase();
        if (timeBase == null) {
            timeBase = timeBase2;
        }
        Controller controller = null;
        if (this.controllerList != null) {
            try {
                int n = this.controllerList.size();
                while (--n >= 0) {
                    controller = (Controller)this.controllerList.elementAt(n);
                    controller.setTimeBase(timeBase);
                }
            }
            catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
                Controller controller2;
                int n = this.controllerList.size();
                while (--n >= 0 && (controller2 = (Controller)this.controllerList.elementAt(n)) != controller) {
                    controller2.setTimeBase(timeBase2);
                }
                Log.dumpStack(incompatibleTimeBaseException);
                throw incompatibleTimeBaseException;
            }
        }
        super.setTimeBase(timeBase);
    }

    protected void slaveToMasterTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        this.setTimeBase(timeBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.startSync;
        synchronized (object) {
            if (this.restartFrom != null) {
                return;
            }
            if (this.getState() == 600) {
                this.sendEvent(new StartEvent(this, 600, 600, 600, this.mediaTimeAtStart, this.startTime));
                return;
            }
            if (this.playThread == null || !this.playThread.isAlive()) {
                this.setTargetState(600);
                this.playThread = new PlayThread(this);
                this.playThread.start();
            }
        }
    }

    public final void stop() {
        this.stop(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(int n) {
        int n2 = this.getState();
        switch (n2) {
            case 100: 
            case 300: 
            case 500: {
                this.setTargetState(n2);
                break;
            }
            case 200: {
                this.setTargetState(300);
                break;
            }
            case 400: 
            case 600: {
                this.setTargetState(500);
            }
        }
        if (this.getState() != 600) {
            switch (n) {
                case 1: {
                    this.sendEvent(new StopByRequestEvent(this, this.getState(), this.getState(), this.getTargetState(), this.getMediaTime()));
                    break;
                }
                case 2: {
                    this.sendEvent(new RestartingEvent(this, this.getState(), this.getState(), 600, this.getMediaTime()));
                    break;
                }
                default: {
                    this.sendEvent(new StopEvent(this, this.getState(), this.getState(), this.getTargetState(), this.getMediaTime()));
                    break;
                }
            }
        } else if (this.getState() == 600) {
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.potentialEventsList = this.stopEventList;
                this.resetReceivedEventList();
                this.receivedAllEvents = false;
                this.currentControllerList.removeAllElements();
                int n3 = this.controllerList.size();
                while (--n3 >= 0) {
                    Controller controller = (Controller)this.controllerList.elementAt(n3);
                    this.currentControllerList.addElement(controller);
                    controller.stop();
                }
                if (this.currentControllerList == null) {
                    return;
                }
                if (!this.currentControllerList.isEmpty()) {
                    try {
                        while (!this.closing && !this.receivedAllEvents) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.currentControllerList.removeAllElements();
                }
                super.stop();
                switch (n) {
                    case 1: {
                        this.sendEvent(new StopByRequestEvent(this, 600, this.getState(), this.getTargetState(), this.getMediaTime()));
                        break;
                    }
                    case 2: {
                        this.sendEvent(new RestartingEvent(this, 600, this.getState(), 600, this.getMediaTime()));
                        break;
                    }
                    default: {
                        this.sendEvent(new StopEvent(this, 600, this.getState(), this.getTargetState(), this.getMediaTime()));
                    }
                }
            }
        }
    }

    protected void stopAtTime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void syncStart(Time time) {
        Object object = this.mediaTimeSync;
        synchronized (object) {
            if (this.syncStartInProgress()) {
                return;
            }
            int n = this.getState();
            if (n == 600) {
                this.throwError(new ClockStartedError("syncStart() cannot be used on an already started player"));
            }
            if (n != 500) {
                this.throwError(new NotPrefetchedError("Cannot start player before it has been prefetched"));
            }
            this.eomEventsReceivedFrom.removeAllElements();
            this.stopAtTimeReceivedFrom.removeAllElements();
            this.setTargetState(600);
            int n2 = this.controllerList.size();
            while (--n2 >= 0) {
                if (this.getTargetState() != 600) continue;
                ((Controller)this.controllerList.elementAt(n2)).syncStart(time);
            }
            if (this.getTargetState() == 600) {
                this.startTime = time;
                this.mediaTimeAtStart = this.getMediaTime();
                super.syncStart(time);
            }
        }
    }

    private boolean trySetRate(float f) {
        int n = this.controllerList.size();
        while (--n >= 0) {
            Controller controller = (Controller)this.controllerList.elementAt(n);
            if (controller.setRate(f) == f) continue;
            return false;
        }
        return true;
    }

    public final void unmanageController(Controller controller) {
        if (controller != null && this.controllerList.contains(controller)) {
            this.controllerList.removeElement(controller);
            controller.removeControllerListener(this);
        }
    }

    protected synchronized void updateDuration() {
        Time time = this.duration;
        this.duration = DURATION_UNKNOWN;
        for (int i = 0; i < this.controllerList.size(); ++i) {
            Controller controller = (Controller)this.controllerList.elementAt(i);
            Time time2 = controller.getDuration();
            if (time2.equals(DURATION_UNKNOWN)) {
                if (controller instanceof BasicController) continue;
                this.duration = DURATION_UNKNOWN;
                break;
            }
            if (time2.equals(DURATION_UNBOUNDED)) {
                this.duration = DURATION_UNBOUNDED;
                break;
            }
            if (this.duration.equals(DURATION_UNKNOWN)) {
                this.duration = time2;
                continue;
            }
            if (this.duration.getNanoseconds() >= time2.getNanoseconds()) continue;
            this.duration = time2;
        }
        if (this.duration.getNanoseconds() != time.getNanoseconds()) {
            this.setMediaLength(this.duration.getNanoseconds());
            this.sendEvent(new DurationUpdateEvent(this, this.duration));
        }
    }

    private void updateReceivedEventsList(ControllerEvent controllerEvent) {
        if (this.receivedEventList != null) {
            Controller controller = controllerEvent.getSourceController();
            if (this.receivedEventList.contains(controller)) {
                return;
            }
            this.receivedEventList.addElement(controller);
        }
    }

    public abstract void updateStats();

    protected abstract boolean videoEnabled();
}

