/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Component;
import javax.media.Buffer;
import javax.media.Owned;
import javax.media.control.PacketSizeControl;
import net.sf.fmj.media.AbstractCodec;

public abstract class AbstractPacketizer
extends AbstractCodec {
    private static final boolean TRACE = false;
    private int packetSize;
    private byte[] packetBuffer;
    private int bytesInPacketBuffer = 0;
    private boolean doNotSpanInputBuffers = false;

    public AbstractPacketizer() {
        this.addControl(new PSC());
    }

    protected int doBuildPacketHeader(Buffer buffer, byte[] byArray) {
        return 0;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n;
        boolean bl;
        int n2;
        int n3;
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (this.bytesInPacketBuffer == 0) {
            n3 = this.doBuildPacketHeader(buffer, this.packetBuffer);
            this.bytesInPacketBuffer += n3;
        }
        int n4 = (n3 = this.packetSize - this.bytesInPacketBuffer) < (n2 = buffer.getLength()) ? n3 : n2;
        System.arraycopy(buffer.getData(), buffer.getOffset(), this.packetBuffer, this.bytesInPacketBuffer, n4);
        this.bytesInPacketBuffer += n4;
        buffer.setOffset(buffer.getOffset() + n4);
        buffer.setLength(buffer.getLength() - n4);
        boolean bl2 = bl = this.doNotSpanInputBuffers && buffer.getLength() == 0 || this.bytesInPacketBuffer == this.packetSize;
        if (bl) {
            buffer2.setData(this.packetBuffer);
            buffer2.setOffset(0);
            buffer2.setLength(this.bytesInPacketBuffer);
            this.bytesInPacketBuffer = 0;
            n = buffer.getLength() == 0 ? 0 : 2;
        } else {
            n = 4;
        }
        return n;
    }

    protected void setDoNotSpanInputBuffers(boolean bl) {
        this.doNotSpanInputBuffers = bl;
    }

    protected void setPacketSize(int n) {
        this.setPacketSizeImpl(n);
    }

    protected void setPacketSizeImpl(int n) {
        this.packetSize = n;
        this.packetBuffer = new byte[n];
    }

    private class PSC
    implements PacketSizeControl,
    Owned {
        private PSC() {
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return AbstractPacketizer.this;
        }

        public int getPacketSize() {
            return AbstractPacketizer.this.packetSize;
        }

        public int setPacketSize(int n) {
            AbstractPacketizer.this.setPacketSizeImpl(n);
            return AbstractPacketizer.this.packetSize;
        }
    }
}

