/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.media.codec.audio.ilbc;

import com.ibm.media.codec.audio.AudioCodec;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.java.sip.communicator.impl.media.codec.audio.Utils;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_constants;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_decoder;

public class JavaDecoder
extends AudioCodec {
    private Format lastFormat = null;
    private ilbc_decoder dec = null;

    public JavaDecoder() {
        this.inputFormats = new Format[]{new AudioFormat("ilbc/rtp", 8000.0, 16, 1, -1, -1)};
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("ilbc/rtp", 8000.0, 16, 1, -1, -1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "iLbc Decoder";
    }

    public void close() {
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, 1, 0, 1)};
        return this.supportedOutputFormats;
    }

    private void initConverter(AudioFormat audioFormat, int n) {
        this.lastFormat = audioFormat;
        if (n == ilbc_constants.NO_OF_BYTES_20MS) {
            this.dec = new ilbc_decoder(20, 1);
        } else if (n == ilbc_constants.NO_OF_BYTES_30MS) {
            this.dec = new ilbc_decoder(30, 1);
        }
    }

    public void open() {
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        byte[] byArray = (byte[])buffer.getData();
        int n = buffer.getLength();
        int n2 = buffer.getOffset();
        Format format = buffer.getFormat();
        if (this.lastFormat != format) {
            this.initConverter((AudioFormat)format, n);
        }
        if (n <= 0) {
            return 4;
        }
        short[] sArray = Utils.byteToShortArray(byArray, n2, n, false);
        short[] sArray2 = new short[this.dec.ULP_inst.blockl];
        this.dec.decode(sArray2, sArray, (short)1);
        int n3 = this.dec.ULP_inst.blockl * 2;
        byte[] byArray2 = this.validateByteArraySize(buffer2, n3);
        Utils.shortArrToByteArr(sArray2, byArray2, true);
        this.updateOutput(buffer2, this.outputFormat, n3, 0);
        return 0;
    }
}

