/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class MigrationInfo
implements DataSerializable {
    private int partitionId;
    private Address source;
    private Address destination;
    private Address master;
    private String masterUuid;
    private final AtomicBoolean processing = new AtomicBoolean(false);
    private volatile boolean valid = true;

    public MigrationInfo() {
    }

    public MigrationInfo(int partitionId, Address source, Address destination) {
        this.partitionId = partitionId;
        this.source = source;
        this.destination = destination;
    }

    public Address getSource() {
        return this.source;
    }

    public Address getDestination() {
        return this.destination;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void setMasterUuid(String uuid) {
        this.masterUuid = uuid;
    }

    public String getMasterUuid() {
        return this.masterUuid;
    }

    public Address getMaster() {
        return this.master;
    }

    public void setMaster(Address master) {
        this.master = master;
    }

    public boolean startProcessing() {
        return this.processing.compareAndSet(false, true);
    }

    public boolean isProcessing() {
        return this.processing.get();
    }

    public void doneProcessing() {
        this.processing.set(false);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.partitionId);
        boolean hasFrom = this.source != null;
        out.writeBoolean(hasFrom);
        if (hasFrom) {
            this.source.writeData(out);
        }
        this.destination.writeData(out);
        out.writeUTF(this.masterUuid);
        boolean b = this.master != null;
        out.writeBoolean(b);
        if (b) {
            this.master.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.partitionId = in.readInt();
        boolean hasFrom = in.readBoolean();
        if (hasFrom) {
            this.source = new Address();
            this.source.readData(in);
        }
        this.destination = new Address();
        this.destination.readData(in);
        this.masterUuid = in.readUTF();
        if (in.readBoolean()) {
            this.master = new Address();
            this.master.readData(in);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationInfo that = (MigrationInfo)o;
        if (this.partitionId != that.partitionId) {
            return false;
        }
        if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) {
            return false;
        }
        if (this.masterUuid != null ? !this.masterUuid.equals(that.masterUuid) : that.masterUuid != null) {
            return false;
        }
        return !(this.source != null ? !this.source.equals(that.source) : that.source != null);
    }

    public int hashCode() {
        int result = this.partitionId;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
        result = 31 * result + (this.masterUuid != null ? this.masterUuid.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "{partitionId=" + this.partitionId + ", source=" + this.source + ", destination=" + this.destination + ", master=" + this.master + ", valid=" + this.valid + ", processing=" + this.processing.get() + '}';
    }
}

