/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.tcp.PacketWriter;
import com.hazelcast.nio.tcp.SocketWriter;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import java.nio.ByteBuffer;

class SocketPacketWriter
implements SocketWriter<Packet> {
    final TcpIpConnection connection;
    final IOService ioService;
    final ILogger logger;
    private final PacketWriter packetWriter;

    SocketPacketWriter(TcpIpConnection connection) {
        this.connection = connection;
        TcpIpConnectionManager connectionManager = connection.getConnectionManager();
        this.ioService = connectionManager.ioService;
        this.logger = this.ioService.getLogger(SocketPacketWriter.class.getName());
        this.packetWriter = connectionManager.createPacketWriter(connection);
    }

    @Override
    public boolean write(Packet socketWritable, ByteBuffer socketBuffer) throws Exception {
        return this.packetWriter.writePacket(socketWritable, socketBuffer);
    }
}

