/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.AbstractDelegatingReadWriteLock;
import com.voxeo.utils.Closer;
import com.voxeo.utils.Pair;
import com.voxeo.utils.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Files {
    private static final Loggerf log = Loggerf.getLogger(Files.class);
    private static volatile Object fileLockMutex = new Object();
    private static Map<File, Pair<ReadWriteLock, Integer>> fileLocks = new ConcurrentHashMap<File, Pair<ReadWriteLock, Integer>>();

    public static Set<File> searchForFiles(File dir, String regex, boolean matchWholeFileName) {
        Pattern pattern = Pattern.compile(regex);
        HashSet<File> r = new HashSet<File>();
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(dir);
        File currentDirectory = null;
        while ((currentDirectory = (File)queue.poll()) != null) {
            for (File file : currentDirectory.listFiles()) {
                if (file.isFile()) {
                    Matcher matcher = pattern.matcher(file.getName());
                    if (matchWholeFileName) {
                        if (!matcher.matches()) continue;
                        r.add(file);
                        continue;
                    }
                    if (!matcher.find()) continue;
                    r.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                queue.add(file);
            }
        }
        return r;
    }

    public static Set<File> searchForFiles(File dir, String regex) {
        return Files.searchForFiles(dir, regex, true);
    }

    public static File searchForFile(File dir, String regex) {
        Set<File> files = Files.searchForFiles(dir, regex);
        return files.size() > 0 ? files.iterator().next() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean gzippedContentEquals(File gzipFile, String content) throws IOException {
        boolean bl;
        StringReader compareStream = null;
        try {
            compareStream = new StringReader(content);
            bl = Files.gzippedContentEquals(gzipFile, compareStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(compareStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)compareStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean gzippedContentEquals(File gzipFile, File compareToFile) throws IOException {
        boolean bl;
        FileReader compareStream = null;
        try {
            compareStream = new FileReader(compareToFile);
            bl = Files.gzippedContentEquals(gzipFile, compareStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(compareStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)compareStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean gzippedContentEquals(File gzipFile, Reader compareStream) throws IOException {
        boolean bl;
        InputStreamReader gzInputStream = null;
        try {
            gzInputStream = new InputStreamReader(new GZIPInputStream(new FileInputStream(gzipFile)));
            bl = IOUtils.contentEquals((Reader)gzInputStream, (Reader)compareStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(gzInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)gzInputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gunzipToString(URL url, String charset) throws IOException {
        String string;
        GZIPInputStream gzInputStream = null;
        try {
            gzInputStream = new GZIPInputStream(url.openStream());
            string = IOUtils.toString((InputStream)gzInputStream, (String)charset);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(gzInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)gzInputStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gunzipToByteArray(URL url) throws IOException {
        byte[] byArray;
        InputStreamReader gzInputStream = null;
        try {
            gzInputStream = new InputStreamReader(new GZIPInputStream(url.openStream()));
            byArray = IOUtils.toByteArray((Reader)gzInputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(gzInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)gzInputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock readLock(File file) {
        Object object = fileLockMutex;
        synchronized (object) {
            return new ReferenceCountingReadWriteLock(file, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock writeLock(File file) {
        Object object = fileLockMutex;
        synchronized (object) {
            return new ReferenceCountingReadWriteLock(file, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, String text) throws IOException {
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(file));
            out.print(text);
        }
        catch (Throwable throwable) {
            Closer.close(out);
            throw throwable;
        }
        Closer.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectory(File targetZipFile, File ... files) throws IOException {
        log.debug("Creating zip file %s", targetZipFile);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetZipFile)));
        try {
            for (File file : files) {
                Files.zipFile(file, out, file.getParent());
            }
        }
        finally {
            Closer.close(out);
        }
    }

    private static void zipFile(File file, ZipOutputStream ostream, String relativeToPath) throws IOException {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                Files.zipFile(child, ostream, relativeToPath);
            }
        } else {
            String path = file.getPath();
            log.debug("Adding file %s to archive", path);
            if (!Strings.isEmpty(relativeToPath) && path.startsWith(relativeToPath)) {
                path = path.substring(relativeToPath.length());
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            ZipEntry entry = new ZipEntry(path);
            ostream.putNextEntry(entry);
            Files.copyFile(file, ostream);
            ostream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, OutputStream ostream) throws IOException {
        BufferedInputStream istream = new BufferedInputStream(new FileInputStream(file));
        try {
            IOUtils.copy((InputStream)istream, (OutputStream)ostream);
        }
        finally {
            Closer.close(istream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        FileChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            destination.transferFrom(source, 0L, source.size());
        }
        catch (Throwable throwable) {
            Closer.closeAll(source, destination);
            throw throwable;
        }
        Closer.closeAll(source, destination);
    }

    public static boolean isDirEmpty(File dir) {
        File[] files = dir.listFiles();
        return files == null || files.length == 0;
    }

    public static File createTempDirectory() throws IOException {
        File result = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!result.delete()) {
            throw new IOException("Could not delete temp file: " + result.getAbsolutePath());
        }
        if (!result.mkdir()) {
            throw new IOException("Could not create temp directory: " + result.getAbsolutePath());
        }
        return result;
    }

    private static class ReferenceCountingReadWriteLock
    extends AbstractDelegatingReadWriteLock {
        private File file;
        private boolean write;

        public ReferenceCountingReadWriteLock(File file, boolean write) {
            this.file = file;
            this.write = write;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Lock notifyLock() {
            Object object = fileLockMutex;
            synchronized (object) {
                ReadWriteLock readWriteLock = null;
                if (fileLocks.containsKey(this.file)) {
                    Pair pair = (Pair)fileLocks.get(this.file);
                    Integer count = (Integer)pair.second;
                    readWriteLock = (ReadWriteLock)pair.first;
                    int newCount = count + 1;
                    fileLocks.put(this.file, new Pair<ReentrantReadWriteLock, Integer>((ReentrantReadWriteLock)readWriteLock, newCount));
                } else {
                    readWriteLock = new ReentrantReadWriteLock();
                    fileLocks.put(this.file, new Pair<ReentrantReadWriteLock, Integer>((ReentrantReadWriteLock)readWriteLock, 1));
                }
                return this.resolveLock(readWriteLock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyUnlock() {
            Object object = fileLockMutex;
            synchronized (object) {
                Pair pair = (Pair)fileLocks.get(this.file);
                Integer count = (Integer)pair.second;
                ReadWriteLock readWriteLock = (ReadWriteLock)pair.first;
                if (count == 1) {
                    log.trace("File Lock - Destroy [count=0, file=%s]", this.file.getAbsolutePath());
                    fileLocks.remove(this.file);
                } else {
                    int newCount = count - 1;
                    fileLocks.put(this.file, new Pair<ReadWriteLock, Integer>(readWriteLock, newCount));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Lock getDelegate() {
            Object object = fileLockMutex;
            synchronized (object) {
                return this.resolveLock((ReadWriteLock)((Pair)fileLocks.get((Object)this.file)).first);
            }
        }

        private Lock resolveLock(ReadWriteLock rwl) {
            if (this.write) {
                return rwl.writeLock();
            }
            return rwl.readLock();
        }
    }
}

