/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.service.neomedia.AudioMediaStream;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.event.CsrcAudioLevelListener;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.RtpChannel;

public class AudioChannel
extends RtpChannel {
    private CsrcAudioLevelListener csrcAudioLevelListener;
    private SimpleAudioLevelListener streamAudioLevelListener;

    public AudioChannel(Content content, String id, String channelBundleId, String transportNamespace, Boolean initiator) throws Exception {
        super(content, id, channelBundleId, transportNamespace, initiator);
    }

    private CsrcAudioLevelListener getCsrcAudioLevelListener() {
        if (this.csrcAudioLevelListener == null) {
            this.csrcAudioLevelListener = new CsrcAudioLevelListener(){

                public void audioLevelsReceived(long[] levels) {
                    AudioChannel.this.streamAudioLevelsReceived(levels);
                }
            };
        }
        return this.csrcAudioLevelListener;
    }

    private SimpleAudioLevelListener getStreamAudioLevelListener() {
        if (this.streamAudioLevelListener == null) {
            this.streamAudioLevelListener = new SimpleAudioLevelListener(){

                public void audioLevelChanged(int level) {
                    AudioChannel.this.streamAudioLevelChanged(level);
                }
            };
        }
        return this.streamAudioLevelListener;
    }

    protected void removeStreamListeners() {
        block6: {
            super.removeStreamListeners();
            try {
                MediaStream stream = this.getStream();
                if (stream instanceof AudioMediaStream) {
                    AudioMediaStream audioStream = (AudioMediaStream)stream;
                    CsrcAudioLevelListener csrcAudioLevelListener = this.csrcAudioLevelListener;
                    SimpleAudioLevelListener streamAudioLevelListener = this.streamAudioLevelListener;
                    if (csrcAudioLevelListener != null) {
                        audioStream.setCsrcAudioLevelListener(csrcAudioLevelListener);
                    }
                    if (streamAudioLevelListener != null) {
                        audioStream.setStreamAudioLevelListener(streamAudioLevelListener);
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!(t instanceof ThreadDeath)) break block6;
                throw (ThreadDeath)t;
            }
        }
    }

    protected void rtpLevelRelayTypeChanged(RTPLevelRelayType oldValue, RTPLevelRelayType newValue) {
        Content content;
        super.rtpLevelRelayTypeChanged(oldValue, newValue);
        if (RTPLevelRelayType.MIXER.equals((Object)newValue) && MediaType.AUDIO.equals((Object)(content = this.getContent()).getMediaType())) {
            MediaStream stream = this.getStream();
            MediaDevice device = content.getMixer();
            List rtpExtensions = device.getSupportedExtensions();
            if (rtpExtensions.size() == 1) {
                stream.addRTPExtension((byte)1, (RTPExtension)rtpExtensions.get(0));
            }
            ((AudioMediaStream)stream).setStreamAudioLevelListener(this.getStreamAudioLevelListener());
        }
    }

    private void streamAudioLevelChanged(int level) {
    }

    private void streamAudioLevelsReceived(long[] levels) {
        int[] receiveSSRCs;
        if (levels != null && (receiveSSRCs = this.getReceiveSSRCs()).length != 0) {
            int count = levels.length / 2;
            for (int i = 0; i < count; ++i) {
                ConferenceSpeechActivity conferenceSpeechActivity;
                int i2 = i * 2;
                long ssrc = levels[i2];
                boolean isReceiveSSRC = false;
                for (int receiveSSRC : receiveSSRCs) {
                    if (ssrc != (0xFFFFFFFFL & (long)receiveSSRC)) continue;
                    isReceiveSSRC = true;
                    break;
                }
                if (!isReceiveSSRC || (conferenceSpeechActivity = this.conferenceSpeechActivity) == null) continue;
                int level = (int)levels[i2 + 1];
                conferenceSpeechActivity.levelChanged(this, ssrc, level);
            }
        }
    }

    protected void addRtpHeaderExtension(RTPHdrExtPacketExtension rtpHdrExtPacketExtension) {
        MediaStream stream;
        super.addRtpHeaderExtension(rtpHdrExtPacketExtension);
        if ("urn:ietf:params:rtp-hdrext:ssrc-audio-level".equals(rtpHdrExtPacketExtension.getURI().toString()) && (stream = this.getStream()) != null && stream instanceof AudioMediaStream) {
            ((AudioMediaStream)stream).setCsrcAudioLevelListener(this.getCsrcAudioLevelListener());
        }
    }
}

