/*
 * Decompiled with CFR 0.152.
 */
package org.rubycoder.gsm;

import org.rubycoder.gsm.InvalidGSMFrameException;

public final class GSMDecoder {
    private static final byte GSM_MAGIC = 13;
    private static final int[] FAC = new int[]{18431, 20479, 22527, 24575, 26623, 28671, 30719, Short.MAX_VALUE};
    private static final int[] QLB = new int[]{3277, 11469, 21299, Short.MAX_VALUE};
    private static final int MIN_WORD = Short.MIN_VALUE;
    private static final int MAX_WORD = Short.MAX_VALUE;
    private final int[] dp0 = new int[280];
    private final int[][] LARpp = new int[2][8];
    private int j;
    private int nrp;
    private final int[] v = new int[9];
    private int msr;

    private static int add(int n, int n2) {
        int n3 = n + n2;
        return GSMDecoder.saturate(n3);
    }

    private static int asl(int n, int n2) {
        if (n2 >= 16) {
            return 0;
        }
        if (n2 <= -16) {
            return n < 0 ? -1 : 0;
        }
        if (n2 < 0) {
            return GSMDecoder.asr(n, -n2);
        }
        return n << n2;
    }

    private static int asr(int n, int n2) {
        if (n2 >= 16) {
            return n < 0 ? -1 : 0;
        }
        if (n2 <= -16) {
            return 0;
        }
        if (n2 < 0) {
            return n << -n2;
        }
        return n >> n2;
    }

    private static void Coefficients_0_12(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < 8; ++i) {
            nArray3[i] = GSMDecoder.add(nArray[i] >> 2, nArray2[i] >> 2);
            nArray3[i] = GSMDecoder.add(nArray3[i], nArray[i] >> 1);
        }
    }

    private static void Coefficients_13_26(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < 8; ++i) {
            nArray3[i] = GSMDecoder.add(nArray[i] >> 1, nArray2[i] >> 1);
        }
    }

    private static void Coefficients_27_39(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < 8; ++i) {
            nArray3[i] = GSMDecoder.add(nArray[i] >> 2, nArray2[i] >> 2);
            nArray3[i] = GSMDecoder.add(nArray3[i], nArray2[i] >> 1);
        }
    }

    private static void Coefficients_40_159(int[] nArray, int[] nArray2) {
        for (int i = 0; i < 8; ++i) {
            nArray2[i] = nArray[i];
        }
    }

    private static void decodingOfTheCodedLogAreaRatios(int[] nArray, int[] nArray2) {
        int n = GSMDecoder.add(nArray[0], -32) << 10;
        n = GSMDecoder.mult_r(13107, n);
        nArray2[0] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[1], -32) << 10;
        n = GSMDecoder.mult_r(13107, n);
        nArray2[1] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[2], -16) << 10;
        n = GSMDecoder.sub(n, 4096);
        n = GSMDecoder.mult_r(13107, n);
        nArray2[2] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[3], -16) << 10;
        n = GSMDecoder.sub(n, -5120);
        n = GSMDecoder.mult_r(13107, n);
        nArray2[3] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[4], -8) << 10;
        n = GSMDecoder.sub(n, 188);
        n = GSMDecoder.mult_r(19223, n);
        nArray2[4] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[5], -8) << 10;
        n = GSMDecoder.sub(n, -3584);
        n = GSMDecoder.mult_r(17476, n);
        nArray2[5] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[6], -4) << 10;
        n = GSMDecoder.sub(n, -682);
        n = GSMDecoder.mult_r(31454, n);
        nArray2[6] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[7], -4) << 10;
        n = GSMDecoder.sub(n, -2288);
        n = GSMDecoder.mult_r(29708, n);
        nArray2[7] = GSMDecoder.add(n, n);
    }

    private static void LARp_to_rp(int[] nArray) {
        for (int i = 0; i < 8; ++i) {
            int n;
            if (nArray[i] < 0) {
                int n2 = n = nArray[i] == Short.MIN_VALUE ? Short.MAX_VALUE : -nArray[i];
                nArray[i] = -(n < 11059 ? n << 1 : (n < 20070 ? n + 11059 : GSMDecoder.add(n >> 2, 26112)));
                continue;
            }
            n = nArray[i];
            nArray[i] = n < 11059 ? n << 1 : (n < 20070 ? n + 11059 : GSMDecoder.add(n >> 2, 26112));
        }
    }

    private static int mult_r(int n, int n2) {
        if (n2 == Short.MIN_VALUE && n == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        int n3 = n * n2 + 16384;
        return GSMDecoder.saturate(n3 >> 15);
    }

    public static void print(String string, int[] nArray) {
        System.out.print("[" + string + ":");
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print("" + nArray[i]);
            if (i < nArray.length - 1) {
                System.out.print(",");
                continue;
            }
            System.out.println("]");
        }
    }

    public static void print(String string, int n) {
        System.out.println("[" + string + ":" + n + "]");
    }

    private static void RPE_grid_positioning(int n, int[] nArray, int[] nArray2) {
        int n2 = 13;
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 3: {
                nArray2[n3++] = 0;
            }
            case 2: {
                nArray2[n3++] = 0;
            }
            case 1: {
                nArray2[n3++] = 0;
            }
            case 0: {
                nArray2[n3++] = nArray[n4++];
                --n2;
            }
        }
        do {
            nArray2[n3++] = 0;
            nArray2[n3++] = 0;
            nArray2[n3++] = nArray[n4++];
        } while (--n2 > 0);
        while (++n < 4) {
            nArray2[n3++] = 0;
        }
    }

    private static int saturate(int n) {
        return n < Short.MIN_VALUE ? Short.MIN_VALUE : (n > Short.MAX_VALUE ? Short.MAX_VALUE : n);
    }

    private static int sub(int n, int n2) {
        int n3 = n - n2;
        return GSMDecoder.saturate(n3);
    }

    private void APCMInverseQuantization(int[] nArray, int n, int n2, int n3, int[] nArray2) {
        int n4 = FAC[n3];
        int n5 = GSMDecoder.sub(6, n2);
        int n6 = GSMDecoder.asl(1, GSMDecoder.sub(n5, 1));
        int n7 = 0;
        int n8 = 13;
        while (n8-- > 0) {
            int n9 = (nArray[n++] << 1) - 7;
            n9 <<= 12;
            n9 = GSMDecoder.mult_r(n4, n9);
            n9 = GSMDecoder.add(n9, n6);
            nArray2[n7++] = GSMDecoder.asr(n9, n5);
        }
    }

    public final int[] decode(byte[] byArray) throws InvalidGSMFrameException {
        int[] nArray = new int[160];
        this.decode(byArray, nArray);
        return nArray;
    }

    public final void decode(byte[] byArray, int[] nArray) throws InvalidGSMFrameException {
        if (byArray.length != 33) {
            throw new InvalidGSMFrameException();
        }
        int n = 0;
        if ((byArray[n] >> 4 & 0xF) != 13) {
            throw new InvalidGSMFrameException();
        }
        int[] nArray2 = new int[8];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        int[] nArray5 = new int[4];
        int[] nArray6 = new int[4];
        int[] nArray7 = new int[52];
        nArray2[0] = (byArray[n++] & 0xF) << 2;
        nArray2[0] = nArray2[0] | byArray[n] >> 6 & 3;
        nArray2[1] = byArray[n++] & 0x3F;
        nArray2[2] = byArray[n] >> 3 & 0x1F;
        nArray2[3] = (byArray[n++] & 7) << 2;
        nArray2[3] = nArray2[3] | byArray[n] >> 6 & 3;
        nArray2[4] = byArray[n] >> 2 & 0xF;
        nArray2[5] = (byArray[n++] & 3) << 2;
        nArray2[5] = nArray2[5] | byArray[n] >> 6 & 3;
        nArray2[6] = byArray[n] >> 3 & 7;
        nArray2[7] = byArray[n++] & 7;
        nArray3[0] = byArray[n] >> 1 & 0x7F;
        nArray5[0] = (byArray[n++] & 1) << 1;
        nArray5[0] = nArray5[0] | byArray[n] >> 7 & 1;
        nArray4[0] = byArray[n] >> 5 & 3;
        nArray6[0] = (byArray[n++] & 0x1F) << 1;
        nArray6[0] = nArray6[0] | byArray[n] >> 7 & 1;
        nArray7[0] = byArray[n] >> 4 & 7;
        nArray7[1] = byArray[n] >> 1 & 7;
        nArray7[2] = (byArray[n++] & 1) << 2;
        nArray7[2] = nArray7[2] | byArray[n] >> 6 & 3;
        nArray7[3] = byArray[n] >> 3 & 7;
        nArray7[4] = byArray[n++] & 7;
        nArray7[5] = byArray[n] >> 5 & 7;
        nArray7[6] = byArray[n] >> 2 & 7;
        nArray7[7] = (byArray[n++] & 3) << 1;
        nArray7[7] = nArray7[7] | byArray[n] >> 7 & 1;
        nArray7[8] = byArray[n] >> 4 & 7;
        nArray7[9] = byArray[n] >> 1 & 7;
        nArray7[10] = (byArray[n++] & 1) << 2;
        nArray7[10] = nArray7[10] | byArray[n] >> 6 & 3;
        nArray7[11] = byArray[n] >> 3 & 7;
        nArray7[12] = byArray[n++] & 7;
        nArray3[1] = byArray[n] >> 1 & 0x7F;
        nArray5[1] = (byArray[n++] & 1) << 1;
        nArray5[1] = nArray5[1] | byArray[n] >> 7 & 1;
        nArray4[1] = byArray[n] >> 5 & 3;
        nArray6[1] = (byArray[n++] & 0x1F) << 1;
        nArray6[1] = nArray6[1] | byArray[n] >> 7 & 1;
        nArray7[13] = byArray[n] >> 4 & 7;
        nArray7[14] = byArray[n] >> 1 & 7;
        nArray7[15] = (byArray[n++] & 1) << 2;
        nArray7[15] = nArray7[15] | byArray[n] >> 6 & 3;
        nArray7[16] = byArray[n] >> 3 & 7;
        nArray7[17] = byArray[n++] & 7;
        nArray7[18] = byArray[n] >> 5 & 7;
        nArray7[19] = byArray[n] >> 2 & 7;
        nArray7[20] = (byArray[n++] & 3) << 1;
        nArray7[20] = nArray7[20] | byArray[n] >> 7 & 1;
        nArray7[21] = byArray[n] >> 4 & 7;
        nArray7[22] = byArray[n] >> 1 & 7;
        nArray7[23] = (byArray[n++] & 1) << 2;
        nArray7[23] = nArray7[23] | byArray[n] >> 6 & 3;
        nArray7[24] = byArray[n] >> 3 & 7;
        nArray7[25] = byArray[n++] & 7;
        nArray3[2] = byArray[n] >> 1 & 0x7F;
        nArray5[2] = (byArray[n++] & 1) << 1;
        nArray5[2] = nArray5[2] | byArray[n] >> 7 & 1;
        nArray4[2] = byArray[n] >> 5 & 3;
        nArray6[2] = (byArray[n++] & 0x1F) << 1;
        nArray6[2] = nArray6[2] | byArray[n] >> 7 & 1;
        nArray7[26] = byArray[n] >> 4 & 7;
        nArray7[27] = byArray[n] >> 1 & 7;
        nArray7[28] = (byArray[n++] & 1) << 2;
        nArray7[28] = nArray7[28] | byArray[n] >> 6 & 3;
        nArray7[29] = byArray[n] >> 3 & 7;
        nArray7[30] = byArray[n++] & 7;
        nArray7[31] = byArray[n] >> 5 & 7;
        nArray7[32] = byArray[n] >> 2 & 7;
        nArray7[33] = (byArray[n++] & 3) << 1;
        nArray7[33] = nArray7[33] | byArray[n] >> 7 & 1;
        nArray7[34] = byArray[n] >> 4 & 7;
        nArray7[35] = byArray[n] >> 1 & 7;
        nArray7[36] = (byArray[n++] & 1) << 2;
        nArray7[36] = nArray7[36] | byArray[n] >> 6 & 3;
        nArray7[37] = byArray[n] >> 3 & 7;
        nArray7[38] = byArray[n++] & 7;
        nArray3[3] = byArray[n] >> 1 & 0x7F;
        nArray5[3] = (byArray[n++] & 1) << 1;
        nArray5[3] = nArray5[3] | byArray[n] >> 7 & 1;
        nArray4[3] = byArray[n] >> 5 & 3;
        nArray6[3] = (byArray[n++] & 0x1F) << 1;
        nArray6[3] = nArray6[3] | byArray[n] >> 7 & 1;
        nArray7[39] = byArray[n] >> 4 & 7;
        nArray7[40] = byArray[n] >> 1 & 7;
        nArray7[41] = (byArray[n++] & 1) << 2;
        nArray7[41] = nArray7[41] | byArray[n] >> 6 & 3;
        nArray7[42] = byArray[n] >> 3 & 7;
        nArray7[43] = byArray[n++] & 7;
        nArray7[44] = byArray[n] >> 5 & 7;
        nArray7[45] = byArray[n] >> 2 & 7;
        nArray7[46] = (byArray[n++] & 3) << 1;
        nArray7[46] = nArray7[46] | byArray[n] >> 7 & 1;
        nArray7[47] = byArray[n] >> 4 & 7;
        nArray7[48] = byArray[n] >> 1 & 7;
        nArray7[49] = (byArray[n++] & 1) << 2;
        nArray7[49] = nArray7[49] | byArray[n] >> 6 & 3;
        nArray7[50] = byArray[n] >> 3 & 7;
        nArray7[51] = byArray[n] & 7;
        this.decoder(nArray2, nArray3, nArray5, nArray4, nArray6, nArray7, nArray);
    }

    private void decoder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7) {
        int[] nArray8 = new int[40];
        int[] nArray9 = new int[160];
        for (int i = 0; i < 4; ++i) {
            this.RPEDecoding(nArray5[i], nArray4[i], nArray6, i * 13, nArray8);
            this.longTermSynthesisFiltering(nArray2[i], nArray3[i], nArray8, this.dp0);
            for (int j = 0; j < 40; ++j) {
                nArray9[i * 40 + j] = this.dp0[120 + j];
            }
        }
        this.shortTermSynthesisFilter(nArray, nArray9, nArray7);
        this.postprocessing(nArray7);
    }

    public void GSM() {
        this.nrp = 40;
    }

    private void longTermSynthesisFiltering(int n, int n2, int[] nArray, int[] nArray2) {
        int n3;
        int n4;
        this.nrp = n4 = n < 40 || n > 120 ? this.nrp : n;
        int n5 = QLB[n2];
        for (n3 = 0; n3 <= 39; ++n3) {
            int n6 = GSMDecoder.mult_r(n5, nArray2[120 + (n3 - n4)]);
            nArray2[120 + n3] = GSMDecoder.add(nArray[n3], n6);
        }
        for (n3 = 0; n3 <= 119; ++n3) {
            nArray2[n3] = nArray2[40 + n3];
        }
    }

    private void postprocessing(int[] nArray) {
        int n = 0;
        int n2 = 160;
        while (n2-- > 0) {
            int n3 = GSMDecoder.mult_r(this.msr, 28180);
            this.msr = GSMDecoder.add(nArray[n], n3);
            nArray[n] = GSMDecoder.saturate(GSMDecoder.add(this.msr, this.msr) & 0xFFFFFFF8);
            ++n;
        }
    }

    private void RPEDecoding(int n, int n2, int[] nArray, int n3, int[] nArray2) {
        int[] nArray3 = new int[13];
        int[] nArray4 = this.xmaxcToExpAndMant(n);
        this.APCMInverseQuantization(nArray, n3, nArray4[0], nArray4[1], nArray3);
        GSMDecoder.RPE_grid_positioning(n2, nArray3, nArray2);
    }

    private void shortTermSynthesisFilter(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = this.LARpp[this.j];
        int[] nArray5 = this.LARpp[this.j ^= 1];
        int[] nArray6 = new int[8];
        GSMDecoder.decodingOfTheCodedLogAreaRatios(nArray, nArray4);
        GSMDecoder.Coefficients_0_12(nArray5, nArray4, nArray6);
        GSMDecoder.LARp_to_rp(nArray6);
        this.shortTermSynthesisFiltering(nArray6, 13, nArray2, nArray3, 0);
        GSMDecoder.Coefficients_13_26(nArray5, nArray4, nArray6);
        GSMDecoder.LARp_to_rp(nArray6);
        this.shortTermSynthesisFiltering(nArray6, 14, nArray2, nArray3, 13);
        GSMDecoder.Coefficients_27_39(nArray5, nArray4, nArray6);
        GSMDecoder.LARp_to_rp(nArray6);
        this.shortTermSynthesisFiltering(nArray6, 13, nArray2, nArray3, 27);
        GSMDecoder.Coefficients_40_159(nArray4, nArray6);
        GSMDecoder.LARp_to_rp(nArray6);
        this.shortTermSynthesisFiltering(nArray6, 120, nArray2, nArray3, 40);
    }

    private void shortTermSynthesisFiltering(int[] nArray, int n, int[] nArray2, int[] nArray3, int n2) {
        int n3 = n2;
        int n4 = n2;
        while (n-- > 0) {
            int n5 = nArray2[n3++];
            int n6 = 8;
            while (n6-- > 0) {
                int n7 = nArray[n6];
                int n8 = this.v[n6];
                n8 = n7 == Short.MIN_VALUE && n8 == Short.MIN_VALUE ? Short.MAX_VALUE : GSMDecoder.saturate(n7 * n8 + 16384 >> 15);
                n5 = GSMDecoder.sub(n5, n8);
                n7 = n7 == Short.MIN_VALUE && n5 == Short.MIN_VALUE ? Short.MAX_VALUE : GSMDecoder.saturate(n7 * n5 + 16384 >> 15);
                this.v[n6 + 1] = GSMDecoder.add(this.v[n6], n7);
            }
            nArray3[n4++] = this.v[0] = n5;
        }
    }

    private int[] xmaxcToExpAndMant(int n) {
        int n2;
        int n3 = 0;
        if (n > 15) {
            n3 = (n >> 3) - 1;
        }
        if ((n2 = n - (n3 << 3)) == 0) {
            n3 = -4;
            n2 = 7;
        } else {
            while (n2 <= 7) {
                n2 = n2 << 1 | 1;
                --n3;
            }
            n2 -= 8;
        }
        int[] nArray = new int[]{n3, n2};
        return nArray;
    }
}

