/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.swing.DefaultComboBoxModel;
import net.sf.fmj.ui.wizard.WizardPanelDescriptor;
import net.sf.fmj.ui.wizards.ChooseSourcePanelDescriptor;
import net.sf.fmj.ui.wizards.ContentAndTrackFormatPanel;
import net.sf.fmj.ui.wizards.ContentDescriptorFilter;
import net.sf.fmj.ui.wizards.ProcessorWizardConfig;
import net.sf.fmj.ui.wizards.ProcessorWizardResult;
import net.sf.fmj.ui.wizards.TrackConfig;
import net.sf.fmj.ui.wizards.WizardStepException;
import net.sf.fmj.utility.LoggerSingleton;

public class ContentAndTrackFormatPanelDescriptor
extends WizardPanelDescriptor {
    private static final Logger logger = LoggerSingleton.logger;
    public static final String IDENTIFIER = ContentAndTrackFormatPanelDescriptor.class.getName();
    private final ContentAndTrackFormatPanel panel = new ContentAndTrackFormatPanel();
    private final ProcessorWizardConfig config;
    private final ProcessorWizardResult result;
    private final Object nextPanelDescriptor;
    private final ContentDescriptorFilter contentDescriptorFilter;
    private TrackConfig[] trackConfigs;

    public ContentAndTrackFormatPanelDescriptor(Object object, ContentDescriptorFilter contentDescriptorFilter, ProcessorWizardConfig processorWizardConfig, ProcessorWizardResult processorWizardResult) {
        this.setPanelDescriptorIdentifier(IDENTIFIER);
        this.setPanelComponent(this.panel);
        this.config = processorWizardConfig;
        this.result = processorWizardResult;
        this.nextPanelDescriptor = object;
        this.contentDescriptorFilter = contentDescriptorFilter;
    }

    public boolean aboutToDisplayPanel(Object object) {
        if (object == this.getBackPanelDescriptor()) {
            int n;
            ContentDescriptor[] contentDescriptorArray = this.result.processor.getSupportedContentDescriptors();
            if (contentDescriptorArray.length == 0) {
                this.showError("Processor supports no content descriptors");
                return false;
            }
            if ((contentDescriptorArray = this.compatible(contentDescriptorArray)).length == 0) {
                this.showError("Processor supports no compatible content descriptors");
                return false;
            }
            this.getContentAndTrackFormatPanel().getComboFormat().setModel(new DefaultComboBoxModel<ContentDescriptor>(contentDescriptorArray));
            int n2 = 0;
            if (this.config.contentDescriptor != null) {
                for (int i = 0; i < contentDescriptorArray.length; ++i) {
                    if (!this.config.contentDescriptor.equals(contentDescriptorArray[i])) continue;
                    n2 = i;
                    break;
                }
            }
            this.config.contentDescriptor = contentDescriptorArray[n2];
            this.getContentAndTrackFormatPanel().getComboFormat().setSelectedItem(this.config.contentDescriptor);
            try {
                this.result.step2_setContentDescriptor(this.config);
            }
            catch (WizardStepException wizardStepException) {
                this.showError(wizardStepException);
                return false;
            }
            TrackControl[] trackControlArray = this.result.processor.getTrackControls();
            if (trackControlArray == null || trackControlArray.length < 1) {
                this.showError("No tracks available");
                return false;
            }
            this.trackConfigs = new TrackConfig[trackControlArray.length];
            for (n = 0; n < this.trackConfigs.length; ++n) {
                this.trackConfigs[n] = new TrackConfig();
            }
            for (n = 0; n < trackControlArray.length; ++n) {
                int n3;
                Format[] formatArray = trackControlArray[n].getSupportedFormats();
                if (formatArray == null) {
                    logger.warning("No supported formats (formats=null) for track " + n);
                    this.trackConfigs[n].enabled = false;
                    this.trackConfigs[n].format = null;
                    continue;
                }
                if (formatArray.length == 0) {
                    logger.warning("No supported formats (formats.length=0) for track " + n);
                    this.trackConfigs[n].enabled = false;
                    this.trackConfigs[n].format = null;
                    continue;
                }
                for (n3 = 0; n3 < formatArray.length; ++n3) {
                    logger.info("Available track format: " + formatArray[n3]);
                }
                this.getContentAndTrackFormatPanel().getAudioFormatPanel().getComboAudioEncoding().setModel(new DefaultComboBoxModel<String>(new String[]{"ULAW/rtp"}));
                this.getContentAndTrackFormatPanel().getAudioFormatPanel().getComboAudioSampleRate().setModel(new DefaultComboBoxModel<String>(new String[]{"8000"}));
                if (this.config.trackConfigs != null && this.config.trackConfigs.length >= n + 1 && this.config.trackConfigs[n].format instanceof AudioFormat) {
                    this.trackConfigs[n].format = this.config.trackConfigs[n].format;
                    this.trackConfigs[n].enabled = this.config.trackConfigs[n].enabled;
                } else {
                    this.trackConfigs[n].format = new AudioFormat("ULAW/rtp", 8000.0, 8, 1, 0, 1);
                    this.trackConfigs[n].enabled = trackControlArray[n].isEnabled();
                }
                n3 = 0;
                for (int i = 0; i < formatArray.length; ++i) {
                    logger.fine("Track " + n + " supports format " + formatArray[i]);
                    if (!formatArray[i].matches(this.trackConfigs[n].format)) continue;
                    this.getContentAndTrackFormatPanel().addTrack(n, this.trackConfigs[n].enabled, (AudioFormat)this.trackConfigs[n].format);
                    n3 = 1;
                    break;
                }
                if (n3 != 0) continue;
                this.trackConfigs[n].enabled = false;
                this.trackConfigs[n].format = null;
            }
        }
        return true;
    }

    public boolean aboutToHidePanel(Object object) {
        if (object == this.getNextPanelDescriptor()) {
            for (int i = 0; i < this.trackConfigs.length; ++i) {
                this.trackConfigs[i].enabled = this.getContentAndTrackFormatPanel().getTrackControlPanel(i).getCheckBoxEnableTrack().isSelected();
                if (!this.trackConfigs[i].enabled) continue;
                this.trackConfigs[i].format = this.getContentAndTrackFormatPanel().getTrackControlPanel(i).getAudioFormatPanel().getAudioFormat();
            }
            try {
                this.config.trackConfigs = this.trackConfigs;
                this.result.step3_setTrackConfigs(this.config);
            }
            catch (WizardStepException wizardStepException) {
                this.showError(wizardStepException);
                return false;
            }
            return true;
        }
        return super.aboutToHidePanel(object);
    }

    private ContentDescriptor[] compatible(ContentDescriptor[] contentDescriptorArray) {
        ArrayList<ContentDescriptor> arrayList = new ArrayList<ContentDescriptor>();
        for (int i = 0; i < contentDescriptorArray.length; ++i) {
            if (!this.isCompatible(contentDescriptorArray[i])) continue;
            arrayList.add(contentDescriptorArray[i]);
        }
        ContentDescriptor[] contentDescriptorArray2 = new ContentDescriptor[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            contentDescriptorArray2[i] = (ContentDescriptor)arrayList.get(i);
        }
        return contentDescriptorArray2;
    }

    public Object getBackPanelDescriptor() {
        return ChooseSourcePanelDescriptor.IDENTIFIER;
    }

    public ContentAndTrackFormatPanel getContentAndTrackFormatPanel() {
        return (ContentAndTrackFormatPanel)this.getPanelComponent();
    }

    public Object getNextPanelDescriptor() {
        return this.nextPanelDescriptor;
    }

    private boolean isCompatible(ContentDescriptor contentDescriptor) {
        return this.contentDescriptorFilter.isCompatible(contentDescriptor);
    }
}

