/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import net.sf.fmj.media.rtp.SynchSource;
import net.sf.fmj.media.rtp.util.SSRCTable;

public class StreamSynch {
    private static SSRCTable<SynchSource> sources;

    public StreamSynch() {
        if (sources == null) {
            sources = new SSRCTable();
        }
    }

    public long calcTimestamp(int n, int n2, long l) {
        long l2 = -1L;
        SynchSource synchSource = sources.get(n);
        if (synchSource != null) {
            long l3 = 1L;
            if (n2 >= 0 && n2 <= 5) {
                l3 = 8000L;
            } else if (n2 == 5) {
                l3 = 8000L;
            } else if (n2 == 6) {
                l3 = 16000L;
            } else if (n2 >= 7 && n2 <= 9) {
                l3 = 8000L;
            } else if (n2 >= 10 && n2 <= 11) {
                l3 = 44100L;
            } else if (n2 == 14) {
                l3 = 90000L;
            } else if (n2 == 15) {
                l3 = 8000L;
            } else if (n2 == 16) {
                l3 = 11025L;
            } else if (n2 == 17) {
                l3 = 22050L;
            } else if (n2 >= 25 && n2 <= 26) {
                l3 = 90000L;
            } else if (n2 == 28) {
                l3 = 90000L;
            } else if (n2 >= 31 && n2 <= 34) {
                l3 = 90000L;
            } else if (n2 == 42) {
                l3 = 90000L;
            }
            l2 = synchSource.ntpTimestamp + (l - synchSource.rtpTimestamp) * 1000L * 1000L * 1000L / l3;
        }
        return l2;
    }

    public void remove(int n) {
        if (sources != null) {
            sources.remove(n);
        }
    }

    public void update(int n, long l, long l2, long l3) {
        double d = (double)l3 / 4.294967296E9;
        long l4 = l2 * 1000000000L + (long)(d * 1.0E9);
        SynchSource synchSource = sources.get(n);
        if (synchSource == null) {
            sources.put(n, new SynchSource(n, l, l4));
        } else {
            synchSource.factor = (l - synchSource.rtpTimestamp) * (l4 - synchSource.ntpTimestamp);
            synchSource.rtpTimestamp = l;
            synchSource.ntpTimestamp = l4;
        }
    }
}

