/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.res;

import com.lti.utils.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceCloneable;
import net.sf.fmj.media.MimeManager;
import net.sf.fmj.utility.LoggerSingleton;

public class DataSource
extends PullDataSource
implements SourceCloneable {
    private static final Logger logger = LoggerSingleton.logger;
    private InputStream inputStream;
    private ContentDescriptor contentType;
    private boolean connected = false;
    private ResSourceStream[] sources;

    private static String getContentTypeFor(String string) {
        String string2 = PathUtils.extractExtension(string);
        String string3 = MimeManager.getMimeType(string2);
        if (string3 != null) {
            return string3;
        }
        string3 = URLConnection.getFileNameMap().getContentTypeFor(string);
        return string3;
    }

    public void connect() throws IOException {
        String string = this.getLocator().getRemainder();
        this.inputStream = DataSource.class.getResourceAsStream(string);
        String string2 = DataSource.getContentTypeFor(string);
        if (string2 == null) {
            throw new IOException("Unknown content type for path: " + string);
        }
        this.contentType = new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(string2));
        this.sources = new ResSourceStream[1];
        this.sources[0] = new ResSourceStream();
        this.connected = true;
    }

    public javax.media.protocol.DataSource createClone() {
        DataSource dataSource = new DataSource();
        dataSource.setLocator(this.getLocator());
        if (this.connected) {
            try {
                dataSource.connect();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                return null;
            }
        }
        return dataSource;
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
            }
        }
        this.connected = false;
    }

    public String getContentType() {
        if (!this.connected) {
            throw new Error("Source is unconnected.");
        }
        String string = this.getLocator().getRemainder();
        String string2 = DataSource.getContentTypeFor(string);
        return ContentDescriptor.mimeTypeToPackageName(string2);
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Time getDuration() {
        return Time.TIME_UNKNOWN;
    }

    public PullSourceStream[] getStreams() {
        if (!this.connected) {
            throw new Error("Unconnected source.");
        }
        return this.sources;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    private String stripTrailer(String string) {
        int n = string.indexOf(";");
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    class ResSourceStream
    implements PullSourceStream {
        private boolean endOfStream = false;

        ResSourceStream() {
        }

        public boolean endOfStream() {
            return this.endOfStream;
        }

        public ContentDescriptor getContentDescriptor() {
            return DataSource.this.contentType;
        }

        public long getContentLength() {
            return -1L;
        }

        public Object getControl(String string) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = DataSource.this.inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                this.endOfStream = true;
            }
            return n3;
        }

        public boolean willReadBlock() {
            try {
                return DataSource.this.inputStream.available() <= 0;
            }
            catch (IOException iOException) {
                return true;
            }
        }
    }
}

