/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import com.lti.utils.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import net.sf.fmj.media.multiplexer.AbstractInputStreamMux;
import net.sf.fmj.utility.FormatArgUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class XmlMovieMux
extends AbstractInputStreamMux {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean headerWritten = false;
    private boolean trailerWritten = false;

    public XmlMovieMux() {
        super(new ContentDescriptor("video.xml"));
    }

    public void close() {
        if (!this.trailerWritten) {
            try {
                this.outputTrailer(this.getOutputStream());
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                throw new RuntimeException(iOException);
            }
            this.trailerWritten = true;
        }
        super.close();
    }

    protected void doProcess(Buffer buffer, int n, OutputStream outputStream) throws IOException {
        if (!this.headerWritten) {
            this.outputHeader(outputStream);
            this.headerWritten = true;
        }
        if (buffer.isEOM()) {
            if (!this.trailerWritten) {
                this.outputTrailer(outputStream);
                this.trailerWritten = true;
            }
            outputStream.close();
            return;
        }
        if (buffer.isDiscard()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<Buffer");
        stringBuilder.append(" track=\"" + n + "\"");
        if (buffer.getSequenceNumber() != 0x7FFFFFFFFFFFFFFEL) {
            stringBuilder.append(" sequenceNumber=\"" + buffer.getSequenceNumber() + "\"");
        }
        stringBuilder.append(" timeStamp=\"" + buffer.getTimeStamp() + "\"");
        if (buffer.getDuration() >= 0L) {
            stringBuilder.append(" duration=\"" + buffer.getDuration() + "\"");
        }
        if (buffer.getFlags() != 0) {
            stringBuilder.append(" flags=\"" + Integer.toHexString(buffer.getFlags()) + "\"");
        }
        if (buffer.getFormat() != null && !buffer.getFormat().equals(this.inputFormats[n])) {
            stringBuilder.append(" format=\"" + StringUtils.replaceSpecialXMLChars(FormatArgUtils.toString(buffer.getFormat())) + "\"");
        }
        stringBuilder.append(">");
        stringBuilder.append("<Data>");
        stringBuilder.append(StringUtils.byteArrayToHexString((byte[])buffer.getData(), buffer.getLength(), buffer.getOffset()));
        stringBuilder.append("</Data>");
        stringBuilder.append("</Buffer>\n");
        outputStream.write(stringBuilder.toString().getBytes());
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat(null, -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new VideoFormat(null, null, -1, Format.byteArray, -1.0f)};
    }

    public void open() throws ResourceUnavailableException {
        super.open();
        if (!this.headerWritten) {
            try {
                this.outputHeader(this.getOutputStream());
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                throw new ResourceUnavailableException("" + iOException);
            }
            this.headerWritten = true;
        }
    }

    private void outputHeader(OutputStream outputStream) throws IOException {
        outputStream.write("<?xml version='1.0' encoding='utf-8'?>\n".getBytes());
        outputStream.write("<XmlMovie version=\"1.0\">\n".getBytes());
        outputStream.write("<Tracks>\n".getBytes());
        for (int i = 0; i < this.numTracks; ++i) {
            outputStream.write(("\t<Track index=\"" + i + "\" format=\"" + StringUtils.replaceSpecialXMLChars(FormatArgUtils.toString(this.inputFormats[i])) + "\"/>\n").getBytes());
        }
        outputStream.write("</Tracks>\n".getBytes());
    }

    private void outputTrailer(OutputStream outputStream) throws IOException {
        outputStream.write("</XmlMovie>\n".getBytes());
    }

    public Format setInputFormat(Format format, int n) {
        logger.finer("setInputFormat " + format + " " + n);
        boolean bl = false;
        for (Format format2 : this.getSupportedInputFormats()) {
            if (!format.matches(format2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            logger.warning("Input format does not match any supported input format: " + format);
            return null;
        }
        if (this.inputFormats != null) {
            this.inputFormats[n] = format;
        }
        return format;
    }
}

