/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.ulaw;

import com.lti.utils.UnsignedUtils;

public class MuLawEncoderUtil {
    public static final int BIAS = 132;
    public static final int MAX = 32635;
    private static byte[] pcmToMuLawMap = new byte[65536];

    private static byte encode(int n) {
        int n2 = (n & 0x8000) >> 8;
        if (n2 != 0) {
            n = -n;
        }
        if (n > 32635) {
            n = 32635;
        }
        n += 132;
        int n3 = 7;
        int n4 = 16384;
        while ((n & n4) == 0) {
            --n3;
            n4 >>= 1;
        }
        n4 = n >> n3 + 3 & 0xF;
        byte by = (byte)(n2 | n3 << 4 | n4);
        return ~by;
    }

    public static void muLawEncode(boolean bl, byte[] byArray, int n, int n2, byte[] byArray2) {
        if (bl) {
            MuLawEncoderUtil.muLawEncodeBigEndian(byArray, n, n2, byArray2);
        } else {
            MuLawEncoderUtil.muLawEncodeLittleEndian(byArray, n, n2, byArray2);
        }
    }

    public static byte muLawEncode(int n) {
        return pcmToMuLawMap[n & 0xFFFF];
    }

    public static byte muLawEncode(short s) {
        return pcmToMuLawMap[UnsignedUtils.uShortToInt(s)];
    }

    public static void muLawEncodeBigEndian(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = n2 / 2;
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = MuLawEncoderUtil.muLawEncode(byArray[n + 2 * i + 1] & 0xFF | (byArray[n + 2 * i] & 0xFF) << 8);
        }
    }

    public static void muLawEncodeLittleEndian(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = n2 / 2;
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = MuLawEncoderUtil.muLawEncode((byArray[n + 2 * i + 1] & 0xFF) << 8 | byArray[n + 2 * i] & 0xFF);
        }
    }

    public boolean getZeroTrap() {
        return pcmToMuLawMap[33000] != 0;
    }

    public void setZeroTrap(boolean bl) {
        byte by = (byte)(bl ? 2 : 0);
        for (int i = 32768; i <= 33924; ++i) {
            MuLawEncoderUtil.pcmToMuLawMap[i] = by;
        }
    }

    static {
        for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
            MuLawEncoderUtil.pcmToMuLawMap[UnsignedUtils.uShortToInt((short)((short)i))] = MuLawEncoderUtil.encode(i);
        }
    }
}

