/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.io.IOException;
import java.util.Vector;
import javax.media.BadHeaderException;
import javax.media.Demultiplexer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.PlugInManager;
import javax.media.ResourceUnavailableException;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.Positionable;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.SourceStream;
import net.sf.fmj.media.BasicModule;
import net.sf.fmj.media.BasicPlugIn;
import net.sf.fmj.media.Connector;
import net.sf.fmj.media.MyOutputConnector;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.SourceThread;
import net.sf.fmj.media.rtp.util.RTPTimeBase;

public class BasicSourceModule
extends BasicModule
implements Duration,
Positionable {
    PlaybackEngine engine;
    protected DataSource source;
    protected Demultiplexer parser;
    protected Track[] tracks = new Track[0];
    protected SourceThread[] loops;
    protected String[] connectorNames;
    protected long bitsRead = 0L;
    Object resetSync = new Object();
    protected boolean started = false;
    protected SystemTimeBase systemTimeBase = new SystemTimeBase();
    protected long lastSystemTime = 0L;
    protected long originSystemTime = 0L;
    protected long currentSystemTime = 0L;
    protected Time lastPositionSet = new Time(0L);
    RTPTimeBase rtpMapperUpdatable = null;
    RTPTimeBase rtpMapper = null;
    long currentRTPTime = 0L;
    long oldOffset = 0L;
    boolean rtpOffsetInvalid = true;
    String cname = null;
    public String errMsg = null;
    int latencyTrack = -1;

    protected static Demultiplexer createDemultiplexer(DataSource dataSource) throws IOException, IncompatibleSourceException {
        ContentDescriptor contentDescriptor = new ContentDescriptor(dataSource.getContentType());
        Vector vector = PlugInManager.getPlugInList(contentDescriptor, null, 1);
        Demultiplexer demultiplexer = null;
        IOException iOException = null;
        IncompatibleSourceException incompatibleSourceException = null;
        for (int i = 0; i < vector.size(); ++i) {
            try {
                Class<?> clazz = BasicPlugIn.getClassForName((String)vector.elementAt(i));
                Object obj = clazz.newInstance();
                if (!(obj instanceof Demultiplexer)) continue;
                demultiplexer = (Demultiplexer)obj;
                try {
                    demultiplexer.setSource(dataSource);
                    break;
                }
                catch (IOException iOException2) {
                    demultiplexer = null;
                    iOException = iOException2;
                    continue;
                }
                catch (IncompatibleSourceException incompatibleSourceException2) {
                    demultiplexer = null;
                    incompatibleSourceException = incompatibleSourceException2;
                    continue;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (demultiplexer == null) {
            if (iOException != null) {
                throw iOException;
            }
            if (incompatibleSourceException != null) {
                throw incompatibleSourceException;
            }
        }
        return demultiplexer;
    }

    public static BasicSourceModule createModule(DataSource dataSource) throws IOException, IncompatibleSourceException {
        Demultiplexer demultiplexer = BasicSourceModule.createDemultiplexer(dataSource);
        if (demultiplexer == null) {
            return null;
        }
        return new BasicSourceModule(dataSource, demultiplexer);
    }

    protected BasicSourceModule(DataSource dataSource, Demultiplexer demultiplexer) {
        this.source = dataSource;
        this.parser = demultiplexer;
        SourceStream sourceStream = null;
        if (this.source instanceof PullDataSource) {
            sourceStream = ((PullDataSource)this.source).getStreams()[0];
        } else if (this.source instanceof PushDataSource) {
            sourceStream = ((PushDataSource)this.source).getStreams()[0];
        }
    }

    public void abortPrefetch() {
        this.doStop();
    }

    public void abortRealize() {
        this.parser.stop();
        this.parser.close();
    }

    protected boolean checkAllPaused() {
        for (int i = 0; i < this.loops.length; ++i) {
            if (!this.tracks[i].isEnabled() || this.loops[i] == null || this.loops[i].isPaused()) continue;
            return false;
        }
        return true;
    }

    public void checkLatency() {
        if (this.latencyTrack > -1) {
            if (this.tracks[this.latencyTrack].isEnabled() && this.loops[this.latencyTrack] != null) {
                this.loops[this.latencyTrack].checkLatency = true;
                return;
            }
            this.latencyTrack = -1;
        }
        for (int i = 0; i < this.tracks.length; ++i) {
            if (!this.tracks[i].isEnabled()) continue;
            this.latencyTrack = i;
            if (this.tracks[i].getFormat() instanceof VideoFormat) break;
        }
        if (this.latencyTrack > -1 && this.loops[this.latencyTrack] != null) {
            this.loops[this.latencyTrack].checkLatency = true;
        }
    }

    SourceThread createSourceThread(int n) {
        SourceThread sourceThread = null;
        MyOutputConnector myOutputConnector = (MyOutputConnector)this.getOutputConnector(this.connectorNames[n]);
        if (myOutputConnector == null || myOutputConnector.getInputConnector() == null) {
            this.tracks[n].setEnabled(false);
            return null;
        }
        sourceThread = new SourceThread(this, myOutputConnector, n);
        if (this.tracks[n].getFormat() instanceof AudioFormat) {
            sourceThread.useAudioPriority();
        } else {
            sourceThread.useVideoPriority();
        }
        return sourceThread;
    }

    public void doClose() {
        this.parser.close();
        if (this.tracks == null) {
            return;
        }
        for (int i = 0; i < this.tracks.length; ++i) {
            if (this.loops[i] == null) continue;
            this.loops[i].kill();
        }
        if (this.rtpMapperUpdatable != null) {
            RTPTimeBase.returnMapperUpdatable(this.rtpMapperUpdatable);
            this.rtpMapperUpdatable = null;
        }
    }

    public void doDealloc() {
    }

    public void doFailedPrefetch() {
    }

    public void doFailedRealize() {
        this.parser.stop();
        this.parser.close();
    }

    public boolean doPrefetch() {
        super.doPrefetch();
        return true;
    }

    public boolean doRealize() {
        try {
            this.parser.open();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            this.errMsg = "Resource unavailable: " + resourceUnavailableException.getMessage();
            return false;
        }
        try {
            this.parser.start();
            this.tracks = this.parser.getTracks();
        }
        catch (BadHeaderException badHeaderException) {
            this.errMsg = "Bad header in the media: " + badHeaderException.getMessage();
            this.parser.close();
            return false;
        }
        catch (IOException iOException) {
            this.errMsg = "IO exception: " + iOException.getMessage();
            this.parser.close();
            return false;
        }
        if (this.tracks == null || this.tracks.length == 0) {
            this.errMsg = "The media has 0 track";
            this.parser.close();
            return false;
        }
        this.loops = new SourceThread[this.tracks.length];
        this.connectorNames = new String[this.tracks.length];
        for (int i = 0; i < this.tracks.length; ++i) {
            MyOutputConnector myOutputConnector = new MyOutputConnector(this.tracks[i]);
            myOutputConnector.setProtocol(0);
            myOutputConnector.setSize(1);
            this.connectorNames[i] = this.tracks[i].toString();
            this.registerOutputConnector(this.tracks[i].toString(), myOutputConnector);
            this.loops[i] = null;
        }
        this.engine = (PlaybackEngine)this.getController();
        if (this.engine == null || !this.engine.isRTP()) {
            this.parser.stop();
        }
        return true;
    }

    public void doStart() {
        this.lastSystemTime = this.systemTimeBase.getNanoseconds();
        this.originSystemTime = this.currentSystemTime;
        this.rtpOffsetInvalid = true;
        super.doStart();
        try {
            this.parser.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < this.loops.length; ++i) {
            if (!this.tracks[i].isEnabled() || this.loops[i] == null && (this.loops[i] = this.createSourceThread(i)) == null) continue;
            this.loops[i].start();
        }
        this.started = true;
    }

    public void doStop() {
        this.started = false;
    }

    public long getBitsRead() {
        return this.bitsRead;
    }

    public Object getControl(String string) {
        return this.parser.getControl(string);
    }

    public Object[] getControls() {
        return this.parser.getControls();
    }

    public Demultiplexer getDemultiplexer() {
        return this.parser;
    }

    public Time getDuration() {
        return this.parser.getDuration();
    }

    public String[] getOutputConnectorNames() {
        return this.connectorNames;
    }

    public boolean isPositionable() {
        return this.parser.isPositionable();
    }

    public boolean isRandomAccess() {
        return this.parser.isRandomAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.resetSync;
        synchronized (object) {
            for (int i = 0; i < this.loops.length; ++i) {
                if (!this.tracks[i].isEnabled() || this.loops[i] == null || this.loops[i].resetted) continue;
                this.loops[i].pause();
            }
            this.parser.stop();
        }
    }

    public void process() {
    }

    boolean readHasBlocked() {
        if (this.loops == null) {
            return false;
        }
        for (int i = 0; i < this.loops.length; ++i) {
            if (this.loops[i] == null || !this.loops[i].readBlocked) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.resetSync;
        synchronized (object) {
            super.reset();
            for (int i = 0; i < this.loops.length; ++i) {
                if (!this.tracks[i].isEnabled() || this.loops[i] == null && (this.loops[i] = this.createSourceThread(i)) == null) continue;
                this.loops[i].resetted = true;
                this.loops[i].start();
            }
        }
    }

    public void resetBitsRead() {
        this.bitsRead = 0L;
    }

    public void setFormat(Connector connector, Format format) {
    }

    public Time setPosition(Time time, int n) {
        Time time2 = this.parser.setPosition(time, n);
        this.lastPositionSet = this.lastPositionSet.getNanoseconds() == time2.getNanoseconds() ? new Time(time2.getNanoseconds() + 1L) : time2;
        return time2;
    }
}

