/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.util.ArrayList;
import java.util.List;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.ClockStoppedException;
import javax.media.ConfigureCompleteEvent;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DeallocateEvent;
import javax.media.Duration;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaTimeSetEvent;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.TransitionEvent;
import net.sf.fmj.media.BasicClock;
import net.sf.fmj.media.ConfigureWorkThread;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.PrefetchWorkThread;
import net.sf.fmj.media.RealizeWorkThread;
import net.sf.fmj.media.SendEventQueue;
import net.sf.fmj.media.StopTimeThread;
import net.sf.fmj.media.TimedStartThread;

public abstract class BasicController
implements Controller,
Duration {
    private int targetState = 100;
    protected int state = 100;
    private List<ControllerListener> listenerList = null;
    private SendEventQueue sendEvtQueue;
    private ConfigureWorkThread configureThread = null;
    private RealizeWorkThread realizeThread = null;
    private PrefetchWorkThread prefetchThread = null;
    protected String processError = null;
    private Clock clock;
    private TimedStartThread startThread = null;
    private StopTimeThread stopTimeThread = null;
    private boolean interrupted = false;
    private Object interruptSync = new Object();
    static final int Configuring = 140;
    static final int Configured = 180;
    protected boolean stopThreadEnabled = true;
    static String TimeBaseError = "Cannot set time base on an unrealized controller.";
    static String SyncStartError = "Cannot start the controller before it has been prefetched.";
    static String StopTimeError = "Cannot set stop time on an unrealized controller.";
    static String MediaTimeError = "Cannot set media time on a unrealized controller";
    static String GetTimeBaseError = "Cannot get Time Base from an unrealized controller";
    static String SetRateError = "Cannot set rate on an unrealized controller.";
    static String LatencyError = "Cannot get start latency from an unrealized controller";
    static String DeallocateError = "deallocate cannot be used on a started controller.";

    public BasicController() {
        this.sendEvtQueue = new SendEventQueue(this);
        this.sendEvtQueue.setName(this.sendEvtQueue.getName() + ": SendEventQueue: " + this.getClass().getName());
        this.sendEvtQueue.start();
        this.clock = new BasicClock();
    }

    protected void abortConfigure() {
    }

    protected abstract void abortPrefetch();

    protected abstract void abortRealize();

    private boolean activateStopThread(long l) {
        if (this.getStopTime().getNanoseconds() == Long.MAX_VALUE) {
            return false;
        }
        if (this.stopTimeThread != null && this.stopTimeThread.isAlive()) {
            this.stopTimeThread.abort();
            this.stopTimeThread = null;
        }
        if (l > 100000000L) {
            this.stopTimeThread = new StopTimeThread(this, l);
            this.stopTimeThread.start();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addControllerListener(ControllerListener controllerListener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<ControllerListener>();
        }
        List<ControllerListener> list = this.listenerList;
        synchronized (list) {
            if (!this.listenerList.contains(controllerListener)) {
                this.listenerList.add(controllerListener);
            }
        }
    }

    private long checkStopTime() {
        long l = this.getStopTime().getNanoseconds();
        if (l == Long.MAX_VALUE) {
            return 1L;
        }
        return (long)((float)(l - this.getMediaTime().getNanoseconds()) / this.getRate());
    }

    public final void close() {
        this.doClose();
        this.interrupt();
        if (this.startThread != null) {
            this.startThread.abort();
        }
        if (this.stopTimeThread != null) {
            this.stopTimeThread.abort();
        }
        if (this.sendEvtQueue != null) {
            this.sendEvtQueue.kill();
            this.sendEvtQueue = null;
        }
    }

    protected synchronized void completeConfigure() {
        this.state = 180;
        this.sendEvent(new ConfigureCompleteEvent(this, 140, 180, this.getTargetState()));
        if (this.getTargetState() >= 300) {
            this.realize();
        }
    }

    protected void completePrefetch() {
        this.clock.stop();
        this.state = 500;
        this.sendEvent(new PrefetchCompleteEvent(this, 400, 500, this.getTargetState()));
    }

    protected synchronized void completeRealize() {
        this.state = 300;
        this.sendEvent(new RealizeCompleteEvent(this, 200, 300, this.getTargetState()));
        if (this.getTargetState() >= 500) {
            this.prefetch();
        }
    }

    public synchronized void configure() {
        if (this.getTargetState() < 180) {
            this.setTargetState(180);
        }
        switch (this.state) {
            case 180: 
            case 200: 
            case 300: 
            case 400: 
            case 500: 
            case 600: {
                this.sendEvent(new ConfigureCompleteEvent(this, this.state, this.state, this.getTargetState()));
                break;
            }
            case 140: {
                break;
            }
            case 100: {
                this.state = 140;
                this.sendEvent(new TransitionEvent(this, 100, 140, this.getTargetState()));
                this.configureThread = new ConfigureWorkThread(this);
                this.configureThread.setName(this.configureThread.getName() + "[ " + this + " ]" + " ( configureThread)");
                this.configureThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deallocate() {
        int n = this.getState();
        if (this.state == 600) {
            this.throwError(new ClockStartedError(DeallocateError));
        }
        switch (this.state) {
            case 140: 
            case 200: {
                this.interrupt();
                this.state = 100;
                break;
            }
            case 400: {
                this.interrupt();
                this.state = 300;
                break;
            }
            case 500: {
                this.abortPrefetch();
                this.state = 300;
                this.resetInterrupt();
            }
        }
        this.setTargetState(this.state);
        this.doDeallocate();
        Object object = this.interruptSync;
        synchronized (object) {
            while (this.isInterrupted()) {
                try {
                    this.interruptSync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.sendEvent(new DeallocateEvent(this, n, this.state, this.state, this.getMediaTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void dispatchEvent(ControllerEvent controllerEvent) {
        if (this.listenerList == null) {
            return;
        }
        List<ControllerListener> list = this.listenerList;
        synchronized (list) {
            for (ControllerListener controllerListener : this.listenerList) {
                controllerListener.controllerUpdate(controllerEvent);
            }
        }
    }

    protected void doClose() {
    }

    protected boolean doConfigure() {
        return true;
    }

    protected void doDeallocate() {
    }

    protected void doFailedConfigure() {
        this.state = 100;
        this.setTargetState(100);
        String string = "Failed to configure";
        if (this.processError != null) {
            string = string + ": " + this.processError;
        }
        this.sendEvent(new ResourceUnavailableEvent(this, string));
        this.processError = null;
    }

    protected void doFailedPrefetch() {
        this.state = 300;
        this.setTargetState(300);
        String string = "Failed to prefetch";
        if (this.processError != null) {
            string = string + ": " + this.processError;
        }
        this.sendEvent(new ResourceUnavailableEvent(this, string));
        this.processError = null;
    }

    protected void doFailedRealize() {
        this.state = 100;
        this.setTargetState(100);
        String string = "Failed to realize";
        if (this.processError != null) {
            string = string + ": " + this.processError;
        }
        this.sendEvent(new ResourceUnavailableEvent(this, string));
        this.processError = null;
    }

    protected abstract boolean doPrefetch();

    protected abstract boolean doRealize();

    protected void doSetMediaTime(Time time) {
    }

    protected float doSetRate(float f) {
        return f;
    }

    protected abstract void doStart();

    protected void doStop() {
    }

    protected Clock getClock() {
        return this.clock;
    }

    public Control getControl(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Control[] controlArray = this.getControls();
        for (int i = 0; i < controlArray.length; ++i) {
            if (!clazz.isInstance(controlArray[i])) continue;
            return controlArray[i];
        }
        return null;
    }

    public Control[] getControls() {
        return new Control[0];
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public Time getStartLatency() {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(LatencyError));
        }
        return LATENCY_UNKNOWN;
    }

    public final int getState() {
        return this.state;
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    public Time getSyncTime() {
        return new Time(0L);
    }

    public final int getTargetState() {
        return this.targetState;
    }

    public TimeBase getTimeBase() {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(GetTimeBaseError));
        }
        return this.clock.getTimeBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interrupt() {
        Object object = this.interruptSync;
        synchronized (object) {
            this.interrupted = true;
            this.interruptSync.notify();
        }
    }

    protected abstract boolean isConfigurable();

    protected boolean isInterrupted() {
        return this.interrupted;
    }

    public Time mapToTimeBase(Time time) throws ClockStoppedException {
        return this.clock.mapToTimeBase(time);
    }

    public final void prefetch() {
        if (this.getTargetState() <= 300) {
            this.setTargetState(500);
        }
        switch (this.state) {
            case 500: 
            case 600: {
                this.sendEvent(new PrefetchCompleteEvent(this, this.state, this.state, this.getTargetState()));
                break;
            }
            case 140: 
            case 200: 
            case 400: {
                break;
            }
            case 100: 
            case 180: {
                this.realize();
                break;
            }
            case 300: {
                this.state = 400;
                this.sendEvent(new TransitionEvent(this, 300, 400, this.getTargetState()));
                this.prefetchThread = new PrefetchWorkThread(this);
                this.prefetchThread.setName(this.prefetchThread.getName() + " ( prefetchThread)");
                this.prefetchThread.start();
            }
        }
    }

    public final synchronized void realize() {
        if (this.getTargetState() < 300) {
            this.setTargetState(300);
        }
        switch (this.state) {
            case 300: 
            case 400: 
            case 500: 
            case 600: {
                this.sendEvent(new RealizeCompleteEvent(this, this.state, this.state, this.getTargetState()));
                break;
            }
            case 140: 
            case 200: {
                break;
            }
            case 100: {
                if (this.isConfigurable()) {
                    this.configure();
                    break;
                }
            }
            case 180: {
                int n = this.state;
                this.state = 200;
                this.sendEvent(new TransitionEvent(this, n, 200, this.getTargetState()));
                this.realizeThread = new RealizeWorkThread(this);
                this.realizeThread.setName(this.realizeThread.getName() + "[ " + this + " ]" + " ( realizeThread)");
                this.realizeThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeControllerListener(ControllerListener controllerListener) {
        if (this.listenerList == null) {
            return;
        }
        List<ControllerListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.remove(controllerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetInterrupt() {
        Object object = this.interruptSync;
        synchronized (object) {
            this.interrupted = false;
            this.interruptSync.notify();
        }
    }

    protected final void sendEvent(ControllerEvent controllerEvent) {
        if (this.sendEvtQueue != null) {
            this.sendEvtQueue.postEvent(controllerEvent);
        }
    }

    protected void setClock(Clock clock) {
        this.clock = clock;
    }

    protected void setMediaLength(long l) {
        if (this.clock instanceof BasicClock) {
            ((BasicClock)this.clock).setMediaLength(l);
        }
    }

    public void setMediaTime(Time time) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(MediaTimeError));
        }
        this.clock.setMediaTime(time);
        this.doSetMediaTime(time);
        this.sendEvent(new MediaTimeSetEvent(this, time));
    }

    public float setRate(float f) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(SetRateError));
        }
        float f2 = this.getRate();
        float f3 = this.doSetRate(f);
        float f4 = this.clock.setRate(f3);
        if (f4 != f2) {
            this.sendEvent(new RateChangeEvent(this, f4));
        }
        return f4;
    }

    public void setStopTime(Time time) {
        long l;
        if (this.state < 300) {
            this.throwError(new NotRealizedError(StopTimeError));
        }
        Time time2 = this.getStopTime();
        this.clock.setStopTime(time);
        boolean bl = false;
        if (this.state == 600 && ((l = this.checkStopTime()) < 0L || this.stopThreadEnabled && this.activateStopThread(l))) {
            bl = true;
        }
        if (time2.getNanoseconds() != time.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, time));
        }
        if (bl) {
            this.stopAtTime();
        }
    }

    protected final void setTargetState(int n) {
        this.targetState = n;
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(TimeBaseError));
        }
        this.clock.setTimeBase(timeBase);
    }

    public void stop() {
        if (this.state == 600 || this.state == 400) {
            this.stopControllerOnly();
            this.doStop();
        }
    }

    protected void stopAtTime() {
        this.stop();
        this.setStopTime(Clock.RESET);
        this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    protected void stopControllerOnly() {
        if (this.state == 600 || this.state == 400) {
            this.clock.stop();
            this.state = 500;
            this.setTargetState(500);
            if (this.stopTimeThread != null && this.stopTimeThread.isAlive() && Thread.currentThread() != this.stopTimeThread) {
                this.stopTimeThread.abort();
            }
            if (this.startThread != null && this.startThread.isAlive()) {
                this.startThread.abort();
            }
        }
    }

    public void syncStart(Time time) {
        if (this.state < 500) {
            this.throwError(new NotPrefetchedError(SyncStartError));
        }
        this.clock.syncStart(time);
        this.state = 600;
        this.setTargetState(600);
        this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), time));
        long l = this.checkStopTime();
        if (l < 0L || this.stopThreadEnabled && this.activateStopThread(l)) {
            this.stopAtTime();
            return;
        }
        this.startThread = new TimedStartThread(this, time.getNanoseconds());
        this.startThread.setName(this.startThread.getName() + " ( startThread: " + this + " )");
        this.startThread.start();
    }

    protected boolean syncStartInProgress() {
        return this.startThread != null && this.startThread.isAlive();
    }

    protected void throwError(Error error) {
        Log.dumpStack(error);
        throw error;
    }
}

