/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controlpanel;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.media.Player;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import net.sf.fmj.ejmf.toolkit.gui.controlpanel.AbstractControls;
import net.sf.fmj.ejmf.toolkit.gui.controls.AbstractListenerControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;

public abstract class AbstractControlPanel
extends JPanel {
    public static final int USE_START_CONTROL = 1;
    public static final int USE_STOP_CONTROL = 2;
    public static final int USE_REVERSE_CONTROL = 4;
    public static final int USE_PAUSE_CONTROL = 8;
    public static final int USE_GAIN_CONTROL = 16;
    public static final int USE_FF_CONTROL = 32;
    public static final int USE_PROGRESS_CONTROL = 64;
    public static final int USE_GAINMETER_CONTROL = 128;
    private AbstractControls controls;
    protected final Skin skin;

    protected AbstractControlPanel(Skin skin, Player player) {
        this(skin, player, -1);
    }

    protected AbstractControlPanel(Skin skin, Player player, int n) {
        this.skin = skin;
        this.setControlPanelLayout();
        this.setControlPanelBorder();
        this.controls = this.createControls(player);
        this.addComponents(n);
    }

    protected abstract void addComponents(int var1);

    protected abstract AbstractControls createControls(Player var1);

    public AbstractListenerControl getControl(String string) {
        return this.controls.getControl(string);
    }

    protected AbstractControls getControls() {
        return this.controls;
    }

    protected void removeControlComponents() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.remove(i);
        }
    }

    protected void replaceControlComponent(Component component, Component component2) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (component != this.getComponent(i)) continue;
            this.replaceControlComponent(component2, i);
            break;
        }
    }

    protected void replaceControlComponent(Component component, int n) {
        this.remove(n);
        this.add(component, n);
    }

    protected void setControlPanelBorder() {
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    protected void setControlPanelLayout() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(5);
        this.setLayout(flowLayout);
    }
}

