/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H261Format
extends VideoFormat {
    protected int stillImageTransmission = -1;
    private static String ENCODING = "h261";

    public H261Format() {
        super(ENCODING);
        this.dataType = Format.byteArray;
    }

    public H261Format(Dimension dimension, int n, Class<?> clazz, float f, int n2) {
        super(ENCODING, dimension, n, clazz, f);
        this.stillImageTransmission = n2;
    }

    @Override
    public Object clone() {
        return new H261Format(FormatUtils.clone(this.size), this.maxDataLength, this.dataType, this.frameRate, this.stillImageTransmission);
    }

    @Override
    protected void copy(Format format) {
        super.copy(format);
        H261Format h261Format = (H261Format)format;
        this.stillImageTransmission = h261Format.stillImageTransmission;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof H261Format)) {
            return false;
        }
        H261Format h261Format = (H261Format)object;
        return this.stillImageTransmission == h261Format.stillImageTransmission;
    }

    public int getStillImageTransmission() {
        return this.stillImageTransmission;
    }

    @Override
    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format instanceof H261Format) {
            H261Format h261Format = (H261Format)format2;
            H261Format h261Format2 = (H261Format)format;
            if (this.getClass().isAssignableFrom(format.getClass())) {
                if (FormatUtils.specified(this.stillImageTransmission)) {
                    h261Format.stillImageTransmission = this.stillImageTransmission;
                }
            } else if (format.getClass().isAssignableFrom(this.getClass()) && !FormatUtils.specified(h261Format.stillImageTransmission)) {
                h261Format.stillImageTransmission = h261Format2.stillImageTransmission;
            }
        }
        FormatTraceUtils.traceIntersects(this, format, format2);
        return format2;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            FormatTraceUtils.traceMatches(this, format, false);
            return false;
        }
        if (!(format instanceof H261Format)) {
            FormatTraceUtils.traceMatches(this, format, true);
            return true;
        }
        H261Format h261Format = (H261Format)format;
        boolean bl = FormatUtils.matches(this.stillImageTransmission, h261Format.stillImageTransmission);
        FormatTraceUtils.traceMatches(this, format, bl);
        return bl;
    }

    @Override
    public String toString() {
        return "H.261 video format";
    }
}

