/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.weupnp;

import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bitlet.weupnp.GatewayDevice;
import org.bitlet.weupnp.GatewayDiscover;
import org.bitlet.weupnp.LogUtils;
import org.bitlet.weupnp.PortMappingEntry;

public class Main {
    private static int SAMPLE_PORT = 6991;
    private static short WAIT_TIME = (short)10;

    public static void main(String[] stringArray) throws Exception {
        Logger logger = LogUtils.getLogger();
        logger.info("Starting weupnp");
        GatewayDiscover gatewayDiscover = new GatewayDiscover();
        logger.info("Looking for Gateway Devices");
        gatewayDiscover.discover();
        GatewayDevice gatewayDevice = gatewayDiscover.getValidGateway();
        if (null == gatewayDevice) {
            logger.info("No valid gateway device found.");
            return;
        }
        logger.log(Level.INFO, "Gateway device found.\n{0} ({1})", new Object[]{gatewayDevice.getModelName(), gatewayDevice.getModelDescription()});
        InetAddress inetAddress = gatewayDevice.getLocalAddress();
        logger.log(Level.INFO, "Using local address: {0}", inetAddress);
        String string = gatewayDevice.getExternalIPAddress();
        logger.log(Level.INFO, "External address: {0}", string);
        PortMappingEntry portMappingEntry = new PortMappingEntry();
        logger.log(Level.INFO, "Attempting to map port {0}", SAMPLE_PORT);
        logger.log(Level.INFO, "Querying device to see if mapping for port {0} already exists", SAMPLE_PORT);
        if (!gatewayDevice.getSpecificPortMappingEntry(SAMPLE_PORT, "TCP", portMappingEntry)) {
            logger.info("Sending port mapping request");
            if (gatewayDevice.addPortMapping(SAMPLE_PORT, SAMPLE_PORT, inetAddress.getHostAddress(), "TCP", "test")) {
                logger.log(Level.INFO, "Mapping succesful: waiting {0} seconds before removing mapping.", WAIT_TIME);
                Thread.sleep(1000 * WAIT_TIME);
                gatewayDevice.deletePortMapping(SAMPLE_PORT, "TCP");
                logger.info("Port mapping removed");
                logger.info("Test SUCCESSFUL");
            } else {
                logger.info("Port mapping removal failed");
                logger.info("Test FAILED");
            }
        } else {
            logger.info("Port was already mapped. Aborting test.");
        }
        logger.info("Stopping weupnp");
    }
}

